{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Include source code for Trinity.

* ASSOCIATED FILES
TRINITY.PAS
ADDWEEK.INC
ASSIGN.INC
AUDIT.INC
CURSOR.PAS
DATE.PAS
DBLLNBOX.PAS
DISPLAY.INC
EDIT.INC
FLUSHKEY.PAS
INITIAL.INC
LISTING.INC
PREPARE.INC
PRINTIT.INC
SGLLNBOX.PAS
TRINITY.DOC
TRINITY.EXE

}
PROCEDURE  EditEnvelopeData;                        (* This File: EDIT.INC *)

(* Editor for previously entered data.  Allows change of name, address,
   and financial data.   Use with TURBO Pascal Version 4.0.
   Last Revision:     April 12, 1988                                       *)


TYPE
  ContributionsRecord = RECORD
                          EnvelopeNumber            : LONGINT;
                          Name,
                          Address,
                          CityStateZip              : TextString;
                          TotalPledge,
                          FstQtrLocalOperations,
                          FstQtrBenevolence,
                          FstQtrBuildingMaint,
                          FstQtrFlowers,
                          FstQtrSeasonal,
                          FstQtrSpecial,
                          FstQtrImprovement,
                          SndQtrLocalOperations,
                          SndQtrBenevolence,
                          SndQtrBuildingMaint,
                          SndQtrFlowers,
                          SndQtrSeasonal,
                          SndQtrSpecial,
                          SndQtrImprovement,
                          TrdQtrLocalOperations,
                          TrdQtrBenevolence,
                          TrdQtrBuildingMaint,
                          TrdQtrFlowers,
                          TrdQtrSeasonal,
                          TrdQtrSpecial,
                          TrdQtrImprovement,
                          FthQtrLocalOperations,
                          FthQtrBenevolence,
                          FthQtrBuildingMaint,
                          FthQtrFlowers,
                          FthQtrSeasonal,
                          FthQtrSpecial,
                          FthQtrImprovement         : REAL
                        END;

  MessageString       = STRING [26];

VAR
  Contributions       : FILE of ContributionsRecord;
  Offerings           : ContributionsRecord;
  Choice              : CHAR;
  Number,
  Maximum             : LONGINT;
  Error               : INTEGER;
  ErrorCheck,
  Quarter,
  Line                : BYTE;
  FileName            : DOSString;
  Message             : MessageString;

(*-------------------------------------------------------------------------*)

PROCEDURE  Eraser;                                  (* Editing Menu eraser *)

BEGIN
  Window (1,10,80,22);
  ClrScr;
  Window (1,1,80,25)
END;                                         (* End of Editing Menu eraser *)

(*-------------------------------------------------------------------------*)

PROCEDURE  AskForChange (Line : BYTE; Message : MessageString;
                                VAR  ItemToChange : TextString);

BEGIN
  GoToXY (23,Line);
    ClrEOL;
  Eraser;
  GoToXY (10,10);
    Write (Message);
    CursorOn;
    Readln (ItemToChange);
    CursorOff;
  GoToXY (1,10);
    ClrEOL;
  GoToXY (23,Line);
    Write (ItemToChange)
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  NameChange (Number : LONGINT);

VAR
  ItemToChange : TextString;
  TempString   : TextString;

BEGIN
  Line := 3;
  Message := '          Change Name to: ';
  TempString   := Offerings.Name;
  AskForChange (Line, Message, ItemToChange);

  IF ItemToChange = ''
    THEN
      BEGIN
        Offerings.Name := TempString;
        GoToXY (23,Line);
          Write (TempString)
      END
    ELSE Offerings.Name := ItemToChange;

  Seek (Contributions, Number);
  Write (Contributions, Offerings)
END;                                                   (* End of Edit Name *)

(*-------------------------------------------------------------------------*)

PROCEDURE  AddressChange (Number : LONGINT);

VAR
  ItemToChange : TextString;
  TempString   : TextString;

BEGIN
  Line := 4;
  Message := '       Change Address to: ';
  TempString   := Offerings.Address;
  AskForChange (Line, Message, ItemToChange);

  IF ItemToChange = ''
    THEN
      BEGIN
        Offerings.Address := TempString;
        GoToXY (23,Line);
          Write (TempString)
      END
    ELSE Offerings.Address := ItemToChange;

  Seek (Contributions, Number);
  Write (Contributions, Offerings)
END;                                                (* End of Edit Address *)

(*-------------------------------------------------------------------------*)

PROCEDURE  CityChange (Number : LONGINT);

VAR
  ItemToChange : TextString;
  TempString   : TextString;

BEGIN
  Line := 5;
  Message := 'Change City/State/Zip to: ';
  TempString   := Offerings.CityStateZip;
  AskForChange (Line, Message, ItemToChange);

  IF ItemToChange = ''
    THEN
      BEGIN
        Offerings.CityStateZip := TempString;
        GoToXY (23,Line);
          Write (TempString)
      END
    ELSE Offerings.CityStateZip := ItemToChange;

  Seek (Contributions, Number);
  Write (Contributions, Offerings)
END;                                         (* End of Edit City/State/Zip *)

(*-------------------------------------------------------------------------*)

PROCEDURE  PledgeChange (Number : LONGINT);

VAR
  Error          : INTEGER;
  ItemToChange,
  TempReal       : REAL;
  NoChange       : BOOLEAN;

BEGIN
  TempReal := Offerings.TotalPledge;
  GoToXY (23,6);
    ClrEOL;
  Eraser;
  GoToXY (10,10);
    Write ('  Change Total Pledge to: ');
    CursorOn;
    GetRealEntry (ItemToChange, Error, NoChange);

      WHILE (Error <> 0) DO
        BEGIN
          GoToXY (36,10);
            ClrEOL;
          GoToXY (36,10);
          GetRealEntry (ItemToChange, Error, NoChange)
        END;

    CursorOff;

    IF NoChange
      THEN Offerings.TotalPledge := TempReal
      ELSE Offerings.TotalPledge := ItemToChange;

    Seek (Contributions, Number);
    Write (Contributions, Offerings);
  GoToXY (1,10);
    ClrEOL;
  GoToXY (23,6);
    Write (Offerings.TotalPledge : 10 : 2)

END;                                           (* End of Edit Total Pledge *)

(*-------------------------------------------------------------------------*)

PROCEDURE  EditNameAddress (Number : LONGINT);

                        (* Name, Address and Pledge Display, and Edit Menu *)
BEGIN
  ClrScr;
  Seek (Contributions, Number);
  Read (Contributions, Offerings);

  WITH Offerings DO
    BEGIN
      GoToXY (6,2);
        Write ('Envelope Number: ', EnvelopeNumber);
      GoToXY (6,3);
        Write ('           Name: ', Name);
      GoToXY (6,4);
        Write ('        Address: ', Address);
      GoToXY (6,5);
        Write (' City/State/Zip: ', CityStateZip);
      GoToXY (6,6);
        Write ('   Total Pledge: ', TotalPledge : 10 : 2)
    END;

  REPEAT
    GoToXY (16,10);
      Write ('Which item do you wish to change?');
    GoToXY (16,12);
      Write ('Press N to edit Name.');
    GoToXY (16,13);
      Write ('Press A to edit Address.');
    GoToXY (16,14);
      Write ('Press C to edit City/State/Zip.');
    GoToXY (16,15);
      Write ('Press P to edit Total Pledge.');
    GotoXY (16,17);
      Write ('Press E to Exit.');
    GoToXY (27,22);
      Write ('Your Choice: ');
      CursorOn;

    REPEAT
      FlushKeyBuffer;
      Choice := ReadKey
    UNTIL Choice IN ['N', 'n', 'A', 'a', 'C', 'c', 'P', 'p', 'E', 'e'];

    CursorOff;

    CASE Choice OF
      'N', 'n' : NameChange (Number);
      'A', 'a' : AddressChange (Number);
      'C', 'c' : CityChange (Number);
      'P', 'p' : PledgeChange (Number)
    END

  UNTIL (Choice = 'E') OR (Choice = 'e');

  CursorOn
END;                                     (* End of Editing of Name/Address *)

(*-------------------------------------------------------------------------*)

PROCEDURE  AskForLocalChange (VAR ThisQtrLocal : REAL);

VAR
  Error          : INTEGER;
  ItemToChange,
  TempReal       : REAL;
  NoChange       : BOOLEAN;

BEGIN
  TempReal := ThisQtrLocal;
  GoToXY (31,3);
    ClrEOL;
  Eraser;
  GoToXY (10,13);
    Write ('Change Local Operations to: ');
  CursorOn;
  GetRealEntry (ItemToChange, Error, NoChange);

    WHILE (Error <> 0) Do
      BEGIN
        GoToXY (38,13);
          ClrEOL;
        GoToXY (38,13);
        GetRealEntry (ItemToChange, Error, NoChange)
      END;

    IF NoChange
      THEN ThisQtrLocal := TempReal
      ELSE ThisQtrLocal := ItemToChange;

  CursorOff;
  GoToXY (1,13);
    ClrEOL;
  GoToXY (31,3);
    Write (ThisQtrLocal : 10 : 2)
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  LocalChange (Number : LONGINT; Quarter : BYTE);

BEGIN
  CASE Quarter OF
    1 : BEGIN
          AskForLocalChange (Offerings.FstQtrLocalOperations);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    2 : BEGIN
          AskForLocalChange (Offerings.SndQtrLocalOperations);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    3 : BEGIN
          AskForLocalChange (Offerings.TrdQtrLocalOperations);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    4 : BEGIN
          AskForLocalChange (Offerings.FthQtrLocalOperations);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END
    END
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  AskForBenevolenceChange (VAR ThisQtrBenevolence : REAL);

VAR
  Error          : INTEGER;
  ItemToChange,
  TempReal       : REAL;
  NoChange       : BOOLEAN;

BEGIN
  TempReal := ThisQtrBenevolence;
  GoToXY (31,4);
    ClrEOL;
  Eraser;
  GoToXY (10,13);
    Write ('Change Benevolence to: ');
  CursorOn;
  GetRealEntry (ItemToChange, Error, NoChange);

    WHILE (Error <> 0) Do
      BEGIN
        GoToXY (33,13);
          ClrEOL;
        GoToXY (33,13);
        GetRealEntry (ItemToChange, Error, NoChange)
      END;

    IF NoChange
      THEN ThisQtrBenevolence := TempReal
      ELSE ThisQtrBenevolence := ItemToChange;

  CursorOff;
  GoToXY (1,13);
    ClrEOL;
  GoToXY (31,4);
    Write (ThisQtrBenevolence : 10 : 2)
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  BenevolenceChange (Number : LONGINT; Quarter : BYTE);

BEGIN
  CASE Quarter OF
    1 : BEGIN
          AskForBenevolenceChange (Offerings.FstQtrBenevolence);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    2 : BEGIN
          AskForBenevolenceChange (Offerings.SndQtrBenevolence);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    3 : BEGIN
          AskForBenevolenceChange (Offerings.TrdQtrBenevolence);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    4 : BEGIN
          AskForBenevolenceChange (Offerings.FthQtrBenevolence);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END
    END
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  AskForBuildingChange (VAR ThisQtrBuilding : REAL);

VAR
  Error          : INTEGER;
  ItemToChange,
  TempReal       : REAL;
  NoChange       : BOOLEAN;

BEGIN
  TempReal := ThisQtrBuilding;
  GoToXY (31,5);
    ClrEOL;
  Eraser;
    GoToXY (10,13);
  Write ('Change Building Maintenance to: ');
    CursorOn;
  GetRealEntry (ItemToChange, Error, NoChange);

    WHILE (Error <> 0) Do
      BEGIN
        GoToXY (42,13);
          ClrEOL;
        GoToXY (42,13);
        GetRealEntry (ItemToChange, Error, NoChange)
      END;

    IF NoChange
      THEN ThisQtrBuilding := TempReal
      ELSE ThisQtrBuilding := ItemToChange;

  CursorOff;
  GoToXY (1,13);
    ClrEOL;
  GoToXY (31,5);
    Write (ThisQtrBuilding : 10 : 2)
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  BuildingMaintChange (Number : LONGINT; Quarter : BYTE);

BEGIN
  CASE Quarter OF
    1 : BEGIN
          AskForBuildingChange (Offerings.FstQtrBuildingMaint);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    2 : BEGIN
          AskForBuildingChange (Offerings.SndQtrBuildingMaint);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    3 : BEGIN
          AskForBuildingChange (Offerings.TrdQtrBuildingMaint);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    4 : BEGIN
          AskForBuildingChange (Offerings.FthQtrBuildingMaint);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END
    END
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  AskForFlowersChange (VAR ThisQtrFlowers : REAL);

VAR
  Error          : INTEGER;
  ItemToChange,
  TempReal       : REAL;
  NoChange       : BOOLEAN;

BEGIN
  TempReal := ThisQtrFlowers;
  GoToXY (31,6);
    ClrEOL;
  Eraser;
  GoToXY (10,13);
    Write ('Change Flowers to: ');
  CursorOn;
  GetRealEntry (ItemToChange, Error, NoChange);

    WHILE (Error <> 0) Do
      BEGIN
        GoToXY (29,13);
          ClrEOL;
        GoToXY (29,13);
        GetRealEntry (ItemToChange, Error, NoChange)
      END;

    IF NoChange
      THEN ThisQtrFlowers := TempReal
      ELSE ThisQtrFlowers := ItemToChange;

  CursorOff;
  GoToXY (1,13);
    ClrEOL;
  GoToXY (31,6);
    Write (ThisQtrFlowers : 10 : 2)
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  FlowersChange (Number : LONGINT; Quarter : BYTE);

BEGIN
  CASE Quarter OF
    1 : BEGIN
          AskForFlowersChange (Offerings.FstQtrFlowers);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    2 : BEGIN
          AskForFlowersChange (Offerings.SndQtrFlowers);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    3 : BEGIN
          AskForFlowersChange (Offerings.TrdQtrFlowers);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    4 : BEGIN
          AskForFlowersChange (Offerings.FthQtrFlowers);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END
    END
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  AskForSeasonalChange (VAR ThisQtrSeasonal : REAL);

VAR
  Error          : INTEGER;
  ItemToChange,
  TempReal       : REAL;
  NoChange       : BOOLEAN;

BEGIN
  TempReal := ThisQtrSeasonal;
  GoToXY (31,7);
    ClrEOL;
  Eraser;
  GoToXY (10,13);
    Write ('Change Seasonal to: ');
  CursorOn;
  GetRealEntry (ItemToChange, Error, NoChange);

    WHILE (Error <> 0) Do
      BEGIN
        GoToXY (30,13);
          ClrEOL;
        GoToXY (30,13);
        GetRealEntry (ItemToChange, Error, NoChange)
      END;

    IF NoChange
      THEN ThisQtrSeasonal := TempReal
      ELSE ThisQtrSeasonal := ItemToChange;

  CursorOff;
  GoToXY (1,13);
    ClrEOL;
  GoToXY (31,7);
    Write (ThisQtrSeasonal : 10 : 2)
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  SeasonalChange (Number : LONGINT; Quarter : BYTE);

BEGIN
  CASE Quarter OF
    1 : BEGIN
          AskForSeasonalChange (Offerings.FstQtrSeasonal);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    2 : BEGIN
          AskForSeasonalChange (Offerings.SndQtrSeasonal);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    3 : BEGIN
          AskForSeasonalChange (Offerings.TrdQtrSeasonal);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    4 : BEGIN
          AskForSeasonalChange (Offerings.FthQtrSeasonal);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END
    END
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  AskForSpecialChange (VAR ThisQtrSpecial : REAL);

VAR
  Error          : INTEGER;
  ItemToChange,
  TempReal       : REAL;
  NoChange       : BOOLEAN;

BEGIN
  TempReal := ThisQtrSpecial;
  GoToXY (31,8);
    ClrEOL;
  Eraser;
  GoToXY (10,13);
    Write ('Change Special to: ');
  CursorOn;
  GetRealEntry (ItemToChange, Error, NoChange);

    WHILE (Error <> 0) Do
      BEGIN
        GoToXY (29,13);
          ClrEOL;
        GoToXY (29,13);
        GetRealEntry (ItemToChange, Error, NoChange)
      END;

    IF NoChange
      THEN ThisQtrSpecial := TempReal
      ELSE ThisQtrSpecial := ItemToChange;

  CursorOff;
  GoToXY (1,13);
    ClrEOL;
  GoToXY (31,8);
    Write (ThisQtrSpecial : 10 : 2)
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  SpecialChange (Number : LONGINT; Quarter : BYTE);

BEGIN
  CASE Quarter OF
    1 : BEGIN
          AskForSpecialChange (Offerings.FstQtrSpecial);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    2 : BEGIN
          AskForSpecialChange (Offerings.SndQtrSpecial);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    3 : BEGIN
          AskForSpecialChange (Offerings.TrdQtrSpecial);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    4 : BEGIN
          AskForSpecialChange (Offerings.FthQtrSpecial);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END
    END
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  AskForImprovementChange (VAR ThisQtrImprovement : REAL);

VAR
  Error          : INTEGER;
  ItemToChange,
  TempReal       : REAL;
  NoChange       : BOOLEAN;

BEGIN
  TempReal := ThisQtrImprovement;
  GoToXY (31,9);
    ClrEOL;
  Eraser;
  GoToXY (10,13);
    Write ('Change Improvement Fund to: ');
  CursorOn;
  GetRealEntry (ItemToChange, Error, NoChange);

    WHILE (Error <> 0) Do
      BEGIN
        GoToXY (38,13);
          ClrEOL;
        GoToXY (38,13);
        GetRealEntry (ItemToChange, Error, NoChange)
      END;

    IF NoChange
      THEN ThisQtrImprovement := TempReal
      ELSE ThisQtrImprovement := ItemToChange;


  CursorOff;
  GoToXY (1,13);
    ClrEOL;
  GoToXY (31,9);
    Write (ThisQtrImprovement : 10 : 2)
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  ImprovementChange (Number : LONGINT; Quarter : BYTE);

BEGIN
  CASE Quarter OF
    1 : BEGIN
          AskForImprovementChange (Offerings.FstQtrImprovement);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    2 : BEGIN
          AskForImprovementChange (Offerings.SndQtrImprovement);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    3 : BEGIN
          AskForImprovementChange (Offerings.TrdQtrImprovement);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END;

    4 : BEGIN
          AskForImprovementChange (Offerings.FthQtrImprovement);
          Seek (Contributions, Number);
          Write (Contributions, Offerings)
        END
    END
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  EditQtr (Number : LONGINT; Quarter : BYTE);    (* Data Display
                                                                  and Menu *)
VAR
  LocalOperations,                         (* Use to edit selected quarter *)
  Benevolence,
  BuildingMaint,
  Flowers,
  Seasonal,
  Special,
  Improvement      : REAL;

BEGIN
  ClrScr;
  Seek (Contributions, Number);
  Read (Contributions, Offerings);

  WITH Offerings DO
    BEGIN

      CASE Quarter OF
        1 : BEGIN
              LocalOperations := FstQtrLocalOperations;
              Benevolence     := FstQtrBenevolence;
              BuildingMaint   := FstQtrBuildingMaint;
              Flowers         := FstQtrFlowers;
              Seasonal        := FstQtrSeasonal;
              Special         := FstQtrSpecial;
              Improvement     := FstQtrImprovement
            END;

        2 : BEGIN
              LocalOperations := SndQtrLocalOperations;
              Benevolence     := SndQtrBenevolence;
              BuildingMaint   := SndQtrBuildingMaint;
              Flowers         := SndQtrFlowers;
              Seasonal        := SndQtrSeasonal;
              Special         := SndQtrSpecial;
              Improvement     := SndQtrImprovement
            END;

        3 : BEGIN
              LocalOperations := TrdQtrLocalOperations;
              Benevolence     := TrdQtrBenevolence;
              BuildingMaint   := TrdQtrBuildingMaint;
              Flowers         := TrdQtrFlowers;
              Seasonal        := TrdQtrSeasonal;
              Special         := TrdQtrSpecial;
              Improvement     := TrdQtrImprovement
            END;

        4 : BEGIN
              LocalOperations := FthQtrLocalOperations;
              Benevolence     := FthQtrBenevolence;
              BuildingMaint   := FthQtrBuildingMaint;
              Flowers         := FthQtrFlowers;
              Seasonal        := FthQtrSeasonal;
              Special         := FthQtrSpecial;
              Improvement     := FthQtrImprovement
            END
        END;                                   (* End of CASE *)

      GoToXY (6,2);
        Write ('        Envelope Number: ', EnvelopeNumber);
      GoToXY (50,2);
        Write ('Quarter: ', Quarter);
      GoToXY (6,3);
        Write ('       Local Operations: ', LocalOperations : 10 : 2);
      GoToXY (6,4);
        Write ('Church-Wide Benevolence: ', Benevolence : 10 : 2);
      GoToXY (6,5);
        Write ('   Building Maintenance: ', BuildingMaint : 10 : 2);
      GoToXY (6,6);
        Write ('                Flowers: ', Flowers : 10 : 2);
      GoToXY (6,7);
        Write ('               Seasonal: ', Seasonal : 10 : 2);
      GoToXY (6,8);
        Write ('                Special: ', Special : 10 : 2);
      GoToXY (6,9);
        Write ('       Improvement Fund: ', Improvement : 10 : 2)

  END;                                                      (* End of WITH *)

  REPEAT
    GoToXY (16,11);
      Write ('Which item do you wish to change?');
    GoToXY (16,13);
      Write ('Press L to change Local Operations.');
    GoToXY (16,14);
      Write ('Press B to change Benevolence.');
    GoToXY (16,15);
      Write ('Press M to change Building Maintenance.');
    GoToXY (16,16);
      Write ('Press F to change Flowers.');
    GoToXY (16,17);
      Write ('Press S to change Seasonal.');
    GoToXY (16,18);
      Write ('Press P to change Special.');
    GoToXY (16,19);
      Write ('Press I to change Improvement Fund.');
    GotoXY (16,20);
      Write ('Press E to Exit this Menu.');
    GoToXY (27,22);
      Write ('Your Choice: ');
      CursorOn;

    REPEAT
      FlushKeyBuffer;
      Choice := ReadKey
    UNTIL Choice IN ['L', 'l', 'B', 'b', 'M', 'm', 'F', 'f',
                            'S', 's', 'P', 'p', 'I', 'i', 'E', 'e'];
    CursorOff;

    CASE Choice OF
     'L', 'l' : LocalChange (Number, Quarter);
     'B', 'b' : BenevolenceChange (Number, Quarter);
     'M', 'm' : BuildingMaintChange (Number, Quarter);
     'F', 'f' : FlowersChange (Number, Quarter);
     'S', 's' : SeasonalChange (Number, Quarter);
     'P', 'p' : SpecialChange (Number, Quarter);
     'I', 'i' : ImprovementChange (Number, Quarter)
    END

  UNTIL (Choice = 'E') OR (Choice = 'e');

  CursorOn
END;                               (* End of procedure to edit any quarter *)

(*-------------------------------------------------------------------------*)

BEGIN                                 (* Start main editing procedure here *)
  ClrScr;
  CursorOff;
  GoToXY (19,3);
    Write ('Edit Data for a Specified Envelope Number:');
  GoToXY (15,5);
    Write ('Please give the name of the Contributions File');
  GoToXY (15,6);
    Write ('that you wish to open for Editing: ');
  CursorOn;
  Readln (FileName);
  CursorOff;

  Assign (Contributions, FileName);
  {$I-}
  Reset (Contributions);
  {$I+}
  ErrorCheck := IOResult;

  IF ErrorCheck <> 0
    THEN
      BEGIN
        ErrorMessageTwo;
        EditEnvelopeData                 (* Again, allow for typing errors *)
      END
    ELSE
      BEGIN
        ClrScr;
        Maximum := FileSize (Contributions);

        REPEAT
          GoToXY (13,3);
            Write ('Current Envelopes are numbered 1 to ');
            Write ((Maximum - 1), '.');
          GoToXY (13,5);
            Write ('Data are to be Edited for which Envelope Number? ');
          CursorOn;
          GetLongIntegerEntry (Number, Error);
          CursorOff;

            WHILE (Error <> 0) DO
              BEGIN
                GoToXY (62,5);
                  ClrEOL;
                GoToXY (62,5);
                CursorOn;
                GetLongIntegerEntry (Number, Error);
                CursorOff
              END;

          IF (Number < 1) OR (Number > (Maximum - 1))
            THEN ErrorMessageThree

        UNTIL (Number > 0) AND (Number < Maximum);

(* This editing menu selects alpha or money fields to edit and which quarter
   will be edited.  The next deeper menu will select which field from the
   cluster provided by this selection process.                             *)

        GoToXY (10,8);
          Write ('Please indicate which part of the data is to be');
          Write (' edited: ');
        GoToXY (18,10);
          Write ('Press N to edit Name/Address/Pledge data.');
        GoToXY (18,11);
          Write ('Press 1 to edit 1st Quarter totals.');
        GoToXY (18,12);
          Write ('Press 2 to edit 2nd Quarter totals.');
        GoToXY (18,13);
          Write ('Press 3 to edit 3rd Quarter totals.');
        GoToXY (18,14);
          Write ('Press 4 to edit 4th Quarter totals.');
        GoToXY (25,17);
          Write ('Your Choice: ');
        CursorOn;

        REPEAT
          FlushKeyBuffer;
          Choice := ReadKey
        UNTIL Choice IN ['N', 'n', '1', '2', '3', '4'];

        CursorOff;

        CASE Choice OF
          'N', 'n' : EditNameAddress (Number);
          '1'      : BEGIN
                       Quarter := 1;
                       EditQtr (Number, Quarter)
                     END;

          '2'      : BEGIN
                       Quarter := 2;
                       EditQtr (Number, Quarter)
                     END;

          '3'      : BEGIN
                       Quarter := 3;
                       EditQtr (Number, Quarter)
                     END;

          '4'      : BEGIN
                       Quarter := 4;
                       EditQtr (Number, Quarter)
                     END
        END;
        Close (Contributions)
      END;                                 (* End of IF/THEN/ELSE *)

  ClrScr
END;                                          (* End of Editor *)

(***************************************************************************)

