{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Include source code for Trinity.

* ASSOCIATED FILES
TRINITY.PAS
ADDWEEK.INC
ASSIGN.INC
AUDIT.INC
CURSOR.PAS
DATE.PAS
DBLLNBOX.PAS
DISPLAY.INC
EDIT.INC
FLUSHKEY.PAS
INITIAL.INC
LISTING.INC
PREPARE.INC
PRINTIT.INC
SGLLNBOX.PAS
TRINITY.DOC
TRINITY.EXE

}
PROCEDURE  DisplayQuarterlyStatement;

(* This File : DISPLAY.INC    Allows the user to display a copy of the
   quarterly statement for a specified envelope number.

   Last revision:  April 19, 1988                                     *)


TYPE
  ContributionsRecord = RECORD
                          EnvelopeNumber            : LONGINT;
                          Name,
                          Address,
                          CityStateZip              : TextString;
                          TotalPledge,
                          FstQtrLocalOperations,
                          FstQtrBenevolence,
                          FstQtrBuildingMaint,
                          FstQtrFlowers,
                          FstQtrSeasonal,
                          FstQtrSpecial,
                          FstQtrImprovement,
                          SndQtrLocalOperations,
                          SndQtrBenevolence,
                          SndQtrBuildingMaint,
                          SndQtrFlowers,
                          SndQtrSeasonal,
                          SndQtrSpecial,
                          SndQtrImprovement,
                          TrdQtrLocalOperations,
                          TrdQtrBenevolence,
                          TrdQtrBuildingMaint,
                          TrdQtrFlowers,
                          TrdQtrSeasonal,
                          TrdQtrSpecial,
                          TrdQtrImprovement,
                          FthQtrLocalOperations,
                          FthQtrBenevolence,
                          FthQtrBuildingMaint,
                          FthQtrFlowers,
                          FthQtrSeasonal,
                          FthQtrSpecial,
                          FthQtrImprovement         : REAL
                        END;

VAR
  Contributions       : FILE of ContributionsRecord;
  Offerings           : ContributionsRecord;
  ErrorCheck          : BYTE;
  FileName            : DOSString;
  Number,
  Maximum             : LONGINT;
  Error               : INTEGER;
  Service             : CHAR;
  TotalYearToDate     : REAL;

BEGIN
  ClrScr;
  CursorOff;
  GoToXY (9,3);
    Write ('Display Quarterly Statement for a Specified Envelope Number:');
  GoToXY (15,5);
    Write ('Please give the name of the Contributions File');
  GoToXY (15,6);
    Write ('that you wish to open for Statement Display: ');
  CursorOn;
  Readln (FileName);
  CursorOff;

  Assign (Contributions, Filename);
  {$I-}
  Reset (Contributions);
  {$I+}
  ErrorCheck := IOResult;

  If (ErrorCheck <> 0)
    THEN
      BEGIN
        ErrorMessageTwo;
        DisplayQuarterlyStatement
      END
    ELSE
      BEGIN
        ClrScr;
        Maximum := FileSize (Contributions);
        Close (Contributions);

        REPEAT
          DrawSingleLineBox (10,3,68,9);
          GoToXY (13,5);
            Write ('Envelopes are numbered in sequence from 1 to ');
            Write ((Maximum - 1), ' ....');
          GoToXY (13,7);
            Write ('Display a Statement for which Envelope Number? ');
          CursorOn;
          GetLongIntegerEntry (Number, Error);

            WHILE (Error <> 0) DO
              BEGIN
                GoToXY (60,7);
                  ClrEOL;
                GoToXY (60,7);
                GetLongIntegerEntry (Number, Error)
              END;

          CursorOff;

          IF (Number < 1) OR (Number > (Maximum - 1))
            THEN ErrorMessageThree

        UNTIL (Number > 0) AND (Number < Maximum);

        Service := 'S';                   (* Send Statement Form to Screen *)
        ClrScr;
        PrepareSelectedItem (TotalYearToDate, Number, Service, FileName);

        GoToXY (5,24);
          Write ('Press E to Exit.');

        REPEAT
          FlushKeyBuffer;
          Choice := ReadKey
        UNTIL Choice IN ['E', 'e']

      END;

  ClrScr
END;                       (* End of procedure to display a form on screen *)

(***************************************************************************)

