{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
UNIT to obtain the date from DOS.

* ASSOCIATED FILES
TRINITY.PAS
ADDWEEK.INC
ASSIGN.INC
AUDIT.INC
CURSOR.PAS
DATE.PAS
DBLLNBOX.PAS
DISPLAY.INC
EDIT.INC
FLUSHKEY.PAS
INITIAL.INC
LISTING.INC
PREPARE.INC
PRINTIT.INC
SGLLNBOX.PAS
TRINITY.DOC
TRINITY.EXE

}
UNIT  Date;             (* This File:  DATE.PAS *)

(* Obtains the date from DOS.
   Written by F. Axtell Kramer.    Last Revision:  April 3, 1988  *)


INTERFACE

  USES  Dos;

  TYPE
    String24  =  STRING[24];

  FUNCTION  TheDate : String24;



IMPLEMENTATION

  FUNCTION  TheDate;

    VAR
      RegisterRecord : Registers;   (* Defined in Dos UNIT *)
      Month          : STRING[9];   (* Longest month name has 9 letters *)
      Day            : STRING[2];
      Year           : STRING[4];


    BEGIN
      RegisterRecord.AX := $2A00;

(* Put hex 2A in register AH; this is for the DOS service "get date". Then
   issue interrupt hex 21 to call DOS for service identified in AH.       *)

      MSDOS (RegisterRecord);            (* Request DOS service *)

      WITH RegisterRecord DO
        BEGIN
          STR (CX, Year);
          STR (LO (DX), Day);

          CASE (HI (DX)) OF    (* HI(DX) contains the month number *)
             1 : Month := 'January';
             2 : Month := 'February';
             3 : Month := 'March';
             4 : Month := 'April';
             5 : Month := 'May';
             6 : Month := 'June';
             7 : Month := 'July';
             8 : Month := 'August';
             9 : Month := 'September';
            10 : Month := 'October';
            11 : Month := 'November';
            12 : Month := 'December'
          END
        END;

    TheDate := Month + ' ' + Day + ', ' + Year

  END;

END.            (* END of UNIT to obtain the date from DOS *)

