{                       F i l e    I n f o r m a t i o n

* DESCRIPTION
UNIT to turn cursor Off/On.

* ASSOCIATED FILES
TRINITY.PAS
ADDWEEK.INC
ASSIGN.INC
AUDIT.INC
CURSOR.PAS
DATE.PAS
DBLLNBOX.PAS
DISPLAY.INC
EDIT.INC
FLUSHKEY.PAS
INITIAL.INC
LISTING.INC
PREPARE.INC
PRINTIT.INC
SGLLNBOX.PAS
TRINITY.DOC
TRINITY.EXE

}
UNIT Cursor;    (* File: CURSOR.PAS     Last revision: February 24, 1988
                   By F. Axtell Kramer, Jr.     Turns the cursor Off/On *)
INTERFACE

  USES  Dos;

  VAR
    ItIsMono : BOOLEAN;    (* Global flag for video display type *)

  PROCEDURE CursorOff;
  PROCEDURE CursorOn;


IMPLEMENTATION

  FUNCTION  Monochrome : BOOLEAN;  (* Checks for type of video display *)

    VAR
      RegisterRecord : Registers;    (* TYPE defined in Dos UNIT *)

    BEGIN
      IF Mem[$0000:$0449] = 7  (* BIOS memory location for equipment list *)
        THEN  Monochrome := TRUE          (* 7 is Monochrome *)
        ELSE  Monochrome := FALSE   (* otherwise assume Color/Graphics *)
    END;


  PROCEDURE  CursorOff;

    VAR
      RegisterRecord : Registers;

    BEGIN
      RegisterRecord.AX := $0100;

(* Call ROM-BIOS Service 1 to SET CURSOR SIZE; the service number goes into
   register AH.                                                         *)

      RegisterRecord.CX := $2000;  (* Sets CH bit 5 = 1 to suppress cursor *)
      Intr ($10, RegisterRecord)        (* Make ROM-BIOS service request *)
    END;


  PROCEDURE  CursorOn;

    VAR
      RegisterRecord : Registers;

    BEGIN
      IF ItIsMono
        THEN  RegisterRecord.CX := $0A0D   (* Choose scan lines for cursor *)
        ELSE  RegisterRecord.CX := $0507;  (* Make cursor somewhat large *)

      RegisterRecord.AX := $0100;     (* Ask for service number 1 in AH *)
      Intr ($10, RegisterRecord)      (* Make ROM-BIOS service request *)
    END;


BEGIN   (* On initialization set BOOLEAN type-of-display flag for program *)

  ItIsMono := Monochrome;

END.      (* END of UNIT to turn cursor Off/On *)

