                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Include source code for Trinity.

* ASSOCIATED FILES
TRINITY.PAS
ADDWEEK.INC
ASSIGN.INC
AUDIT.INC
CURSOR.PAS
DATE.PAS
DBLLNBOX.PAS
DISPLAY.INC
EDIT.INC
FLUSHKEY.PAS
INITIAL.INC
LISTING.INC
PREPARE.INC
PRINTIT.INC
SGLLNBOX.PAS
TRINITY.DOC
TRINITY.EXE

}
PROCEDURE  PrintAuditFile;                         (* This File: AUDIT.INC *)

(* Prints a report giving the date of preparation and the total contri-
   bution for each envelope number and a grand total for all for a given
   week.  A new file is constructed automatically each week.

   Use TURBO Pascal Version 4.0.           Last revision:  April 12, 1988  *)


TYPE
  AuditRecord = RECORD
                  EnvelopeNumber       : LONGINT;
                  WeekTotalForEnvelope : REAL
                END;

VAR
  AuditFile   : FILE of AuditRecord;
  AuditInfo   : AuditRecord;
  Page        : BYTE;
  TotalTotal  : REAL;
  Maximum,
  Index       : LONGINT;
  Response    : CHAR;

(*-------------------------------------------------------------------------*)

PROCEDURE  PrintHeading (Page : BYTE);

BEGIN
  Write (LST, '  AUDIT FILE REPORT        ');            (* LST is printer *)
  Writeln (LST, TheDate, '        Page Number ', Page);
  Writeln (LST);
  Write (LST, '   Envelope Number');
  Writeln (LST, '         Total');
  Writeln (LST)
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  Message;

BEGIN

(* This module is designed so that a character printer taking single sheets
   may be used without the need for attaching a tractor feed mechanism     *)

  ClrScr;
  DrawDoubleLineBox (16,8,65,14);
  GoToXY (20,10);
    Write ('Insert a sheet of paper into the printer.');
  GoToXY (20,12);
    Write ('Press P when ready to Print Audit File: ');
  CursorOn;

  REPEAT
    FlushKeyBuffer;
    Response := ReadKey
  UNTIL Response IN ['P', 'p'];

  ClrScr;
  CursorOff;
  GoToXY (20,10);
    Write ('Printing Audit File.    Please Wait ....')
END;

(*-------------------------------------------------------------------------*)

BEGIN
  CursorOff;
  Message;
  Assign (AuditFile, 'AUDITFIL');     (* This file prepared by the program *)
  Reset (AuditFile);          (* during entry of weekly contribution data. *)

  Page := 1;
  TotalTotal := 0.0;
  PrintHeading (Page);

  Read (AuditFile, AuditInfo);

  WITH AuditInfo DO                      (* For 1st Envelope *)
    BEGIN
      Write (LST, '           ', EnvelopeNumber : 4);
      Writeln (LST, '      ', WeekTotalForEnvelope : 10 : 2);
      TotalTotal := TotalTotal + WeekTotalForEnvelope
    END;

  Maximum := FileSize (AuditFile);

  FOR Index := 1 TO (Maximum - 1) DO

(* Envelope Number 1 was record 0.  This loop will process the remaining
   records of the audit file.                                              *)

    BEGIN
      WITH AuditInfo DO
        BEGIN
          Seek (AuditFile, Index);
          Read (AuditFile, AuditInfo);
          Write (LST, '           ', EnvelopeNumber : 4);
          Writeln (LST, '      ', WeekTotalForEnvelope : 10 : 2);
          TotalTotal := TotalTotal + WeekTotalForEnvelope;

          IF (Index MOD 50 = 0)   (* Print data for 50 envelopes per page. *)
            THEN
              BEGIN
                Message;
                Page := Page + 1;
                PrintHeading (Page)
              END

        END                                          (* End of WITH *)
    END;                                           (* End of FOR loop *)

  Writeln (LST);
  Writeln (LST, '     Total For Week: ', TotalTotal : 10: 2);
  Writeln (LST);
  Writeln (LST);
  Writeln (LST);
  Writeln (LST);                                      (* Eject paper *)
  Writeln (LST);

  GoToXY (25,15);
    Write ('Printing of Audit File completed. ');       (* On screen *)
  Delay (2500);
  Clrscr;
  CursorOn
END;

(***************************************************************************)

