{                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Include source code for Trinity.

* ASSOCIATED FILES
TRINITY.PAS
ADDWEEK.INC
ASSIGN.INC
AUDIT.INC
CURSOR.PAS
DATE.PAS
DBLLNBOX.PAS
DISPLAY.INC
EDIT.INC
FLUSHKEY.PAS
INITIAL.INC
LISTING.INC
PREPARE.INC
PRINTIT.INC
SGLLNBOX.PAS
TRINITY.DOC
TRINITY.EXE


==========================================================================
}
PROCEDURE  AssignEnvelopeNumbers;                 (* This File: ASSIGN.INC *)

(* Assign consecutive envelope numbers beginning with one.  Later addition
   of still more envelope numbers is possible, but no number should be omit-
   ted or re-used.  At the time the envelope number is assigned, the name,
   address, city/state/zip, and total pledge for the year are to be entered
   into the file.  Weekly contributions in various categories are to be
   entered as received in future weeks.  This assignment procedure also
   initializes the amounts contributed in each category to zero.

   For TURBO Pascal Version 4.0.         Last revision:  April 12, 1988    *)


TYPE
  ContributionsRecord = RECORD
                          EnvelopeNumber            : LONGINT;
                          Name,
                          Address,
                          CityStateZip              : TextString;
                          TotalPledge,
                          FstQtrLocalOperations,
                          FstQtrBenevolence,
                          FstQtrBuildingMaint,
                          FstQtrFlowers,
                          FstQtrSeasonal,
                          FstQtrSpecial,
                          FstQtrImprovement,
                          SndQtrLocalOperations,
                          SndQtrBenevolence,
                          SndQtrBuildingMaint,
                          SndQtrFlowers,
                          SndQtrSeasonal,
                          SndQtrSpecial,
                          SndQtrImprovement,
                          TrdQtrLocalOperations,
                          TrdQtrBenevolence,
                          TrdQtrBuildingMaint,
                          TrdQtrFlowers,
                          TrdQtrSeasonal,
                          TrdQtrSpecial,
                          TrdQtrImprovement,
                          FthQtrLocalOperations,
                          FthQtrBenevolence,
                          FthQtrBuildingMaint,
                          FthQtrFlowers,
                          FthQtrSeasonal,
                          FthQtrSpecial,
                          FthQtrImprovement         : REAL
                        END;

VAR
  Contributions       : FILE of ContributionsRecord;
  Offerings           : ContributionsRecord;
  ErrorCheck          : BYTE;
  NextRecordNumber    : LONGINT;
  Error               : INTEGER;
  FileName            : DOSString;
  Response            : CHAR;

BEGIN
  ClrScr;
  CursorOff;
  GoToXY (24,2);
    Write ('Assign New Envelope Numbers');
  GoToXY (20,3);
    Write ('and Enter Name/Address/Pledge Data:');
  GoToXY (14,5);
    Write ('Please give the name of the Contributions File');
  GoToXY (7,6);
    Write ('that you wish to open for Assignment of Envelope Numbers: ');
  CursorOn;
  Readln (FileName);
  CursorOff;

  Assign (Contributions, FileName);
  {$I-}
  Reset (Contributions);
  {$I+}
  ErrorCheck := IOResult;

    IF ErrorCheck <> 0
      THEN
        BEGIN
          ErrorMessageTwo;
          AssignEnvelopeNumbers       (* Redo if typing error in file name *)
        END
      ELSE
        BEGIN
          REPEAT
            ClrScr;
            NextRecordNumber := FileSize (Contributions);
            DrawSingleLineBox (18,2,63,5);
            GoToXY (20,3);
              Write ('The last Envelope Number entered ');
              Write ('was ', (NextRecordNumber - 1));
            GoToXY (26,4);
              Write ('This Envelope Number is: ');
              Write (NextRecordNumber);

              WITH Offerings DO
                BEGIN
                  EnvelopeNumber          := NextRecordNumber;
                  Name                    := ' ';
                  Address                 := ' ';
                  CityStateZip            := ' ';
                  TotalPledge             := 0.0;
                  FstQtrLocalOperations   := 0.0;
                  FstQtrBenevolence       := 0.0;     (* Initialize data *)
                  FstQtrBuildingMaint     := 0.0;
                  FstQtrFlowers           := 0.0;
                  FstQtrSeasonal          := 0.0;
                  FstQtrSpecial           := 0.0;
                  FstQtrImprovement       := 0.0;
                  SndQtrLocalOperations   := 0.0;
                  SndQtrBenevolence       := 0.0;
                  SndQtrBuildingMaint     := 0.0;
                  SndQtrFlowers           := 0.0;
                  SndQtrSeasonal          := 0.0;
                  SndQtrSpecial           := 0.0;
                  SndQtrImprovement       := 0.0;
                  TrdQtrLocalOperations   := 0.0;
                  TrdQtrBenevolence       := 0.0;
                  TrdQtrBuildingMaint     := 0.0;
                  TrdQtrFlowers           := 0.0;
                  TrdQtrSeasonal          := 0.0;
                  TrdQtrSpecial           := 0.0;
                  TrdQtrImprovement       := 0.0;
                  FthQtrLocalOperations   := 0.0;
                  FthQtrBenevolence       := 0.0;
                  FthQtrBuildingMaint     := 0.0;
                  FthQtrFlowers           := 0.0;
                  FthQtrSeasonal          := 0.0;
                  FthQtrSpecial           := 0.0;
                  FthQtrImprovement       := 0.0;
                END;

            REPEAT
              GoToXY (18,8);
                Writeln ('Please enter, for this Envelope Number.... ');
              Writeln;
              Writeln;
              Writeln ('              Name:');
              Writeln ('           Address:');
              Writeln ('    City/State/Zip:');
              Writeln ('      Total Pledge:');
              CursorOn;

                WITH Offerings DO
                  BEGIN
                    GoToXY (21,11);

       (* Keep these within 30 or so typed characters and a maximum of 36. *)

                      Readln (Name);
                    GoToXY (21,12);
                      Readln (Address);
                    GoToXY (21,13);
                      Readln (CityStateZip);
                    GoToXY (21,14);
                      GetEntry (TotalPledge, Error);

                        WHILE (Error <> 0) DO
                          BEGIN
                            GoToXY (21,14);
                              ClrEOL;
                            GoToXY (21,14);
                              GetEntry (TotalPledge, Error)
                          END

                    END;

              CursorOff;
              GoToXY (20,18);
                Write ('Check!  Are the data above all OK?');
              GoToXY (20,19);
                Write ('Answer YES or NO.  (Press Y or N): ');
              CursorOn;

              REPEAT
                FlushKeyBuffer;
                Response := ReadKey
              UNTIL Response IN ['N', 'n', 'Y', 'y'];

              IF ((Response = 'n') OR (Response = 'N'))
                THEN
                  BEGIN
                    GoToXY (21,11);
                      ClrEOL;
                    GoToXY (21,12);
                      ClrEOL;           (* Erase entries in error *)
                    GoToXY (21,13);
                      ClrEOL;
                    GoToXY (21,14);
                      ClrEOL;
                    GoToXY (20,18);          (* Erase message *)
                      ClrEOL;
                    GoToXY (20,19);
                      ClrEOL
                  END

            UNTIL Response IN ['Y', 'y'];

            CursorOff;
            Seek (Contributions, FileSize (Contributions));
            Write (Contributions, Offerings);

            GoToXY (12,22);
              Write ('Do you wish to enter data for the next ');
              Write ('Envelope Number?');
            GoToXY (21,23);
              Write ('Answer YES or NO.  (Press Y or N): ');
            CursorOn;

            REPEAT
              FlushKeyBuffer;
              Response := ReadKey
            UNTIL Response IN ['N', 'n', 'Y', 'y'];

            CursorOff

          UNTIL Response IN ['N', 'n'];

          Close (Contributions)
        END;                                        (* End of IF/THEN/ELSE *)

    ClrScr;
    CursorOn
END;                                       (* End of AssignEnvelopeNumbers *)

(***************************************************************************)

