                       F i l e    I n f o r m a t i o n

* DESCRIPTION
This program reads the named file of ASCII data. Then generates a
numbered program listing and finally a cross referanced listing.
Requires: Turbo Pascal 4.0. Author: Jim Halback. Version T1.0.
Converted to version 4.0.
* ASSOCIATED FILES


* KEYWORDS
PASCAL 4.0 FILE CROSREF UTILITY

==========================================================================
}
{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}



(*       C R O S S    R E F E R E N C E    P R O G R A M

         Any and all portions of this program are hereby
         placed in the public domain.  February 17, 1986.

                        Jim Halbach
                        800 Mark Lane #114
                        Wheeling, Ill. 60090

         This program reads the named file of ascii data.
         The name may be entered on the command line or
         in response to program prompt.  The variable names
         found are used to construct a cross reference list.
         First, a numbered listing of the program is made.
         Then, variables with line numbers and character
         number are listed in the order defined.                 *)


Uses
  Crt,
  Printer;

Const
  null = 1;
  break = 2;
  space = 3;
  alpha = 4;
  Colon = 58;
  ControlZ = 26;
  CarriageRet = 13;
  PageLength = 55;
  pagewidth = 80;
  PathLength  = 65;
  hashsize = 80;
  worksize = 120;
  variables = 'VAR           ';
  Procedures = 'PROCEDURE     ';
  Functions = 'FUNCTION      ';

Type
  FileName  = String[PathLength];
  FrameRecord = record
              Order : integer;
              Next : integer;
              Last : integer;
              Name : String[14];
              Collide : integer;
  end;
  PointRecord = record
              Nextp : integer;
              Lines : array[1..7] of real;
              Bytes : array[1..7] of byte;
  end;

var
  echo:                 boolean;
  index:                integer;
  I:                    integer;
  LockwordC:            integer;
  LockwordO:            integer;
  LockwordP:            integer;
  Working:              array[1..worksize] of FrameRecord;
  Pointing:             array[1..worksize] of PointRecord;
  remainder:            integer;
  bytetype:             integer;
  Remap:                array[0..255] of byte;
  breakchar:            integer;
  preceeding:           integer;
  hashvalue:            integer;
  Alphatext:            string[Pagewidth];
  Alphanumer:           string[14];
  character:            char;
  MainFileName:         FileName;
  MainFile:             text;
  Openfile:             boolean;
  pagecount:            integer;
  linecount:            real;
  bytecount:            integer;
  matchfound:           boolean;
  chainlink:            integer;
  matchorder:           integer;
  temporary:            integer;

Function Open(var fp:text; name: Filename): boolean;
begin
  Assign(fp,Name);
  {$I-}
  reset(fp);
  {$I+}
  If IOresult <> 0 then
    begin
    Open := False;
    close(fp);
    end
  else
    Open := True;
end { Open };

Procedure OpenMain;
begin
  If ParamCount = 0 then
  begin
    Write('Enter filename: ');
    readln(MainFileName);
    end
  else
    begin
    MainFileName := ParamStr(1);
  end;
  Openfile := Open(Mainfile,MainFileName);
  If Not Openfile then
  begin
    Writeln('ERROR -- File not found:  ',MainFileName);
  end;
end {OpenMain};

Procedure Sizecheck(var too: integer);
begin
  if too > Worksize then
  begin
    writeln('ERROR -- line space exhausted:  ',linecount:5:0);
  end;
end { Sizecheck };

Procedure initialize;
begin
  {$R+}
  bytecount := 1;
  linecount := 1;
  for I := 0 to 31 do
  begin
    Remap[I] := null;
  end;
  for I := 32 to 255 do
  begin
    Remap[I] := alpha;
  end;
  Remap[CarriageRet] := break;
  Remap[ord(' ')] := space;
  Remap[ord('[')] := space;
  Remap[ord(':')] := space;
  Remap[ord(')')] := space;
  Remap[ord('(')] := space;
  Remap[ord(';')] := space;
  Remap[ord(']')] := space;
  Remap[ord(',')] := space;
  Remap[ControlZ] := break;
  LockwordO := 0;
  LockwordP := 1;
  LockwordC := hashsize + 1;
  for I := 1 to worksize do
  begin
    with Working[I] do
    begin
      Order := 0;
      Next := 0;
      Last := 0;
      Name := ' ';
      Collide := 0;
    end;
    with Pointing[I] do
    begin
      Nextp := 0;
      for index := 1 to 7 do
      begin
        Lines[index] := 0;
        Bytes[index] := 0;
      end;
    end;
  end;
end  {initialize};

Procedure InitGetsym;
begin
  bytetype := 0;
  breakchar := 0;
  preceeding := 0;
  hashvalue := 0;
  begin
    for I := 1 to pagewidth do
    Alphatext[I] := ' ';
  end;
end {InitGetsym};

Procedure Texts;
begin
  preceeding := preceeding+1;
  character := UpCase(character);
  Insert(character,Alphatext,preceeding);
  if preceeding < 4 then
    hashvalue := hashvalue * 36 + ord(character) - ord('A')+10;
end {Texts};

Procedure Getsymbol;
label exitsymbol;
  begin
  InitGetsym;
  for I := 1 to pagewidth do
    begin
    if (not openfile) then
      begin
      character := ReadKey;
      end
    else
      begin
      read(mainfile,character);
      end;
    bytetype := Remap[ord(character)];
    case bytetype of
      null :           ;
      break :          begin
                         breakchar := ord(character);
                         goto exitsymbol;
                       end;
      space :          begin
                         if echo then write(lst,character);
                         if preceeding <> 0 then
                         begin
                           breakchar := ord(character);
                           goto exitsymbol;
                         end;
                       end;
      alpha :          begin
                       if echo then write(lst,character);
                       Texts;
                       end;
    end;
  end;
exitsymbol : end {Getsymbol};

Procedure PageEject;
begin
  if ( trunc(linecount) mod PageLength ) = 0 then
  begin
    pagecount := pagecount + 1;
    writeln(lst,#12);
    write(lst,' FILE: ',MainFileName:12);
    writeln(lst,' PAGE ':55,pagecount);
    writeln(lst);
  end;
end { PageEject };

Procedure PointPrint(var too: integer);
begin
  with Pointing[too] do
  begin
    for index := 1 to 7 do
    begin
      if Bytes[index] <> 0 then
      begin
        write (lst,' ',Lines[index]:5:0,'/',Bytes[index]:3);
      end;
    end;
    Chainlink := Nextp;
  end;
  PageEject;
  writeln(lst,' ');
  linecount := Linecount + 1;
  while Chainlink <> 0 do
  begin
    with Pointing[Chainlink] do
    begin
      for index := 1 to 7 do
      begin
        if Bytes[index] <> 0 then
        begin
          write (lst,' ',Lines[index]:5:0,'/',Bytes[index]:3);
        end;
      end;
      temporary := Nextp;
      PageEject;
      writeln(lst,' ');
      linecount := linecount + 1;
    end;
    Chainlink := temporary;
  end;
end { PointPrint };

Procedure PrintData;
begin
  with Working[LockwordO] do
  begin
    if Name[1] <> ' ' then
    begin
      writeln(lst,' ',Name);
      PageEject;
      linecount := linecount + 1;
      PointPrint(Next);
    end;
    Chainlink := Order;
  end;
  while Chainlink <> 0 do
  begin
    with Working[Chainlink] do
    begin
      if Name[1] <> ' ' then
      begin
        writeln(lst,' ',Name);
        PageEject;
        linecount := linecount + 1;
        PointPrint(Next);
      end;
      Temporary := Order;
    end;
    Chainlink := Temporary;
  end;
end { PrintData };

Procedure PointSet(var too,from: integer);
begin
  with Pointing[too] do
  begin
    if Nextp = 0 then
    begin
      matchfound := false;
      for index := 1 to 7 do
      begin
        if ( Bytes[index] = 0 ) and ( not matchfound ) then
        begin
          matchfound := true;
          Lines[index] := linecount;
          Bytes[index] := bytecount;
        end;
      end;
      if ( not matchfound ) then
      begin
        Pointing[too].Nextp := LockwordP;
        Working[from].Last := Lockwordp;
        with Pointing[LockwordP] do
        begin
          matchfound := true;
          Nextp := 0;
          Lines[1] := linecount;
          Bytes[1] := bytecount;
        end;
        LockwordP := LockwordP + 1;
        Sizecheck(LockwordP);
      end;
    end;
  end;
end { PointSet };

Procedure MatchData;
begin
  with Working[I] do
  begin
    if Name = Alphanumer then
    begin
      PointSet(Last,I);
    end;
    Chainlink := Collide;
  end;
  while Chainlink <> 0 do
  begin
    with Working[Chainlink] do
    begin
      if Name = Alphanumer then
      begin
        PointSet(Last,Chainlink);
      end;
      Temporary := Collide;
    end;
    Chainlink := Temporary;
  end;
end { MatchData };

Procedure printxref;
begin
  pagecount := 1;
  writeln(lst,#12);
  writeln(lst);
  writeln(lst,'  C R O S S  R E F E R E N C E  ':50);
  writeln(lst);
  write(lst,' FILE: ',MainFileName:12);
  writeln(lst,' PAGE ':55,pagecount);
  writeln(lst);
  writeln(lst,'  variables      -  line number / character number ');
  writeln(lst);
  if LockwordO <> 0 then PrintData ;
  writeln(lst,#12);
end { printxref };

Procedure Nameset(var too: integer);
begin
  with Working[too] do
  begin
    if ( matchorder <> 0 ) then
    begin
      Working[Matchorder].Order := too;
    end;
    Name := Alphatext;
    Next := LockwordP;
    Last := LockwordP;
    Collide := 0;
    with Pointing[Next] do
    begin
      Nextp := 0;
      Lines[1] := 0;
      Bytes[1] := 0;
    end;
    LockwordP := LockwordP + 1;
    Sizecheck(LockwordP);
  end;
end { NameSet };

Procedure Buildata;
begin
  echo := false;
  matchfound := false;
  matchorder := 0;
  repeat
    GetSymbol;
    Alphanumer := Alphatext;
    if ( Alphanumer = variables ) and ( LockwordO = 0 ) then
    begin
      matchfound := true;
    end;
    if Alphanumer = Procedures then matchfound := false;
    if Alphanumer = Functions then matchfound := false;
    if ( matchfound = true ) and ( breakchar = Colon ) then
    begin
      remainder := Abs(hashvalue mod hashsize) + 1;
      I := remainder;
      with Working[I] do
      begin
        if Name[1] <> ' ' then
        begin
          Temporary := I;
          Chainlink := Collide;
          while Chainlink <> 0 do
          begin
            Temporary := Chainlink;
            with Working[Chainlink] do
            begin
              Chainlink := Collide;
            end;
          end;
          With Working[Temporary] do
          begin
            Collide := LockwordC;
            NameSet(LockwordC);
            Matchorder := LockwordC;
            LockwordC := LockwordC + 1;
            Sizecheck(LockwordC);
          end;
        end;
        if Name[1] = ' ' then
        begin
          if LockwordO = 0 then LockwordO := I;
          NameSet(I);
          Matchorder := I;
        end;
      end;
    end;
  until ( breakchar = ControlZ ) or ( Alphanumer = Procedures );
end { Buildata };

Procedure Scandata;
begin
  echo := true;
  pagecount := 1;
  writeln(lst,#12);
  writeln(lst);
  writeln(lst,'    P R O G R A M   L I S T I N G   ':50);
  writeln(lst);
  write(lst,' FILE: ',MainFileName:12);
  writeln(lst,' PAGE ':55,pagecount);
  writeln(lst);
  write(lst,linecount:5:0,' ');
  repeat
    bytecount := preceeding + bytecount;
    GetSymbol;
    remainder := Abs(hashvalue mod hashsize) + 1;
    Alphanumer := Alphatext;
    I := remainder;
    MatchData;
    if ( breakchar = CarriageRet ) or ( breakchar = ControlZ ) then
    begin
      linecount := linecount + 1;
      bytecount := 1;
      PageEject;
      writeln(lst);
      write(lst,linecount:5:0,'  ');
    end;
  until breakchar = ControlZ;
end { Scandata };

begin
initialize;
openmain;
Buildata;
if openfile then
begin
  {$I-}
  reset(Mainfile);
  {$I+}
end;
Scandata;
linecount := 5;
printxref;
close(Mainfile);
end.

