                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Examine disk file by sectors.
Requires: Turbo Pascal 4.0. Author: Charles Rogers. Version T1.0
Converted to version 4.0.
* ASSOCIATED FILES
SECTOR.PAS
SECTOR.HLP
SECTOR.DOC


* KEYWORDS
PASCAL 4.0 DISK SECTOR UTILITY

==========================================================================
}
{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}

PROGRAM SECTOR; {Examine Disk File by Sectors}


Uses
  Crt,
  Dos;


CONST
  DOT       : CHAR = #$FA;
  ESC       : CHAR = #$1B;
  F2        : STRING[2] = #$1B#$3C;
  HEX       : STRING[16] = '0123456789ABCDEF';

VAR
  ASCIIVAL  : STRING[16];
  CH        : CHAR;
  CHANGES   : BOOLEAN;
  COL       : INTEGER;
  FILENAME  : STRING[14];
  KEY       : STRING[2];
  I,J,K,L,M : INTEGER;
  LASTSECTOR: INTEGER;
  REG       : REGISTERS;
  ROW       : INTEGER;
  SEARCH    : STRING[80];
  SECBUFFER : ARRAY[1..128] OF CHAR;
  SECFILE   : FILE;
  SECNUMBER : INTEGER;
  TEMP      : STRING[128];

PROCEDURE CHANGE_NIBBLE(OFFSET:INTEGER);
VAR
  I,J,K,NIBBLE : INTEGER;
BEGIN
  NIBBLE := ORD(CH) - OFFSET;
  WRITE(CH);
  I := COL DIV 3;
  J := (ROW SHL 4) + I + 1;
  K := ORD(SECBUFFER[J]);
  IF (COL MOD 3) = 0 THEN K := (K AND $0F) OR (NIBBLE SHL 4)
                     ELSE K := (K AND $F0) OR NIBBLE;
  SECBUFFER[J] := CHR(K);
  GOTOXY(I+63,ROW+5);
  IF K IN[32..127] THEN WRITE(SECBUFFER[J]) ELSE WRITE(DOT);
  COL := COL + 1;
  CHANGES := TRUE;
END;

PROCEDURE CLEAR_SEARCH;
BEGIN
  GOTOXY(1,24);
  CLREOL;
END;

PROCEDURE CURSOR_OFF;
BEGIN
  REG.AH := 1; REG.CX := $2000; INTR($10,REG);
END;

PROCEDURE CURSOR_ON;
BEGIN
  REG.AH := 1; REG.CX := $0707; INTR($10,REG);
END;

PROCEDURE INKEY;
BEGIN
  KEY[1] := READKEY;
  KEY[0] := CHR(1);
  IF KEY[1] = #0 THEN BEGIN
    KEY[2] := READKEY;
    KEY[0] := CHR(2);
  END;
END;

PROCEDURE SEARCH_FILE(DIRECTION,ENDSECTOR:INTEGER);
VAR
  J,K : INTEGER;
BEGIN
  J := 0;
  K := SECNUMBER;
  IF K <> ENDSECTOR THEN BEGIN
    REPEAT
      K := K + DIRECTION;
      SEEK(SECFILE,K);
      BLOCKREAD(SECFILE,TEMP,1);
      TEMP[0] := CHR(128);
      J := POS(SEARCH,TEMP);
    UNTIL (J <> 0) OR (K = ENDSECTOR);
    IF J <> 0 THEN BEGIN
      SECNUMBER := K;
      GOTOXY(3,24); WRITE('Search Value:  ',SEARCH); CLREOL;
    END
    ELSE BEGIN
      GOTOXY(3,24); WRITE('Search Value: ');
      TEXTCOLOR(YELLOW+BLINK);
      WRITE(' Not Found '); CLREOL;
      TEXTCOLOR(YELLOW);
    END;
  END;
END;

BEGIN
  TEXTMODE(C80);
  ASCIIVAL[0] := CHR(16);
  SEARCH := '??';
  GOTOXY(1,21); WRITE('  SECTOR DISPLAY/EDIT PROGRAM');
  GOTOXY(1,22); WRITE('  ---------------------------');
  REPEAT
    CURSOR_ON;
    TEXTCOLOR(YELLOW);
    REPEAT
      GOTOXY(1,24); WRITE('  File:  '); CLREOL;
      READLN(FILENAME);
      L := LENGTH(FILENAME);
      IF L = 0 THEN BEGIN
        TEXTMODE(BW80);
        GOTOXY(1,23);
        WRITELN('END SECTOR');
        HALT;
      END;
      FOR I := 1 TO L DO FILENAME[I] := UPCASE(FILENAME[I]);
      IF POS('.',FILENAME) = 0 THEN FILENAME := FILENAME + '.TXT';
      ASSIGN(SECFILE,FILENAME);
      {$I-} RESET(SECFILE) {$I+};
      I := IORESULT;
      IF I <> 0 THEN BEGIN
        GOTOXY(1,23);
        WRITE('  Unable to open ',FILENAME,' -- Check spelling.');
        CLREOL;
      END;
      IF FILESIZE(SECFILE) = 0 THEN BEGIN
        WRITELN('Empty file -- Try another file.');
        I := 99;
      END;
    UNTIL I = 0;
    CLRSCR;
    L := (80 - LENGTH(FILENAME)) DIV 2;
    WRITELN('':L,FILENAME);
    TEXTCOLOR(LIGHTGRAY);
    WRITE(''); FOR I := 2 TO 79 DO WRITE(''); WRITE('');
    WRITE('');
    GOTOXY(14,3); WRITE('0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F');
    GOTOXY(63,3); WRITE('0123456789ABCDEF ');
    WRITE(''); FOR I := 2 TO 79 DO WRITE(''); WRITE('');
    FOR I := 0 TO 7 DO BEGIN
      GOTOXY(1,I+5); WRITE('',I*16+1:4,I:4);
      GOTOXY(80,I+5); WRITE('');
    END;
    WRITE(''); FOR I := 2 TO 79 DO WRITE(''); WRITE('');
    GOTOXY(3,25);
    WRITE('F1 = Help     F2 = Change File     F3 = Search     ');
    WRITE('F4 = Edit     ESC = Quit');
    SECNUMBER := 0;
    LASTSECTOR := FILESIZE(SECFILE) - 1;
    TEXTCOLOR(YELLOW);
    CURSOR_OFF;

    REPEAT                                                    {Main Loop}
      SEEK(SECFILE,SECNUMBER);
      BLOCKREAD(SECFILE,SECBUFFER,1);
      GOTOXY(2,3); WRITE(SECNUMBER:4);
      FOR I := 0 TO 7 DO BEGIN
        J := I SHL 4;
        GOTOXY(13,I+5);
        FOR K := 1 TO 16 DO BEGIN
          CH := SECBUFFER[J+K];
          L := ORD(CH);
          IF L IN[32..127] THEN ASCIIVAL[K] := CH
                           ELSE ASCIIVAL[K] := DOT;
          WRITE(HEX[L SHR 4 + 1],HEX[L AND $0F + 1],' ');
        END;
        WRITE('  ',ASCIIVAL);
      END;

      INKEY;                                                  {KEY=Keystroke}

      IF KEY = ESC THEN BEGIN                                 {ESC=Quit}
        TEXTMODE(BW80);
        CURSOR_ON;
        GOTOXY(1,23);
        WRITELN('END SECTOR');
        HALT;
      END;

      IF LENGTH(KEY) = 2
        THEN M := POS(KEY[2],#$49#$51#$47#$4F#$3B#$3D#$4B#$4D#$3E#$48#$50)
        ELSE M := 0;

      CASE M OF
        1,10 : BEGIN                                          {PgUp/Up}
                SECNUMBER := SECNUMBER - 1;
                IF SECNUMBER < 0 THEN SECNUMBER := LASTSECTOR;
                CLEAR_SEARCH;
              END;
        2,11 : BEGIN                                          {PgDn/Down}
                SECNUMBER := SECNUMBER + 1;
                IF SECNUMBER > LASTSECTOR THEN SECNUMBER := 0;
                CLEAR_SEARCH;
              END;
        3 : BEGIN                                             {Home}
              SECNUMBER := 0;
              CLEAR_SEARCH;
            END;
        4 : BEGIN                                             {End}
              SECNUMBER := LASTSECTOR;
              CLEAR_SEARCH;
            END;
        5 : BEGIN                                             {F1=Help}
              WINDOW(1,15,80,24); CLRSCR;
              WINDOW(3,14,80,24);
              TEXTCOLOR(LIGHTGREEN); GOTOXY(1,1);
              WRITELN('DISPLAY MODE COMMANDS:');
              TEXTCOLOR(GREEN);
              WRITELN('F1          Display help text');
              WRITELN('F2          Change file');
              WRITELN('F3          Search for value');
              WRITELN('F4          Edit current sector');
              WRITELN('Escape      Exit to DOS');
              WRITELN('Home        Top of File');
              WRITELN('End         Last Sector');
              WRITELN('PgUp/PgDn   Previous/Next Sector');
              WRITELN('Left/Right  Search Backward/Forward');
              WINDOW(46,14,80,24); GOTOXY(1,1);
              TEXTCOLOR(LIGHTGREEN);
              WRITELN('EDIT MODE COMMANDS:');
              TEXTCOLOR(GREEN);
              WRITELN('Up         Move up 1 row');
              WRITELN('Down       Move down 1 row');
              WRITELN('Left       Move left 1 column');
              WRITELN('Right      Move right 1 column');
              WRITELN('Escape     Exit and write sector');
              WRITELN('Home       Beginning of sector');
              WRITELN('End        End of sector');
              WRITELN('Delete     Exit without writing');
              WRITELN('0-9,A-F    Store hex digit');
              WINDOW(1,1,80,25);
              TEXTCOLOR(YELLOW);
            END;
        6 : BEGIN                                             {F3=Search}
              GOTOXY(3,24); WRITE('Search Value:  '); CLREOL;
              CURSOR_ON;
              READLN(SEARCH);
              CURSOR_OFF;
              SEARCH_FILE(1,LASTSECTOR);
            END;
        7 : SEARCH_FILE(-1,0);                                {Left}
        8 : SEARCH_FILE(1,LASTSECTOR);                        {Right}
        9 : BEGIN                                             {F4=Edit}
              CHANGES := FALSE;
              COL := 0;
              ROW := 0;
              CURSOR_ON;
              REPEAT
                IF (COL MOD 3) = 2 THEN COL := COL + 1;
                IF COL > 46 THEN COL := 0;
                IF COL < 0 THEN COL := 46;
                IF ROW > 7 THEN ROW := 0;
                IF ROW < 0 THEN ROW := 7;
                GOTOXY(COL+13,ROW+5);
                INKEY;
                CASE LENGTH(KEY) OF
                  1 : BEGIN                                   {1 Byte Function}
                        CH := UPCASE(KEY[1]);
                        CASE CH OF
                          '0'..'9' : CHANGE_NIBBLE(48);
                          'A'..'F' : CHANGE_NIBBLE(55);
                          #$09     : COL := 46;               {Tab}
                          #$0D     : BEGIN                    {Return}
                                       ROW := ROW + 1;
                                       COL := 0;
                                     END;
                        END;
                      END;
                  2 : BEGIN                                   {2 Byte Function}
                        M := POS(KEY[2],#$48#$50#$4B#$4D#$47#$4F#$0F#$53);
                        CASE M OF
                          1 : ROW := ROW - 1;                 {Up}
                          2 : ROW := ROW + 1;                 {Down}
                          3 : BEGIN                           {Left}
                                COL := COL - 1;
                                IF (COL MOD 3) = 2 THEN COL := COL - 1;
                              END;
                          4 : COL := COL + 1;                 {Right}
                          5 : BEGIN                           {Home}
                                COL := 0;
                                ROW := 0;
                              END;
                          6 : BEGIN                           {End}
                                COL := 46;
                                ROW := 7;
                              END;
                          7 : COL := 0;                       {Back Tab}
                          8 : BEGIN                           {Delete}
                                CHANGES := FALSE;
                                KEY := ESC;
                              END;
                        END;
                      END;
                END;
              UNTIL KEY = ESC;
              IF (CHANGES) THEN BEGIN
                SEEK(SECFILE,SECNUMBER);
                BLOCKWRITE(SECFILE,SECBUFFER,1);
              END;
              CURSOR_OFF;
            END;
      END;
    UNTIL KEY = F2;                                           {F2=Change File}
    CLOSE(SECFILE);
  UNTIL FALSE;
END.

