                       F i l e    I n f o r m a t i o n

* DESCRIPTION
This program outputs the specified filenames (sorted alphabetically)
includes file attributes, size and date last updated. Requires: Turbo
Pascal 4.0. Author: Don Ferguson. Version T1.0. Converted to version 4.0.
1985/86 TUG O'Wards entry.

* ASSOCIATED FILES

* KEYWORDS
PASCAL 4.0 DIRECTORY SORT OUTPUT UTILTIY

==========================================================================
}
{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}

{.HE17 DEC 1985    SDX - Sorted Directory Listing                 Page #}

{ NAME:        SDX  -  Sorted Directory Listing                     }
{                                                                   }
{ DESCRIPTION: This program outputs the specified filenames (sorted }
{              alphabetically and including  file attributes,  file }
{              size, and date last updated) to the specified device }
{              or file.                                             }
{                                                                   }
{ ENVIRONMENT: IBM/PC and true compatibles                          }
{                                                                   }
{ SYNOPSIS:    SDX [<filespec>] [@<outfile>] [<option> ...]         }
{                                                                   }
{              <filespec> is the input file pathname  (wildcards    }
{              are allowed), "*" or "*.*" specifies all files in    }
{              the directory (default), and "*." specifies files    }
{              with no extensions.                                  }
{                                                                   }
{              <outfile> is the output file pathname (default is    }
{              CON:).                                               }
{                                                                   }
{              <option> is: =a to display names of ALL specified    }
{                              files regardless of attributes;      }
{                           =d to only display names of subdirec-   }
{                              tories;                              }
{                           +d to include names of subdirectories   }
{                              (default);                           }
{                           -d to suppress names of subdirectories; }
{                           =i to only display names of files with  }
{                              the INVISIBLE attribute;             }
{                           +i to include names of files with the   }
{                              INVISIBLE attribute;                 }
{                           -i to suppress names of files with the  }
{                              INVISIBLE attribute (default);       }
{                           =s to only display names of files with  }
{                              the SYSTEM attribute;                }
{                           +s to include names of files with the   }
{                              SYSTEM attribute;                    }
{                           -s to suppress names of files with the  }
{                              SYSTEM attribute (default);          }
{                           =u to only display names of files with  }
{                              the UPDATE attribute;                }
{                           +u to include names of files with the   }
{                              UPDATE attribute (default);          }
{                           -u to suppress names of files with the  }
{                              UPDATE attribute;                    }
{                           =w to onl display names of files that   }
{                              are write-protected;                 }
{                           +w to include names of files that are   }
{                              write-protected (default);           }
{                           -w to suppress names of files that are  }
{                              write-protected;                     }
{                           =z to only display free disk space.     }
{                                                                   }
{                                                                   }
{ Author:      Don Ferguson / CRAGAR Data Sytstems                  }
{ Date:        18 DEC 1985                                          }
{ Revised:     17 DEC 1985                                          }


program SDX;



Uses
  Crt,
  Dos;

const

  filler:  string[7] = '       ';

type

  pntr   = ^direcd;
  nword  = integer;               {16-bit integer}
  dword  = array [0..03] of byte; {32-bit integer}

  c011   = array [0..10] of char;
  c013   = array [0..12] of char;
  c021   = array [0..20] of byte;
  c040   = array [0..39] of char;

  s008   = string[08];
  s040   = string[40];

  dosfcb = record {PC/DOS Directory Block}
           info: c021;
           attr: byte;
           time: nword;
           date: nword;
           size: dword;
           name: c013;
           end;

  direcd = record {Queued Directory Block}
           fptr: pntr;
           name: c011;
           attr: byte;
           time: nword;
           date: nword;
           size: real;
           end;

var

  regs:    Registers;

  f:      ^dosfcb; {pointer to PC/DOS Directory Block}

  f_path:  s040;   {specified filename(s) path}
  f_disk:  nword;   {disk number: 1=A:, 2=B:, etc.}
  f_attr:  nword;   {desired attributes for lookup}
  f_size:  real;   {total number of bytes in specified files}

  d:       string[3];   {output device  }
  d_path:  s040;   {output filename}
  x_path:  c040;   {pathname in ASCIIZ format}

  v_path:  s040;   {volume pathname}
  v_name:  s040;   {disk volume name}
  d_name:  s040;   {directory name}

  q_xorg:  pntr;   {pointer to 1st directory block (alpha order)}
  q_xcnt:  nword;   {number of queued directory entries}

  option:  s040;   {string to hold current command option}
  maxlin:  nword;   {23 lines per screen or 60 lines per page}
  d_flag:  nword;   {subdirectory option: 0 = omit, 1 or 2 = include}
  w_flag:  nword;   {write-protected option:   same as above}
  s_flag:  nword;   {"system" files option:    same as above}
  i_flag:  nword;   {"invisible" files option: same as above}
  u_flag:  nword;   {"updated" files option:   same as above}
  x_flag:  nword;   {1 = options only, 2 = all files, 3 = free space only}

  v_date:  s008;   {string to hold current date as MM/DD/YY}
  v_time:  s008;   {string to hold current time as HH:MM:SS}

  mon:     nword;   {current month  }
  day:     nword;   {current day    }
  yrs:     nword;   {current year   }

  hrs:     nword;   {current hours  }
  min:     nword;   {current minutes}
  sec:     nword;   {current seconds}

  i:       nword;   {something to count on ...}
  j:       nword;
  n:       longint;   {current display line number}
  p:       pntr;   {pointer to current queue entry}
  x:       nword;   {directory search status}


{PROCEDURE TO CONVERT A 32-BIT UNSIGNED INTEGER TO FLOATING-POINT FORMAT}

function  cvt(a:dword):real;
  var i,j,m:byte; n,x:real;
  begin
  n := 0.0;
  x := 1.0;
  for i := 0 to 3 do
  begin
  m := a[i];
  for j := 1 to 8 do
  begin
  if (m and 1) > 0 then
  n := n   + x;
  x := 2.0 * x;
  m := m shr 1;
  end;
  end;
  cvt := n;
  end;


{PROCEDURE TO CONVERT A 16-BIT UNSIGNED INTEGER TO FLOATING-POINT FORMAT}

function  cvt2real(m:nword):real;
  var n,x:real;
  begin
  n := 0.0;
  x := 1.0;
  while m > 0 do
  begin
  if (m and 1) > 0 then
  n := n   + x;
  x := 2.0 * x;
  m := m shr 1;
  end;
  cvt2real := n;
  end;


{PROCEDURE TO FORMAT A FLOATING-POINT NUMBER INTO A STRING}

function  fmt_real(v:real):s008;
  var x:s008;
  begin
  str(v:8:0,x); while x[1] = ' ' do delete(x,1,1);
  fmt_real:=x;
  end;


{PROCEDURE TO OBTAIN THE CURRENT DISK DRIVE NUMBER}

function  getdrv:byte;
  begin
  regs.AH := 25;
  Intr(33,regs);
  getdrv := regs.AL+1;
  end;


{PROCEDURE TO OBTAIN THE DISK TRANSFER AREA LOCATION}

procedure getdta;
  begin
  regs.AH := 47;
  Intr(33,Dos.Registers(regs));
  f := ptr(regs.ES,regs.BX);
  end;


{PROCEDURE TO OBTAIN THE ATTRIBUTES OF THE SPECIFIED FILE}

function  getatr:nword;
  begin
  regs.DS := seg(x_path);
  regs.DX := ofs(x_path);
  regs.AL := $0;
  regs.AH := 67;
  Intr(33,Dos.Registers(regs));
  if (regs.Flags and $01) > 0 then regs.CX := 0; {error}
  if (regs.CX    and $40) > 0 then regs.CX := 0; {root }
  getatr := regs.CX;
  end;


{PROCEDURE TO OBTAIN THE FIRST SPECIFIED DIRECTORY BLOCK}

function  get1st:nword;
  begin
  regs.DS := seg(x_path);
  regs.DX := ofs(x_path);
  regs.CX := f_attr;
  regs.AH := 78;
  Intr(33,Dos.Registers(regs));
  if regs.AX = 18 then regs.AX := 2;
  get1st := regs.AX;
  end;


{PROCEDURE TO OBTAIN THE NEXT SPECIFIED DIRECTORY BLOCK}

function  getnxt:nword;
  begin
  regs.CX := f_attr;
  regs.AH := 79;
  Intr(33,Dos.Registers(regs));
  getnxt := regs.AX;
  end;


{PROCEDURE TO COMPUTE REMAINING DISK SPACE}

function  freespace:s008;
  var x:real;
  begin
  regs.DL := f_disk;
  regs.AH := 54;
  Intr(33,Dos.Registers(regs));
  x := cvt2real(regs.AX) * cvt2real(regs.BX) * cvt2real(regs.CX);
  freespace := fmt_real(x);
  end;


{PROCEDURE TO DISPLAY REMAINING DISK SPACE}

procedure diskspace;
  begin
  writeln(freespace,' bytes free.');
  halt;
  end;


{PROCEDURE TO OBTAIN CURRENT DATE AND TIME}

procedure getime;
  begin
  regs.AH :=  42;
  Intr (33,Dos.Registers(regs));
  mon := regs.DH;
  day := regs.DL;
  yrs := regs.CX-1900;
  regs.AH :=  44;
  Intr (33,Dos.Registers(regs));
  hrs := regs.CH;
  min := regs.CL;
  sec := regs.DH;
  end;


{PROCEDURE TO FORMAT THE DATE AND TIME}

procedure setime;
  begin
  v_date    := 'MM/DD/YY';
  v_date[1] := chr(mon div 10 + $30); if v_date[1] = '0' then v_date[1] := ' ';
  v_date[2] := chr(mon mod 10 + $30);
  v_date[4] := chr(day div 10 + $30);
  v_date[5] := chr(day mod 10 + $30);
  v_date[7] := chr(yrs div 10 + $30);
  v_date[8] := chr(yrs mod 10 + $30);
  v_time    := 'HH:MM:SS';
  v_time[1] := chr(hrs div 10 + $30); if v_time[1] = '0' then v_time[1] := ' ';
  v_time[2] := chr(hrs mod 10 + $30);
  v_time[4] := chr(min div 10 + $30);
  v_time[5] := chr(min mod 10 + $30);
  v_time[7] := chr(sec div 10 + $30);
  v_time[8] := chr(sec mod 10 + $30);
  end;


{PROCEDURE TO CONVERT A TURBO PASCAL STRING INTO AN ASCIIZ STRING}

procedure asciiz(var a:s040;var b:c040);
  var i,n:nword;
  begin
  n := length(a); for i := 1 to n do b[i-1] := a[i]; b[n] := #0;
  end;


{PROCEDURE TO CONVERT AN ASCIIZ FILENAME TO 8+3 (FILENAME+EXTENSION) FORMAT}

procedure cvtstr(var a:c013;var b:c011);
  var i,j:byte;
  begin
  i:=0;
  for j := 0 to  7 do
  begin
  if (a[i] > #0) and (a[i] <> '.')
    then begin
         b[j] := a[i];
         i:=i+1;
         end
    else b[j] := ' ';
  end;
  if a[i] = '.' then i:=i+1;
  for j := 8 to 10 do
  begin
  if a[i] > #0
    then begin
         b[j] := a[i];
         i:=i+1;
         end
    else b[j] := ' ';
  end;
  end;


{PROCEDURE TO EXTRACT THE VOLUME NAME FROM THE ROOT DIRECTORY}

procedure setvnam;
  var i:nword;
  begin
  if (f^.attr and $08) =  $00 then exit;
  i:=0; while f^.name[i] > #0 do i:=i+1;
  v_name[0] := chr(i); move(f^.name,v_name[1],i);
  end;


{PROCEDURE TO COMPARE TWO CHARACTER STRINGS (ARRAYS)}
{   RETURNS: 0 IF EQUAL, +1 IF A > B; -1 IF A < B   }

function  compstr(a:c011;b:c011;cnt:nword):nword;
  var i,x:nword;
  begin
  i:=0;
  x:=0;
  while (i < cnt) and (x = 0) do
  begin
  if upcase(a[i]) > upcase(b[i]) then x := +1;
  if upcase(a[i]) < upcase(b[i]) then x := -1;
  i:=i+1;
  end;
  compstr := x;
  end;


{PROCEDURE TO ENQUEUE A SPECIFIED FILENAME (IN ALPHANUMERIC ORDER)}

procedure enqueue;
(*  var s:byte; p,n,x:^direcd; *)
  var s:byte; p,n,x:pntr;
  begin
  if ((f^.attr and $08) > 0) {**************} then exit;
  if   f^.name[0] = '.'      {**************} then exit;
  if x_flag = 0 then
  begin
  s:=0;
  if ((f^.attr and $10) > 0) and (d_flag = 2) then s:=1;
  if ((f^.attr and $04) > 0) and (s_flag = 2) then s:=1;
  if ((f^.attr and $02) > 0) and (i_flag = 2) then s:=1;
  if ((f^.attr and $01) > 0) and (w_flag = 2) then s:=1;
  if ((f^.attr and $20) > 0) and (u_flag = 2) then s:=1;
  if s = 0 then
  begin
  if ((f^.attr and $10) > 0) and (d_flag = 0) then exit;
  if ((f^.attr and $04) > 0) and (s_flag = 0) then exit;
  if ((f^.attr and $02) > 0) and (i_flag = 0) then exit;
  if ((f^.attr and $01) > 0) and (w_flag = 0) then exit;
  if ((f^.attr and $20) > 0) and (u_flag = 0) then exit;
  end;
  end;
  if x_flag = 1 then
  begin
  if ((f^.attr and $10) > 0) and (d_flag = 2) then else
  if ((f^.attr and $04) > 0) and (s_flag = 2) then else
  if ((f^.attr and $02) > 0) and (i_flag = 2) then else
  if ((f^.attr and $01) > 0) and (w_flag = 2) then else
  if ((f^.attr and $20) > 0) and (u_flag = 2) then else
  {**********************************************} exit;
  end;
  p := nil;    {pred entry pointer}
  n := q_xorg; {succ entry pointer}
  new(x);      {this entry pointer}
  cvtstr(f^.name,x^.name);
  x^.attr := f^.attr;
  x^.time := f^.time;
  x^.date := f^.date;
  x^.size := cvt(f^.size);
  x^.fptr := nil;
  f_size  := f_size + x^.size;
  q_xcnt  := q_xcnt + 1;
  while (n <> nil) and (x^.fptr = nil) do
  begin
  if compstr(x^.name,n^.name,11) < 0
    then begin {*** insert entry here. ***}
         x^.fptr := n;
         n := nil;
         end
    else begin {*** get the next entry ***}
         p := n;
         n := n^.fptr;
         end;
  end;
  if n = nil
    then begin {*** append entry here. ***}
         if p <> nil then
         p^.fptr := x else
         q_xorg  := x;
         end;
  end;


{PROCEDURE TO TEST FOR A FILENAME DELIMITER}

function  d_limit(c:char):byte;
  begin
  case c of
  '/': d_limit := 1;
  '\': d_limit := 1;
  ':': d_limit := 1;
  else d_limit := 0;
  end;
  end;


{PROCEDURE TO DISPLAY THE NEXT PAGE}

procedure nextpage;
  var c:char;
      x:nword;
  begin
  if d_path <> 'CON:'
    then write(d,#$0C)
    else begin
         writeln;
         writeln;
         write  ('Next page (Y/N)? '); c := ReadKey; c := upcase(c); write(c);
         x := WhereY;
         gotoxy(1,x);  x:=x-1; ClrEOL;
         gotoxy(1,x);  x:=x-1;
         if c = 'N' then halt;
         gotoxy(1,x);
         end;
  end;


{PROCEDURE TO PROCESS A COMMAND LINE ERROR}

procedure fatal;
  begin
  writeln('Invalid option: ',option);
  halt;
  end;



begin {MAIN PROGRAM}

  v_name := 'none'; {assume unnamed volume}
  d_path := 'CON:'; {assume console display}
  f_disk := getdrv; {get current disk number}
  f_path := '';
  f_size :=  0;     {DEFAULTS:                      }
  d_flag :=  1;     {- include subdirectories       }
  i_flag :=  0;     {- suppress invisible files     }
  s_flag :=  0;     {- suppress system files        }
  w_flag :=  1;     {- include write-protected files}
  u_flag :=  1;     {- include updated files        }
  x_flag :=  0;
  q_xcnt :=  0;
  q_xorg := nil;

  n := ParamCount; for i := 1 to n do
  begin
  option := ParamStr(i); if length(option) < 2 then option[2] := #0;
  if option[1] = '=' then x_flag := 1;
  if option[1] = '+'
    then case upcase(option[2]) of
         'D': d_flag := 2;
         'S': s_flag := 2;
         'I': i_flag := 2;
         'W': w_flag := 2;
         'U': u_flag := 2;
         else fatal;
         end
    else
  if option[1] = '-'
    then case upcase(option[2]) of
         'D': d_flag := 0;
         'S': s_flag := 0;
         'I': i_flag := 0;
         'W': w_flag := 0;
         'U': u_flag := 0;
         else fatal;
         end
    else
  if option[1] = '='
    then case upcase(option[2]) of
         'A': x_flag := 2;
         'D': d_flag := 2;
         'S': s_flag := 2;
         'I': i_flag := 2;
         'W': w_flag := 2;
         'U': u_flag := 2;
         'Z': x_flag := 3;
         else fatal;
         end
    else
  if option[1] = '@'       {because redirection is soooooooooooo slow ...}
    then begin
         d_path := '';
         for  i := 2 to length(option) do d_path := d_path + upcase(option[i]);
         end
    else f_path := option;
  end;

  for i := 1 to length(f_path) do f_path[i] := upcase(f_path[i]);

  asciiz (f_path,x_path); if (getatr and $10) > 0 then f_path := f_path+'\';
  i := length(f_path); while (i > 0) and (d_limit(f_path[i]) = 0) do i:=i-1;
  if i > 0  then move(f_path,d_name,i+1); d_name[0] := chr(i);
  if i = 0  then GetDir(0000,d_name);
  j := length(f_path)-i;  if (j = 0) then f_path := f_path + '*.*';
  if j = 1 then if f_path[i+1] = '*' then f_path := f_path +  '.*';

  if copy(f_path,2,4) = ':*.*' then insert('\',f_path,3);

  if (length(d_name) < 2) or (d_name[2] <> ':') then d_name := chr(f_disk+$40)+':'+d_name;
  if (length(f_path) < 2) or (f_path[2] <> ':') then f_path := chr(f_disk+$40)+':'+f_path;

  f_disk := ord(f_path[1]) - $40;
  v_path := chr(f_disk+$40)+':\*.*';

  if x_flag = 3 then {free space only}
  diskspace;

  getdta;

  asciiz (v_path,x_path);  f_attr := $0008; {look for the disk volume name}
  x := get1st; while x = 0 do begin setvnam; x := getnxt; end;

  asciiz (f_path,x_path);  f_attr := $00F7; {look for specified file names}
  x := get1st; while x = 0 do begin enqueue; x := getnxt; end;

  if q_xcnt = 0 then {no specified filenames found here!}
  begin
  writeln('Not found');
  halt;
  end;

  while  d_name[length(d_name)] in ['/','\'] do
  delete(d_name,length(d_name),1);

  if d_path = 'PRN:' then d :=  'LST';
  maxlin := 2*60;
  if d_path = 'CON:' then
    begin
      d := '';
      filler[4] := #$B3;
      maxlin := 2*23;
    end;


  if d_path <> 'CON:' then {forms feed}
    nextpage;

  getime;
  setime;

  write(d,'Volume Label: ',v_name); for i := 1 to 51-length(v_name) do write(d,' '); writeln(d,'Date: ',v_date);
  write(d,'Directory of: ',d_name); for i := 1 to 51-length(d_name) do write(d,' '); writeln(d,'Time: ',v_time);

  p := q_xorg;
  n := 6;

  repeat

  if (n mod 2) = 0 then writeln(d);
  for i := 0 to  7 do write(d,p^.name[i]);
  if p^.name[8] > ' '
    then write(d,'.')
    else write(d,' ');
  for i := 8 to 10 do write(d,p^.name[i]);
  write(d,'  ');
  if (p^.attr and $01) = 0 then write(d,'-') else write(d,'W');
  if (p^.attr and $04) = 0 then write(d,'-') else write(d,'S');
  if (p^.attr and $02) = 0 then write(d,'-') else write(d,'I');
  if (p^.attr and $20) = 0 then write(d,'-') else write(d,'U');
  if (p^.attr and $10) > 0
    then write(d, '   <dir>')
    else write(d,p^.size:8:0);
  write(d,'  ');
  mon := (p^.date shr 5) and $000F;
  day := (p^.date      ) and $001F;
  yrs := (p^.date shr 9)  +     80;
  setime; write(d,v_date);
  if (n mod 2) = 0 then
  if q_xcnt    > 1 then
  write(d,filler);
  p := p^.fptr;
  n := n+1;

  if (n mod maxlin) = 0 then {page (screen) is full}
  nextpage;

  until p = nil;

  if (n mod maxlin) in [maxlin-3..maxlin-1] then {will overrun last page}
  nextpage;

  writeln(d);
  writeln(d);                                  if q_xcnt > 0 then
  write  (d,q_xcnt,' file');                   if q_xcnt > 1 then
  write  (d,'s');                              if f_size > 0 then
  write  (d,' in ',fmt_real(f_size),' bytes'); if q_xcnt > 0 then
  write  (d,'; ');
  writeln(d,freespace,' bytes free.');


end.

