                       F i l e    I n f o r m a t i o n

* DESCRIPTION
This program sets-up an interactive menu in which the user selects
certain printer options.
Requires: Turbo Pascal 4.0. Author: Christopher Maeder. Version 1.03.
Converted to version 4.0.

* ASSOCIATED FILES
PRINTER.PAS
CONFIG.PRN
TEMPLATE.GEN


* KEYWORDS
PASCAL 4.0 PRINTER CONTROL MENU UTILITY

==========================================================================
}
{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}

Program Printer_Control;
{ *************************************************************************** }
{ *                                                                         * }
{ *                  EPSON PRINTER CONFIGURATION PROGRAM                    * }
{ *                            Version 1.03                                 * }
{ *                                                                         * }
{ *                        Written by Chris Maeder                          * }
{ *                            October 1985                                 * }
{ *                                                                         * }
{ *      This program sets-up an interactive menu in which the user         * }
{ *      selects certain printer options.  This program relies on having    * }
{ *      to read the printer configuration parameters and screen            * }
{ *      template which are stored in the file 'CONFIG.PRN'.  This          * }
{ *      program can be very easily modified for any printer.  For the      * }
{ *      most part one needs only to alter the file 'CONFIG.PRN'.  This     * }
{ *      can be done with the template generator program.  Happy            * }
{ *      Programing!!                                                       * }
{ *                                                                         * }
{ *************************************************************************** }



{ $C-, This compiler directive is required to prevent typed ahead characters
  from being lost }




Uses
  Crt,
  Dos,
  Printer;

Const

  RECORD_LIMIT=20;                  { Number of screen entries }
  INPUT_LENGTH=2;                   { Legal length of integer string defining left margin }



Type

  ConfigurationRecord=
    Record
      PromptCol,PromptRow,InputCol:Integer;
      UpKeyPointer,DownKeyPointer:Integer;
      LeftKeyPointer,RightKeyPointer:Integer;
      OnCode1,OnCode2,OnCode3:Integer;
      OffCode1,OffCode2,OffCode3:Integer;
      ToggleSwitch:Integer;
      Prompt:String[50];
    End;  { ConfigurationRecord }

  WorkString=String[79];

  ColorType=0..31;



Var

  ScreenPrompts:Array[1..RECORD_LIMIT] of ConfigurationRecord;
  ConfigurationFile:File Of ConfigurationRecord;
  OldInputPrompt,CurrentInputPrompt:Integer;
  CharEntry:Char;
  Escape:Boolean;

  { Screen Colors }
  ForegroundColor:ColorType;               { Normal foreground color }
  BackgroundColor:ColorType;               { Normal background color }
  HighlightColor:ColorType;                { Highlight color }
  PromptHighlightColor:ColorType;          { Prompt highlight color }
  BlockForegroundColor:ColorType;          { Input block foreground color }
  BlockBackgroundColor:ColorType;          { Input block background color }
  EntryColor:ColorType;                    { Color of characters being entered }



Procedure ReadFileEntries;

{ This procedure reads the entries out of the file 'CONFIG.PRN'
  and stores the entries into the proper ScreenPrompts array record. }

Var
  I:Integer;

Begin   { ReadFileEntries }
  {$I-}
  Assign(ConfigurationFile,'CONFIG.PRN');                { assign to a disk file }
  Reset(ConfigurationFile);                              { open the file for reading }
  For I:=1 to RECORD_LIMIT Do
    Read(ConfigurationFile,ScreenPrompts[I]);            { read record off of disk }
  Close(ConfigurationFile);
  {$I+}
End;    { ReadFileEntries }



Procedure WriteFileEntries;

{ This procedure takes the entries stored in the ScreenPrompts
  array records and writes them to the file 'CONFIG.PRN' .}

Var
  I:Integer;

Begin   { WriteFileEntries }
  {$I-}
  Assign(ConfigurationFile,'CONFIG.PRN');                { assign to a file on disk }
  Rewrite(ConfigurationFile);                            { open the file for writing, removes any previous entries }
  For I:=1 To RECORD_LIMIT Do
    Write(ConfigurationFile,ScreenPrompts[I]);           { put the next record out to disk file }
  Close(ConfigurationFile);
  {$I+}
End;    { WriteFileEntries }



Procedure ConfigurePrinter;

{ This procedure sends the proper configuration code signals to the printer. }

Var
  I:Integer;

Begin   { ConfigurePrinter }
  For I:=1 To RECORD_LIMIT Do
    With ScreenPrompts[I] Do
      If ToggleSwitch=0 Then                             { specific configuration mode is off }
        Write(Lst,Chr(OffCode1),Chr(OffCode2),Chr(OffCode3));
  For I:=1 To RECORD_LIMIT Do
    With ScreenPrompts[I] Do
      If ToggleSwitch=1 Then                             { specific configuration mode is on }
        Write(Lst,Chr(OnCode1),Chr(OnCode2),Chr(OnCode3));
End;    { ConfigurePrinter }



Procedure SoundError;

{ This procedure makes a sound when an illegal character has been entered. }

Begin   { SoundError }
  Sound(230);Delay(50);NoSound;
End;    { SoundError }



Procedure DrawWindow2(BeginCol,BeginRow,EndCol,EndRow:Integer);

{ This procedure draws a rectangular window with a double line border at the
  location specified.

 ( BeginCol,BeginRow ) ==========================
                      ||                        ||
                      ||                        ||
                      ||         Window         ||
                      ||                        ||
                      ||                        ||
                       ==========================  ( EndCol,EndRow) }

Var
  I:Integer;
  BorderLine:String[77];

Begin   { DrawWindow2 }
  Window(BeginCol,BeginRow,EndCol,EndRow);
  ClrScr;
  BorderLine:='';
  For I:=BeginCol+2 To EndCol-2 Do
      BorderLine:=BorderLine+Chr(205);
  GotoXY(2,1);
  Write(Chr(201),BorderLIne,Chr(187));
  For I:=2 To EndRow-BeginRow Do
    Begin
      GotoXY(2,I);
      Write(Chr(186));
      GotoXY(EndCol-BeginCol,I);
      Write(Chr(186));
    End; { For I }
  GotoXY(2,EndRow-BeginRow+1);
  Write(Chr(200),BorderLine,Chr(188));
  Window(1,1,80,25);
End;    { DrawWindow2 }



Procedure WriteCenterText(Row:Integer;TextString:WorkString);

{ This procedure centers and writes a string of text at a given row on the
  monitor screen. }

Begin   { WriteCenterText }
  TextColor(HighlightColor);
  TextBackground(BackgroundColor);
  GotoXY(40-((Length(TextString)) div 2),Row);
    Write(TextString);
End;    { WriteCenterText }



Function MonitorType:Byte;

{ This function returns an integer value corresponding to the current display
  mode of the video monitor.  IBM specific.  Typical values follow:

          VALUE     MONITOR/ADAPTER     VIDEO MODE

            0       Color/Graphics      40  x 25  B/W
            1       Color/Graphics      40  x 25  Color
            2       Color/Graphics      80  x 25  B/W
            3       Color/Graphics      80  x 25  Color
            4       Color/Graphics      320 x 200 Color
            5       Color/Graphics      320 x 200 B/W
            6       Color/Graphics      640 x 200 B/W
            7       Monochrome          80  x 25  B/W    }

Begin   { MonitorType }
  MonitorType:=Mem[$0040:$0049];
End;    { MonitorType }



Procedure HideBlinkingCursor;

{ This procedure hides the blinking cursor.  IBM specific. }

Begin   { HideBlinkingCursor }
  InLine($B9/$0F00/               {   mov   cx,0F00       ; turn cursor off  }
{!^ 1. New stack conventions require that many Inlines be rewritten.}
         $B4/$01/                 {   mov   ah,01         ; cursor type      }
         $CD/$10);                {   int   10            ; screen interrupt }
End;    { HideBlinkingCursor }



Procedure ShowBlinkingCursor;

{ This procedure first determines what type of monitor is being used.  It
  then sets the proper visible cursor for that monitor.  IBM specific. }

Begin   { ShowBlinkingCursor }
  If MonitorType=7 Then  { monochrome }
    InLine($B9/$0C0D/             {   mov   cx,0C0D       ; turn monochrome cursor on  }
{! 2^. New stack conventions require that many Inlines be rewritten.}
           $B4/$01/               {   mov   ah,01         ; cursor type                }
           $CD/$10)               {   int   10            ; screen interrupt           }
  Else { color or enhanced color }
    InLine($B9/$0607/             {   mov   cx,0F00       ; turn color cursor on       }
{! 3^. New stack conventions require that many Inlines be rewritten.}
           $B4/$01/               {   mov   ah,01         ; cursor type                }
           $CD/$10);              {   int   10            ; screen interrupt           }
End;    { ShowBlinkingCursor }



Function PrinterReady:Boolean;

{ This functions tests the printer port to see if the printer is ready to
  receive text from the computer.  If the function returns as true then printer
  is ready to receive, otherwise if false there is an I/O error to the
  printer.  Note that this function can only be accessed once if the printer
  is not available, otherwise it will return as true the second time you test
  the printer port. }


Var
  Register:Registers;          { variable used in reading internal registers }
  AH:Byte;                     { variable used to store contents of Hi byte of register AX }
  Mask:Byte;                    { variable used to mask out all of the bits except the one we are interested in }

Begin   { PrinterReady }
  Mask:=8;                             { initialize the mask to get the third bit which we are interested in }
  Register.AX:=$0200;                  { place function number 0200h, read printer status into register AH  }
  Intr($17,Register);                  { invoke DOS interrupt 17h }
  AH:=Hi(Register.AX);                 { get the hi byte from register AX }
  AH:=(AH And Mask);                   { mask out everything but the third bit, if bit #3 = 1 then I/O error }
  If AH=0 Then
    PrinterReady:=True
  Else
    PrinterReady:=False;
End;    { PrinterReady }



Procedure InitScreenColors;

{ This procedure first determines what type of monitor is being used.  It
  then sets the proper screen colors for that monitor. }

Begin   { InitScreenColors }
  If MonitorType=3 Then
    Begin { Color Screen Constants }
      ForegroundColor:=7;               { Normal foreground color }
      BackgroundColor:=1;               { Normal background color }
      HighlightColor:=15;               { Highlight prompt }
      PromptHighlightColor:=14;         { Highlight prompt }
      BlockForegroundColor:=1;          { Color of highlighted input block foreground }
      BlockBackgroundColor:=7;          { Color of highlighted input block background }
      EntryColor:=31;                   { Color of characters being entered }
    End { If MonitorType }
  Else
    Begin { Mono Screen Constants }
      ForegroundColor:=7;               { Normal foreground color }
      BackgroundColor:=0;               { Normal background color }
      HighlightColor:=15;               { Highlight prompt }
      PromptHighlightColor:=15;         { Highlight prompt }
      BlockForegroundColor:=0;          { Color of highlighted input block foreground }
      BlockBackgroundColor:=7;          { Color of highlighted input block background }
      EntryColor:=31;                   { Color of characters being entered }
    End; { If MonitorType }
End;    { InitScreenColors }



Procedure ShowScreenPrompts;

{ This procedure locates and prints on the screen the ScreenPrompts. }

Var
  I:Integer;

Begin   { ShowScreenPrompts }
  TextColor(HighlightColor);
  TextBackground(BackgroundColor);
  GotoXY(5,3);
    Write('FONT TYPE');
  GotoXY(5,7);
    Write('CHARACTER SIZE');
  GotoXY(44,3);
    Write('CHARACTER SPACING');
  GotoXY(44,7);
    Write('LINE SPACING');
  GotoXY(5,13);
    Write('ADDITIONAL PRINTER SET-UP COMMANDS');
  TextColor(ForegroundColor);
  For I:=1 To RECORD_LIMIT Do
    With ScreenPrompts[I] Do
      Begin
        GotoXY(PromptCol,PromptRow);
        Write(Prompt);
      End; { With ScreenPrompts }
End;    { ShowScreenPrompts }



Procedure ReviseOtherToggleSwitches;

{ This procedure adjusts the other toggle switches so that there can only be
  one toggle switch on within a group. }

Begin   { ReviseOtherToggleSwitches }
  Case CurrentInputPrompt Of
    1:  Begin   { Roman Font }
          ScreenPrompts[2].ToggleSwitch:=0;
        End;    { Roman Font }
    2:  Begin   { Italic Font }
          ScreenPrompts[1].ToggleSwitch:=0;
        End;    { Italic Font }
    3:  Begin   { Standard Character Size }
          ScreenPrompts[4].ToggleSwitch:=0;
          ScreenPrompts[5].ToggleSwitch:=0;
          If (ScreenPrompts[6].ToggleSwitch=0) And (ScreenPrompts[7].ToggleSwitch=0) Then
            Begin
              ScreenPrompts[6].ToggleSwitch:=0;
              ScreenPrompts[7].ToggleSwitch:=1;
            End; { If ScreenPrompts }
          If ScreenPrompts[10].ToggleSwitch=1 Then
            Begin
              ScreenPrompts[8].ToggleSwitch:=0;
              ScreenPrompts[9].ToggleSwitch:=1;
              ScreenPrompts[10].ToggleSwitch:=0;
            End; { If ScreenPrompts }
        End;    { Standard Character Size }
    4:  Begin   { Compressed Character Size }
          ScreenPrompts[3].ToggleSwitch:=0;
          ScreenPrompts[5].ToggleSwitch:=0;
          ScreenPrompts[6].ToggleSwitch:=0;
          ScreenPrompts[7].ToggleSwitch:=0;
          ScreenPrompts[11].ToggleSwitch:=1;
          ScreenPrompts[12].ToggleSwitch:=0;
          If ScreenPrompts[10].ToggleSwitch=1 Then
            Begin
              ScreenPrompts[8].ToggleSwitch:=0;
              ScreenPrompts[9].ToggleSwitch:=1;
              ScreenPrompts[10].ToggleSwitch:=0;
            End; { If ScreenPrompts }
        End;    { Compressed Character Size }
    5:  Begin   { Super Compressed Character Size }
          ScreenPrompts[3].ToggleSwitch:=0;
          ScreenPrompts[4].ToggleSwitch:=0;
          ScreenPrompts[6].ToggleSwitch:=0;
          ScreenPrompts[7].ToggleSwitch:=0;
          ScreenPrompts[11].ToggleSwitch:=1;
          ScreenPrompts[12].ToggleSwitch:=0;
        End;    { Super Compressed Character Size }
    6:  Begin   { 10 Character Per Inch Character Spacing }
          ScreenPrompts[3].ToggleSwitch:=1;
          ScreenPrompts[4].ToggleSwitch:=0;
          ScreenPrompts[5].ToggleSwitch:=0;
          ScreenPrompts[7].ToggleSwitch:=0;
          If ScreenPrompts[10].ToggleSwitch=1 Then
            Begin
              ScreenPrompts[8].ToggleSwitch:=0;
              ScreenPrompts[9].ToggleSwitch:=1;
              ScreenPrompts[10].ToggleSwitch:=0;
            End; { If ScreenPrompts }
        End;    { 10 Character Per Inch Character Spacing }
    7:  Begin   { 12 Character Per Inch Character Spacing }
          ScreenPrompts[3].ToggleSwitch:=1;
          ScreenPrompts[4].ToggleSwitch:=0;
          ScreenPrompts[5].ToggleSwitch:=0;
          ScreenPrompts[6].ToggleSwitch:=0;
          ScreenPrompts[11].ToggleSwitch:=1;
          ScreenPrompts[12].ToggleSwitch:=0;
          If ScreenPrompts[10].ToggleSwitch=1 Then
            Begin
              ScreenPrompts[8].ToggleSwitch:=0;
              ScreenPrompts[9].ToggleSwitch:=1;
              ScreenPrompts[10].ToggleSwitch:=0;
            End; { If ScreenPrompts }
        End;    { 12 Character Per Inch Character Spacing }
    8 : Begin   { 66 Lines Per Page Line Spacing }
          ScreenPrompts[9].ToggleSwitch:=0;
          ScreenPrompts[10].ToggleSwitch:=0;
        End;    { 66 Lines Per Page Line Spacing }
    9 : Begin   { 88 Lines Per Page Line Spacing }
          ScreenPrompts[8].ToggleSwitch:=0;
          ScreenPrompts[10].ToggleSwitch:=0;
        End;    { 88 Lines Per Page Line Spacing }
    10: Begin   { 160 Lines Per Page Line Spacing }
          ScreenPrompts[8].ToggleSwitch:=0;
          ScreenPrompts[9].ToggleSwitch:=0;
          ScreenPrompts[6].ToggleSwitch:=0;
          ScreenPrompts[7].ToggleSwitch:=0;
          ScreenPrompts[11].ToggleSwitch:=1;
          ScreenPrompts[12].ToggleSwitch:=0;
          If (ScreenPrompts[3].ToggleSwitch=1) Or (ScreenPrompts[4].ToggleSwitch=1) Then
            Begin
              ScreenPrompts[3].ToggleSwitch:=0;
              ScreenPrompts[4].ToggleSwitch:=0;
              ScreenPrompts[5].ToggleSwitch:=1;
            End; { If ScreenPrompts }
        End;    { 160 Lines Per Page Line Spacing }
    11: Begin   { Non-emphasized Characters }
          ScreenPrompts[12].ToggleSwitch:=0;
        End;    { Non-emphasized Characters }
    12: Begin   { Emphasized Characters }
          ScreenPrompts[3].ToggleSwitch:=1;
          ScreenPrompts[4].ToggleSwitch:=0;
          ScreenPrompts[5].ToggleSwitch:=0;
          ScreenPrompts[6].ToggleSwitch:=1;
          ScreenPrompts[7].ToggleSwitch:=0;
          ScreenPrompts[11].ToggleSwitch:=0;
          If ScreenPrompts[10].ToggleSwitch=1 Then
            Begin
              ScreenPrompts[8].ToggleSwitch:=0;
              ScreenPrompts[9].ToggleSwitch:=1;
              ScreenPrompts[10].ToggleSwitch:=0;
            End; { If ScreenPrompts }
        End;    { Emphasized Characters }
    13: Begin   { Standard Width Characters }
          ScreenPrompts[14].ToggleSwitch:=0;
        End;    { Standard Width Characters }
    14: Begin   { Double Width Characters }
          ScreenPrompts[13].ToggleSwitch:=0;
        End;    { Double Width Characters }
    15: Begin   { Mono Character Spacing }
          ScreenPrompts[16].ToggleSwitch:=0;
        End;    { Mono Character Spacing }
    16: Begin   { Proportional Character Spacing }
          ScreenPrompts[15].ToggleSwitch:=0;
        End;    { Proportional Character Spacing }
    17: Begin   { Single Strike Printing }
          ScreenPrompts[18].ToggleSwitch:=0;
        End;    { Single Strike Printing }
    18: Begin   { Double Strike Printing }
          ScreenPrompts[17].ToggleSwitch:=0;
        End;    { Double Strike Printing }
    19: Begin   { Lines Skipped @ Perforation }
          If ScreenPrompts[19].OnCode3=0 Then
            ScreenPrompts[19].ToggleSwitch:=0
          Else
            ScreenPrompts[19].ToggleSwitch:=1;
        End;    { Lines Skipped @ Perforation }
  End; { Case CurrentInputPrompt }
End;    { ReviseOtherToggleSwitches }



Procedure ShowToggleSwitches;

{ This procedure locates and prints on the screen the active and passive
  toggle switches. }

Var
  I:Integer;

Begin   { ShowToggleSwitches }
  For I:=1 To RECORD_LIMIT-2 Do
    With ScreenPrompts[I] Do
      Begin
        GotoXY(InputCol,PromptRow);
        If ToggleSwitch=1 Then                           { specific configuration is set to on }
          Begin
            TextColor(HighlightColor);
            TextBackground(BackgroundColor);
            Write('On');
            TextColor(ForegroundColor);
            Write('/Off');
          End { If ToggleSwitch }
        Else                                             { specific configuration is set to off }
          Begin
            TextColor(ForegroundColor);
            TextBackground(BackgroundColor);
            Write('On/');
            TextColor(HighlightColor);
            Write('Off');
          End; { Else }
      End; { With ScreenPrompts }
  TextColor(HighlightColor);
  TextBackground(BackgroundColor);
  For I:=RECORD_LIMIT-1 To RECORD_LIMIT Do
    Begin
      With ScreenPrompts[I] Do                           { print left margin spacing }
        Begin
          GotoXY(InputCol,PromptRow);
          Write(OnCode3,'  ');
        End; { With ScreenPrompts }
    End; { For I }
End;    { ShowToggleSwitches }



Procedure ShowScreenInputPrompt(InputPrompt,PromptColor,PromptBackground:Integer);

{ This procedure is used to highlight the current input prompt and input block
  and also to de-highlight the previous input prompt and input block. }

Var
  I:Integer;

Begin   { ShowScreenInputPrompt }
  With ScreenPrompts[InputPrompt] Do
    Begin
      TextColor(PromptColor);
      TextBackground(PromptBackground);
      GotoXY(PromptCol,PromptRow);
      Write(Prompt);
    End; { With ScreenPrompts }
End;    { ShowScreenInputPrompt }



Procedure MoveScreenInputPrompt;

{ This procedure controls the movement of the highlighted prompt for the
  printer configuration page. }

Begin   { MoveScreenInputPrompt }
  ShowScreenInputPrompt(OldInputPrompt,ForegroundColor,BackgroundColor);
  ShowScreenInputPrompt(CurrentInputPrompt,PromptHighlightColor,BackgroundColor);
End;    { MoveScreenInputPrompt }



Procedure DrawPrinterConfigurationPage;

{ This procedure controls the drawing of the printer parameter page. }

Var
  TextString:WorkString;

Begin   { DrawPrinterConfigurationPage }
  Escape:=False;
  OldInputPrompt:=2;
  CurrentInputPrompt:=1;
  TextColor(ForegroundColor);
  TextBackground(BackgroundColor);
  DrawWindow2(1,1,80,25);
  WriteCenterText(1,'EPSON PRINTER CONFIGURATION PROGRAM');
  TextString:='Make selection with  '+Chr(27)+'  '+Chr(26)+'  '+Chr(24)+'  '+Chr(25)+'  <Enter>  and then press Esc';
  WriteCenterText(25,TextString);
  ShowScreenPrompts;
  ShowToggleSwitches;
  ShowScreenInputPrompt(CurrentInputPrompt,PromptHighlightColor,BackgroundColor);
End;    { DrawPrinterConfigurationPage }



Procedure KeyboardEntryModule;
{ *************************************************************************** }
{ *                                                                         * }
{ *                          KEYBOARD ENTRY MODULE                          * }
{ *                                                                         * }
{ *     This module controls all of the keyboard entry.  It begins by       * }
{ *     determining what the user's keyboard entry is and then passes       * }
{ *     control to specific procedures, i.e. screen command or accumulate   * }
{ *     character entry.  All the procedures within this module can only    * }
{ *     be accessed through the outer procedure 'KeyboardEntryModule'.      * }
{ *                                                                         * }
{ *************************************************************************** }



  Procedure CurseUp;

  { This procedure controls the cursor's upward movement. }

  Begin   { CurseUp }
    With ScreenPrompts[CurrentInputPrompt] Do
      Begin
        If UpKeyPointer<>0 Then
          Begin
            OldInputPrompt:=CurrentInputPrompt;
            CurrentInputPrompt:=UpKeyPointer;
            MoveScreenInputPrompt;
          End { If UpKeyPointer }
        Else
          SoundError;
      End; { With ScreenPrompts }
  End;    { CurseUp }



  Procedure CurseDown;

  { This procedure controls the cursor's downward movement. }

  Begin   { CurseDown }
    With ScreenPrompts[CurrentInputPrompt] Do
      Begin
        If DownKeyPointer<>0 Then
          Begin
            OldInputPrompt:=CurrentInputPrompt;
            CurrentInputPrompt:=DownKeyPointer;
            MoveScreenInputPrompt;
          End { If DownKeyPointer }
        Else
          SoundError;
      End; { With ScreenPrompts }
  End;    { CurseDown }



  Procedure CurseLeft;

  { This procedure controls the cursor's leftward movement. }

  Begin   { CurseLeft }
    With ScreenPrompts[CurrentInputPrompt] Do
      Begin
        If LeftKeyPointer<>0 Then
          Begin
            OldInputPrompt:=CurrentInputPrompt;
            CurrentInputPrompt:=LeftKeyPointer;
            MoveScreenInputPrompt;
          End  { If LeftKeyPointer }
        Else
          SoundError;
      End; { With ScreenPrompts }
  End;    { CurseLeft }



  Procedure CurseRight;

  { This procedure controls the cursor's rightward movement. }

  Begin   { CurseRight }
    With ScreenPrompts[CurrentInputPrompt] Do
      Begin
        If RightKeyPointer<>0 Then
          Begin
            OldInputPrompt:=CurrentInputPrompt;
            CurrentInputPrompt:=RightKeyPointer;
            MoveScreenInputPrompt;
          End  { If RightKeyPointer }
        Else
          SoundError;
      End; { With ScreenPrompts }
  End;    { CurseRight }



  Procedure CarriageReturn;

  { This procedure controls the turning on of the toggle switch . }

  Begin   { CarriageReturn }
    With ScreenPrompts[CurrentInputPrompt] Do
      Begin
        If ToggleSwitch<>1 Then          {1=On;0=Off}
          Begin
            ScreenPrompts[CurrentInputPrompt].ToggleSwitch:=1;
            ReviseOtherToggleSwitches;
            ShowToggleSwitches;
          End { If ToggleSwitch }
        Else
          SoundError;
      End; { With ScreenPrompts }
  End;    { CarriageReturn }



  Procedure ShowEmptyEntry;

  { This procedure prints out the proper sized reversed video inbut block to
    show a empty entry. }

  Var
    I:Integer;

  Begin   { ShowEmptyEntry }
    TextColor(BlockForegroundColor);
    TextBackground(BlockBackgroundColor);
    With ScreenPrompts[CurrentInputPrompt] Do
      Begin
        GotoXY(InputCol,PromptRow);
        For I:=1 To INPUT_LENGTH Do
          Write(' ');
        GotoXY(InputCol,PromptRow);
      End; { With ScreenPrompts }
  End;    { ShowEmptyEntry }



  Procedure ShowCharEntry;

  { This procedure prints the legal character entry. }

  Begin   { ShowCharEntry }
    TextColor(EntryColor);
    TextBackground(BackgroundColor);
    Write(CharEntry);
  End;    { ShowCharEntry }



  Procedure DeleteLastChar(Var AccumCharEntry:Workstring);

  { This procedure removes the last character in the accumulated character
    entry. }

  Var
    I:Integer;

  Begin   { DeleteLastChar }
    If Length(AccumCharEntry)<>0 Then
      Begin
        Delete(AccumCharEntry,Length(AccumCharEntry),1);
        ShowEmptyEntry;
        For I:=1 To Length(AccumCharEntry) Do
          Begin
            CharEntry:=AccumCharEntry[I];
            ShowCharEntry;
          End; { For I }
      End { If Length }
    Else
      SoundError;
  End;    { DeleteLastChar }



  Procedure CheckCharEntry(Var CharEntry:Char; Var AccumCharEntry:WorkString);

  { This procedure checks inputed numeric characters. }

  Type
    CharSet=Set Of Char;

  Var
    LegalCharSet:CharSet;

  Begin   { CheckCharEntry }
    LegalCharSet:=['0'..'9'];            {Define a legal character set.}
    If (CharEntry In LegalCharSet) And (Length(AccumCharEntry)<INPUT_LENGTH) Then
      Begin
        AccumCharEntry:=AccumCharEntry+CharEntry;
        If Length(AccumCharEntry)=1 Then
          ShowEmptyEntry;
        ShowCharEntry;
      End { If CharEntry }
    Else
      SoundError;
  End;    { CheckCharEntry }



  Procedure AccumulateEntry;

  { This procedure controls the accumulation of inputed characters. }

  Var
    AccumCharEntry:WorkString;
    ErrorCode:Integer;

  Begin   { AccumulateEntry }
    ShowBlinkingCursor;
    AccumCharEntry:='';
    With ScreenPrompts[CurrentInputPrompt] Do
      GotoXY(InputCol,PromptRow);
    CheckCharEntry(CharEntry,AccumCharEntry);
    Repeat
      CharEntry := ReadKey;
      If CharEntry=#0 Then  {Read illegal two digit code without executing code command.}
        Begin
          CharEntry := ReadKey;
          SoundError;
        End { If CharEntry }
      Else
        If CharEntry=Chr(8) Then          {Backspace}
          DeleteLastChar(AccumCharEntry)
        Else
          If CharEntry<>Chr(13) Then CheckCharEntry(CharEntry,AccumCharEntry);
    Until CharEntry=Chr(13);              {Carriage Return}
    HideBlinkingCursor;
    If Length(AccumCharEntry)=0 Then
      AccumCharEntry:='0';
    Val(AccumCharEntry,ScreenPrompts[CurrentInputPrompt].OnCode3,ErrorCode);
    ReviseOtherToggleSwitches;
    ShowToggleSwitches;
  End;    { AccumulateEntry }



Begin   { KeyboardEntryModule }
  CharEntry := ReadKey;
    If CharEntry=#0 Then  {Read a character, check for two digit code.}
      Begin
        CharEntry := ReadKey;
        Case Ord(CharEntry) Of
          72:  CurseUp;
          80:  CurseDown;
          75:  CurseLeft;
          77:  CurseRight;
        Else
          SoundError;
        End; { Case Ord }
      End { If CharEntry }
    Else
      Begin
        Case Ord(CharEntry) Of
          13:  CarriageReturn;
          27:  Escape:=True;
        Else
          If (CurrentInputPrompt>=(RECORD_LIMIT-1)) Then
            AccumulateEntry
          Else
              SoundError;
        End; { Case Ord }
      End; { Else }
End;    { KeyboardEntryModule }



Begin   { Main program }
  InitScreenColors;
  ReadFileEntries;
  HideBlinkingCursor;
  DrawPrinterConfigurationPage;
  Repeat
    KeyboardEntryModule;
  Until Escape;
  WriteFileEntries;
  TextColor(LightGray);
  TextBackground(Black);
  ClrScr;
  ShowBlinkingCursor;
  If PrinterReady Then
    ConfigurePrinter
  Else
    Write('I/O error with printer, please check');
End.    { Main program }

