                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Help file for HDMENU.PAS.
Requires: Turbo Pascal 4.0. Author: James Haas. Version T.1.0.
COnverted to version 4.0.

* ASSOCIATED FILES
HDMENU.PAS
HDM.DOC
HDM.BAT
HDMENU.TXT
HDMX.BAT
BOX.INC
DATE.INC
DISPLAY.INC
HDMHELP.PAS
KEY.INC
KEYIN.INC
SCRHDR.INC
STANDARD.INC
TIME.INC

* CHECKED BY
HEL - 09/15/88

* KEYWORDS
PASCAL 4.0 DOS SHELL MENU PROGRAM

==========================================================================
}
{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}

program hdmhelp;
{INCLUDE.PAS}

Uses
  Crt,
  Dos;

{$I standard.inc} {function - strint(integer)} {reg record}
{$I display.inc}  {procedure - display(row,column,'string',attribute) 0-255}
                  {procedure - clear(row,column,number) of bytes to erase}
                  {procedure - locate(row,column,cursor) 0=none 1=norm 2=block}
{$I date.inc}     {function - Wednesday, September 18, 1954}
{$I time.inc}     {function - 12:12am; minutes = time in minutes}
{$I scrhdr.inc}   {uses display.inc, date.inc, time.inc}
                  {procedure - scrhdr('prog ver')}
{$I key.inc}      {uses display.inc}
                  {function - entry:=key [pg.341(3.0)]; extkey = true/false}
                  {procedure - waitkey; waits for key entry, updates time}
{$I keyin.inc}    {uses display.inc, key.inc} {procedure - bad_keyin, beeps}
                  {procedure - get_keyin(row,column,line,across,total,backcolor,forcolor)}
{$I box.inc}      {uses display.inc}
                  {procedure - box1(row,column,down,across,color) single lines}
                  {procedure - box2(row,column,down,across,color) double lines}
{END INCLUDE.PAS}

type letters = array [1..20] of char;
       menus = array [1..20] of string[20];
       descs = array [1..20,1..22] of string[50];

const letter : letters = ('a','b','c','d','e','f','g','h','j','k','m','n','p',
                         'r','s','t','w','x','y','z');
  menu : menus = ('How to use HELP',
                  'How to use the Menu',
                  'Hard Disk Menu keys',
                  'How to use TOP MENU',
                  'TOP MENU active keys',
                  'How to use ADD',
                  'How to use CHANGE',
                  'How to use DELETE',
                  'How to use MOVE',
                  'How to use PAGE',
                  'How to use RUN',
                  'How to use EXIT',
                  'Useful editing keys',
                  'Menu and Action text',
                  'Action text examples',
                  'Security - Passwords',
                  'Error Messages',
                  'HDMENU window layout',
                  'Installation notes',
                  'Copyright notice');
  desc : descs =(('    How to use the Hard Disk Menu Help System     ',
                  '         ',
                  '                                                  ',
                  'A list of items is displayed in the left window.  ',
                  'An explanation of the highlighted item is shown   ',
                  'in the right window.  To highlight an item use the',
                  'cursor control keys listed below:                 ',
                  '                                                  ',
                  '       Up Arrow or PgUp Key:  Move up one item.   ',
                  '     Down Arrow or PgDn Key:  Move down one item. ',
                  '                   Home Key:  Move to first item. ',
                  '                    End Key:  Move to last item.  ',
                  '           Letter Key (a-z):  Move to the item    ',
                  '                              with that letter to ',
                  '                              the left of it.     ',
                  '                                                  ',
                  '          If an invalid key is pressed            ',
                  '             the computer will beep.              ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  ' To return to the Hard Disk Menu Press q or Esc.  '),
                 ('      How to use the Hard Disk Menu Program       ',
                  '             ',
                  '                                                  ',
                  'A list of options is displayed in the left window.',
                  'A list of pages is displayed in the right window. ',
                  'As different pages are highlighted in the right   ',
                  'window, new lists of options are shown in the left',
                  'window.  To highlight a page, use the PgUp & PgDn ',
                  'keys or press the function key shown to the left  ',
                  'of the page description.  Each page contains ten  ',
                  'options numbered 1-9 and zero.  To start an option',
                  'highlight it by using the Up or Down arrow keys,  ',
                  'then press the Enter key.  An alternate method to ',
                  'activate an option is to simply press the number  ',
                  'key shown at the left of the option description.  ',
                  '                                                  ',
                  'The cursor that highlights pages in the right     ',
                  'window only stops at pages that contain options.  ',
                  'The cursor that highlights options in the left    ',
                  'window only stops at existing options.            ',
                  '                                                  ',
                  'To add, change, or delete options, see TOP MENU.  '),
                 ('             Hard Disk Menu Keyboard              ',
                  '                           ',
                  '         Keys active while in READY mode          ',
                  '    (top right corner = READY or HDM II n.nn)     ',
                  '                                                  ',
                  'NUMERIC KEYS (0-9):  Start an option that was pre-',
                  'viously defined.  If no option exists, it beeps.  ',
                  '                                                  ',
                  'UP & DOWN ARROW KEYS:  Moves the cursor up or down',
                  'the left window to highlight defined options.     ',
                  '                                                  ',
                  'FUNCTION KEYS:  Go to a page and display options. ',
                  'If no options on that page, go to the next page.  ',
                  '                                                  ',
                  'PGUP & PGDN KEYS:  Moves the cursor up or down the',
                  'right window to highlight pages that have options.',
                  '                                                  ',
                  ' HOME KEY:  Highlights the first existing option. ',
                  '  END KEY:  Highlights the last existing option.  ',
                  'ENTER KEY:  Starts the highlighted option.        ',
                  '                                                  ',
                  'SLASH KEY (/):  Displays & activates the TOP MENU.'),
                 ('             How to use the Top Menu              ',
                  '                           ',
                  '                                                  ',
                  'Press the Slash key to display a window at the top',
                  'of the screen.  The first line shows the choices  ',
                  'available in the top menu.  The second line shows ',
                  'a short description of each choice.  Move the     ',
                  'highlighter left or right with the cursor keys to ',
                  'display a different description for each one.  To ',
                  'activate your choice from the Top Menu, highlight ',
                  'the one you want and press the Enter key or simply',
                  'press the first letter of your choice on the key- ',
                  'board.  If an invalid key is pressed, the system  ',
                  'beeps.                                            ',
                  '                                                  ',
                  'While the top menu is displayed, you can still    ',
                  'move around on the main menu below using all the  ',
                  'Hard Disk Menu keys except the Slash key, the     ',
                  'Enter key, and the numeric keys.  The Slash key   ',
                  'and the numeric keys are inactive and will beep.  ',
                  'The Enter key now starts a Top Menu choice.       ',
                  'To return to the Hard Disk Menu press Q or Escape.'),
                 ('               The Top Menu Keyboard              ',
                  '                           ',
                  '        Keys active while in TOP MENU mode        ',
                  '                                                  ',
                  'ARROW KEYS, UP:  Move cursor up in left window    ',
                  '          DOWN:  Move cursor down in left window  ',
                  '          LEFT:  Move cursor left in top window   ',
                  '         RIGHT:  Move cursor right in top window  ',
                  ' PGUP and PGDN:  Move cursor up/down, right window',
                  ' FUNCTION KEYS:  Move cursor to page, right window',
                  '      HOME KEY:  Move cursor to start, left window',
                  '       END KEY:  Move cursor to end, left window  ',
                  'LETTER KEYS, H:  Start this help & tutorial system',
                  '             A:  Add an option to the main menu   ',
                  '             C:  Change an option in the main menu',
                  '             D:  Delete an option in the main menu',
                  '             M:  Move an option in the main menu  ',
                  '             P:  Change a Page description, F1-F10',
                  '             R:  Run a program (EXE, COM, or BAT) ',
                  '             E:  Exit to the DOS prompt           ',
                  '      ESC or Q:  Quit, return to the main menu    ',
                  '     ENTER KEY:  Start Top Menu highlighted choice'),
                 ('ADD...                                            ',
                  '                                                  ',
                  '     To add a new selection to the Hard Disk Menu:',
                  '                                                  ',
                  '1. Key in /A from the main menu or choose Add from',
                  '   the Top Menu.                                  ',
                  '                                                  ',
                  '2. Select the menu number on the page where you   ',
                  '   want to add the new selection.                 ',
                  '                                                  ',
                  '3. Key in the menu selection description, then    ',
                  '   press Enter.  (see Menu text)                  ',
                  '                                                  ',
                  '4. Key in the action to take when this number is  ',
                  '   selected, then press Enter.  (see Action text) ',
                  '                                                  ',
                  '5. Make another choice from the Top Menu or enter ',
                  '   Q to return to the main menu.                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  '),
                 ('CHANGE...                                         ',
                  '                                                  ',
                  '      To change a selection on the Hard Disk Menu:',
                  '                                                  ',
                  '1. Key in /C from the main menu or choose Change  ',
                  '   from the Top Menu.                             ',
                  '                                                  ',
                  '2. Select the menu number on the page where you   ',
                  '   want to change the menu description and/or the ',
                  '   action to be taken.                            ',
                  '                                                  ',
                  '3. Edit the menu selection description, then press',
                  '   the Enter key.  (see Useful editing keys)      ',
                  '                                                  ',
                  '4. Edit the action to be taken, then press the    ',
                  '   Enter key.  (see Useful editing keys)          ',
                  '                                                  ',
                  '5. Make another choice from the Top Menu or enter ',
                  '   Q to return to the main menu.                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  '),
                 ('DELETE...                                         ',
                  '                                                  ',
                  '    To delete a selection from the Hard Disk Menu:',
                  '                                                  ',
                  '1. Key in /D from the main menu or choose Delete  ',
                  '   from the Top Menu.  (see How to use TOP MENU)  ',
                  '                                                  ',
                  '2. Select the menu number on the page where you   ',
                  '   want to erase a menu selection and an action.  ',
                  '                                                  ',
                  '3. Key in Y and press Enter to confirm the delete.',
                  '                                                  ',
                  '4. Make another choice from the Top Menu or enter ',
                  '   Q to return to the main menu.                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  '),
                 ('MOVE...                                           ',
                  '                                                  ',
                  '        To move a selection in the Hard Disk Menu:',
                  '                                                  ',
                  '1. Key in /M from the main menu or choose Move    ',
                  '   from the Top Menu.  (see TOP MENU active keys) ',
                  '                                                  ',
                  '2. Select the menu number on the page where you   ',
                  '   want to move from.                             ',
                  '                                                  ',
                  '3. Select the menu number on the page where you   ',
                  '   want to move the selection to.                 ',
                  '                                                  ',
                  '4. Make another choice from the Top Menu or enter ',
                  '   Q to return to the main menu.                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  '),
                 ('PAGE...                                           ',
                  '                                                  ',
                  '  To change the description of a Page of the menu:',
                  '                                                  ',
                  '1. Key in /P from the main menu or choose Page    ',
                  '   from the Top Menu.                             ',
                  '                                                  ',
                  '2. Highlight a Page description on the main menu, ',
                  '   then press Enter.  (see Hard Disk Menu keys)   ',
                  '                                                  ',
                  '3. Change the Page description, then press Enter. ',
                  '   (use up to 18 characters)                      ',
                  '                                                  ',
                  '4. Make another choice from the Top Menu or enter ',
                  '   Q to return to the main menu.                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  '),
                 ('RUN...                                            ',
                  '                                                  ',
                  '   To run another program from the Hard Disk Menu:',
                  '                                                  ',
                  '1. Key in /R from the main menu or choose Run from',
                  '   the Top Menu.                                  ',
                  '                                                  ',
                  '2. Key in up to 64 characters of action text, then',
                  '   press enter.  This is the same as action to be ',
                  '   taken when a main menu selection is made except',
                  '   it can be 255 char.  (see Action text examples)',
                  '                                                  ',
                  '3. When the action is finished, press any key to  ',
                  '   return to the Hard Disk Menu.                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  '),
                 ('EXIT...                                           ',
                  '                                                  ',
                  '    To leave the program and go to the DOS prompt:',
                  '                                                  ',
                  '1. Key in /E from the main menu or choose Exit    ',
                  '   from the Top Menu.                             ',
                  '                                                  ',
                  '2. To return to the Hard Disk Menu program, key in',
                  '   EXIT at the DOS prompt and press Enter.  You   ',
                  '   will return where you left off in the menu.    ',
                  '   (see How to use the menu)                      ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  '),
                 ('             Useful keys in EDIT mode             ',
                  '                          ',
                  'The keyboard starts out in insert mode, press the ',
                  'insert key to switch to overwrite.  When in over- ',
                  'write mode the character at the cursor will blink.',
                  'If an invalid key is pressed or if you try to move',
                  'past the beginning or end of the line, the system ',
                  'will make a clicking sound.  Editing is done in   ',
                  'the bottom window, no other windows are affected. ',
                  '                                                  ',
                  ' LEFT ARROW:  Move the cursor left one position.  ',
                  'RIGHT ARROW:  Move the cursor right one position. ',
                  '   HOME KEY:  Move the cursor to start of line.   ',
                  '    END KEY:  Move the cursor to the end of line. ',
                  ' INSERT KEY:  Switch between insert and overwrite.',
                  ' DELETE KEY:  Delete the charactor at the cursor. ',
                  ' BACK SPACE:  Delete the charactor left of cursor.',
                  'CONTROL END:  Delete from cursor to end of line.  ',
                  '                                                  ',
                  '  ENTER KEY:  Ends editing and saves the new line.',
                  ' ESCAPE KEY:  If the line is empty, editing is    ',
                  '              aborted, if not, the line is erased.'),
                 ('          Contents of a Menu Description          ',
                  '                    ',
                  'The menu description can contain 1 to 48 letters, ',
                  'numbers, or special characters.  This is created  ',
                  'in the bottom edit window and is displayed in the ',
                  'left window next to the numbers 1 thru 0.         ',
                  '                                                  ',
                  '         Contents of an Action Description        ',
                  '                 ',
                  'The action description can contain 1 to 255       ',
                  'letters, numbers, or special characters.  It is   ',
                  'created in the bottom edit window after the menu  ',
                  'description is created.  This is the action that  ',
                  'will be taken when the menu description is picked ',
                  'from the main Hard Disk Menu.                     ',
                  '   There are three reserved character sequences:  ',
                  '   ~   represents the ENTER key.                  ',
                  '   @@  in front of a file name runs a batch file. ',
                  '   {?} or {?TEXT} pauses for user input.          ',
                  'When action is taken, the ~ is replaced by a      ',
                  '"CARRIAGE RETURN", @@ becomes "Command /C ", and  ',
                  '{?} or {?TEXT} is replaced by user keyboard entry.'),
                 ('             Examples of action text              ',
                  '                           ',
                  '                                                  ',
                  '                  CD \LOTUS~123~                  ',
                  'This would start up the 1-2-3 program from a sub- ',
                  'directory named LOTUS on the default drive.  When ',
                  'leaving 1-2-3 you will return to Hard Disk Menu.  ',
                  '                                                  ',
                  '            A:~CHKDSK~PAUSE~@@DB3SAVE~            ',
                  'This action will switch to the A drive, display   ',
                  'the available space on the floppy disk and wait.  ',
                  'When a key is hit, the batch file DB3SAVE will be ',
                  'executed and you return to the same menu display. ',
                  '                                                  ',
                  ' COPY {?ENTER PATH AND FILE NAME TO PRINT:} LPT1:~',
                  'When this selection is picked from the menu, the  ',
                  'bottom edit window will display and ask:          ',
                  '        ENTER PATH AND FILE NAME TO PRINT:        ',
                  'If the user of the menu keys in C:\PC-TALK\README ',
                  'the file will be copied from disk to the printer. ',
                  'The {?TEXT} is replaced by the user entry, in this',
                  'case it changed to:  COPY C:\PC-TALK\README LPT1: '),
                 ('                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                      Coming                      ',
                  '                       Soon                       ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  '),
                 ('             ERROR MESSAGES - HDMnnn              ',
                  '                           ',
                  '                                                  ',
                  'HDM001  Procedure aborted!             (INFO ONLY)',
                  '        Esc key was used to backout of a procedure',
                  '                                                  ',
                  'HDM202  Page must have description!    (INFO ONLY)',
                  '        Empty page descriptions are not allowed   ',
                  '                                                  ',
                  'HDM661  Error opening HDMENU.TXT!                 ',
                  '        The menu file was not in the directory    ',
                  '                                                  ',
                  'HDM662  Error opening HDMHELP.CHN!                ',
                  '        The help file was not in the directory    ',
                  '                                                  ',
                  'HDM901  Action + Keyin exceeds 255 characters!    ',
                  '        Action plus {?} was too long, rework it   ',
                  '                                                  ',
                  'HDM902  Action + @@Batch exceeds 255 characters!  ',
                  '        Action plus @@ was too long, rework it    ',
                  '                                                  ',
                  '                                                  '),
                 ('DATE                   TIME                   MODE',
                  'Ŀ',
                  ' TOP MENU WINDOW         ACTIVATED BY THE / KEY ',
                  '',
                  'ĿĿ',
                  ' LEFT WINDOW                   RIGHT WINDOW   ',
                  '                                              ',
                  '                                              ',
                  '                                              ',
                  '                                              ',
                  '                                              ',
                  '                                              ',
                  '                                              ',
                  '                                              ',
                  '                                              ',
                  '                                              ',
                  '                               PAGE           ',
                  ' HARD DISK MENU SELECTIONS     DESCRIPTIONS   ',
                  '',
                  'Ŀ',
                  ' BOTTOM EDIT WINDOW   USED BY /A /C /D /M /P /R ',
                  ''),
                 ('                INSTALLATION NOTES                ',
                  '                                                  ',
                  '1. There must be a path command to the DOS files. ',
                  '   If the DOS commands are in the root directory  ',
                  '   use this command in your AUTOEXEC.BAT file:    ',
                  '   "PATH C:\", if they are in a subdirectory named',
                  '   DOS use this: "PATH C:\DOS".                   ',
                  '                                                  ',
                  '2. Copy all the files from the HARD DISK MENU disk',
                  '   to the root directory of your hard disk or to  ',
                  '   a subdirectory.  If the files are put in the   ',
                  '   root directory, add this statement to the end  ',
                  '   of your AUTOEXEC.BAT file: "HDM".  If they were',
                  '   put in a subdirectory, add the following two   ',
                  '   lines to the AUTOEXEC.BAT file: "CD \SUBDIR"   ',
                  '   then: "HDM".  SUBDIR should be replaced by the ',
                  '   name of the subdirectory containing the files. ',
                  '                                                  ',
                  '            AUTOEXEC.BAT example:  PROMPT $p $g $a',
                  '                                   PATH C:\DOS    ',
                  '                                   CD \HDMDIR     ',
                  '(see HDM.DOC)                      HDM            '),
                 ('                                                  ',
                  '                 COPYRIGHT NOTICE                 ',
                  '                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                  HARD DISK MENU                  ',
                  '                                                  ',
                  '          (C) Copyright 1985 by Jim Hass          ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                                                  ',
                  '                   HDMHELP 1.15                   '));


var i, mn, color: byte;

procedure beep;
  begin {procedure BEEP}
    sound(6400); delay(02);
    sound(3200); delay(04);
    sound(1600); delay(06);
    sound(0800); delay(08);
    sound(0400); delay(10);
    sound(0200); delay(12);
    sound(0100); delay(14);
    sound(0050); delay(16);
    sound(0025); delay(18);
    nosound;
  end;  {procedure BEEP}

procedure show_main;
  begin {procedure SHOW_MAIN}
    box1(2,1,24,26,lightred);
    box1(2,27,24,54,lightred);
    for i := 1 to 20 do display(i+2,3,letter[i],lightmagenta);
    display(23,1,'Ĵ',lightred);
    display(24,3,'q',lightmagenta);
    display(24,5,'Quit',lightcyan);
  end;  {procedure SHOW_MAIN}

procedure show_menu;
  begin {SHOW_MENU}
    for i := 1 to 20 do display(i+2,5,menu[i],lightcyan);
    display(mn+2,5,menu[mn],reverse);
    if color = lightcyan then color := lightmagenta else color := lightcyan;
    for i := 1 to 22 do display(i+2,29,desc[mn,i],color);
  end;  {procedure SHOW_MENU}

procedure menu_up;
  begin {procedure MENU_UP}
    repeat {until menu is not blank}
      mn := mn - 1;
      if mn < 1 then mn := 20;
    until menu[mn] <> '';
  end;  {procedure MENU_UP}

procedure menu_down;
  begin {procedure MENU_DOWN}
    repeat {until menu is not blank}
      mn := mn + 1;
      if mn > 20 then mn := 1;
    until menu[mn] <> '';
  end;  {procedure MENU_DOWN}

procedure help;
  begin {procedure HELP}
    mn := mn + 100;  {skip show menu}
    if color = lightcyan then color := lightmagenta else color := lightcyan;
    display(19,39,' For God  so loved the world,  that he ',color);
    display(20,39,' gave  his  only  begotton  Son,  that ',color);
    display(21,39,' whosoever  believeth  in  him  should ',color);
    display(22,39,' not perish, but have everlasting life.',color);
    display(23,39,'                             John 3:16 ',color);
    box2(18,38,7,41,lightred);
  end;  {procedure HELP}

procedure quit;
  begin {procedure QUIT}
    display(24,5,'Quit',reverse);
    entry := #27;
    locate(24,24,1);
  end;  {procedure QUIT}

begin {program HDMHELP}
  clrscr;
  scrhdr('HDM II HELP');
  show_main;
  color := lightcyan;
  mn := 1;
  repeat {until entry = q or esc}
    if mn > 100 then mn := mn - 100 else show_menu;
    waitkey;
    if extkey then begin
      case entry of
        #59: help;      {F1}
        #71: mn := 1;   {Home}
        #72: menu_up;   {up arrow}
        #73: menu_up;   {PgUp}
        #79: mn := 20;  {End}
        #80: menu_down; {down arrow}
        #81: menu_down; {PgDn}
      else beep;
      end;  {case entry}
    end else begin
      case upcase(entry) of
        'A': mn := 1;
        'B': mn := 2;
        'C': mn := 3;
        'D': mn := 4;
        'E': mn := 5;
        'F': mn := 6;
        'G': mn := 7;
        'H': mn := 8;
        'J': mn := 9;
        'K': mn := 10;
        'M': mn := 11;
        'N': mn := 12;
        'P': mn := 13;
        'Q': quit;
        'R': mn := 14;
        'S': mn := 15;
        'T': mn := 16;
        'W': mn := 17;
        'X': mn := 18;
        'Y': mn := 19;
        'Z': mn := 20;
        #27: quit; {Esc}
      else beep;
      end;  {case upcase entry}
    end;  {if extkey}
  until entry = #27;
  clrscr;
end.  {program HDMHELP}

