{$R-}
unit supergen;
interface
uses Crt, Dos;
const
  NONDISPLAY   = $00;     { Monochrome display attribute }
  UNDERLINE    = $01;
  NORMAL       = $07;
  REVERSE      = $70;

  FG_BLACK     = $00;     { Color display attribute      }
  FG_BLUE      = $01;     { Foreground color (character) }
  FG_GREEN     = $02;
  FG_CYAN      = $03;
  FG_RED       = $04;
  FG_MAGENTA   = $05;
  FG_BROWN     = $06;
  FG_GRAY      = $07;

  BG_BLACK     = $00;     { Background color (screen)    }
  BG_BLUE      = $10;
  BG_GREEN     = $20;
  BG_CYAN      = $30;
  BG_RED       = $40;
  BG_MAGENTA   = $50;
  BG_BROWN     = $60;
  BG_GRAY      = $70;

  LIGHT_BLUE   = 24;      { Background color 2           }
  LIGHT_GREEN  = 40;
  LIGHT_RED    = 72;
  LIGHT_MAGEN  = 88;
  YELLOW       = 104;

  BLINK        = $80;     { Blink & Foreground intensity }
  INTENSITY    = $08;

  NULL         = #0;      { Character constant           }
  LINEFEED     = #10;
  FORMFEED     = #12;
  RETURN       = #13;
  BLANK        = #32;

  NOFORMAT     = '';      { Null string constant         }

  UP           = 6;       { Scroll direction constant    }
  DOWN         = 7;
  TAB          = 9;
  BS           = 8;       { Keyboard scan codes          }
  CR           = 13;
  ESC          = 27;
  HOMEKEY      = 327;
  ENDKEY       = 335;
  UPKEY        = 328;
  DOWNKEY      = 336;
  PGUPKEY      = 329;
  PGDNKEY      = 337;
  LEFTKEY      = 331;
  INSKEY       = 338;
  RIGHTKEY     = 333;
  DELKEY       = 339;
  CTRLLEFTKEY  = 371;
  CTRLRIGHTKEY = 372;
  CTRLPGUPKEY  = 388;
  CTRLPGDNKEY  = 374;
  CTRLHOMEKEY  = 375;
  CTRLENDKEY   = 373;
  F1           = 315;
  F2           = 316;
  F3           = 317;
  F4           = 318;
  F5           = 319;
  F6           = 320;
  F7           = 321;
  F8           = 322;
  F9           = 323;
  F10          = 324;
  CTRL_D       = 4;
  CTRL_E       = 5;
  CTRL_G       = 7;
  CTRL_H       = 8;
  CTRL_R       = 18;
  CTRL_S       = 19;
  CTRL_X       = 24;
  CTRL_Y       = 25;

type
  Str80           = String[80];
  Str50           = String[50];
  Str46           = String[46];
  str14           = string[14];
  Str8            = String[8];
  Str5            = String[5];
  Str2            = String[2];
  Buffer          = array [1..3] of string;
  FieldType       = (BYTES, SHORTINTS, INTEGERS, WORDS, LONGINTS, REALS, CHARS, STRINGS, BOOLEANS, ENGLISH, DATE, TIME);
  FieldStatus     = (ACCEPT, IGNORE);
  FullScreenParam = record
                      X, Y, Len, Dec : Word;
                      Types          : FieldType;
                      Status         : FieldStatus;
                      Format         : Str80
                    end;
  BoxMenuList     = record
                      Command : Str50;
                      Ch      : Char
                    end;
  LineMenuList    = record
                      X, Y    : Byte;
                      Command : Str50;
                      Ch      : Char
                    end;
type
  ScreenType = array [1..25, 1..80] of Word;
  ScreenParam = array [1..40] of FullScreenParam;
  ScreenPtr  = ^ScreenType;

var
  DisplayPtr, PagePtr : ScreenPtr;
  ColorCard       : Boolean;
  Confirm, Cancel : Word;
  NewLine         : Str2;
  mono_page      : array[1..4000] of char absolute $B000:$0000;
  color_page      : array[1..4000] of char absolute $B800:$0000;
  Memory_page      : array[1..4000] of char;x:integer;
  ScrFile             : File of ScreenType;
  VideoSeg, MaxPages  : Word;
  Insert, Thai        : Boolean;
  FuncAddr            : Pointer;

procedure MoveToScreen(var Source, Dest; Len : Word);
{ Moves memory to screen memory }

procedure MoveFromScreen(var Source, Dest; Len : Word);
{ Moves memory from screen memory }

procedure Beep(Tone, Time : Word);
{ Beep sounds the terminal bell or beeper }

procedure PutChar(X, Y, Color : Word; Ch : Char);
{ Put character to screen }

procedure PutStr(X, Y, Color : Word; var Message);
{ Put a string to screen }

procedure WrtTxt(X, Y, Color : Word; Txt : Str80);
{ Write text to screen }

procedure WrtColor(X, Y, Color, Len : Word);
{ Change color of text }

procedure ErrorMsg(Message : Str46);
{ Display message at bottom of screen }

procedure SavePic(X1, Y1, X2, Y2, Page : Word);
{ Save current window to specified page }

procedure LoadPic(X1, Y1, X2, Y2, Page : Word);
{ Load window of specified page to screen }

function Exist(FileName : Str80) : Boolean;
{ Check for existing of file }

procedure Scroll(Direction, X1, Y1, X2, Y2, Line, Color : Word);
{ Scroll a specified window }

procedure ClearScreen(Color : Word);
{ Clear screen to specified color }

procedure SaveTxt(FileName : Str80);
{ Save content of screen to textfile }

procedure ShowTxt(FileName : Str80; Color : Word);
{ Put textfile to screen }

procedure Showtxtln(fileName:str80; Color,Line :Word);
{ Put textfile to screen  with line control }

procedure SetCursor(Top, Bottom : Byte);
{ Set shape of cursor }

procedure CursorOn;
{ Display cursor }

procedure CursorOff;
{ Non-display cursor }

procedure SwapVar(var Var1, Var2; Size : Word);
{ Swap two variables of any type }

procedure Inspect(var S : String);
{ Delete leading space }

function BiosKey(Cmd : Word) : Word;
{ Keyboard interface }

function GetKey : Word;
{ Get the next key struck at the keyboard }

procedure ThreeLevel(var Data : Buffer);
{ Adjust level of thai string }

function Space(Len : Byte) : String;
{ Make spaces string }

procedure DrawBox(X1, Y1, X2, Y2 : Word; Title : Str80);
{ Create window and print title head }

function BoxMenu(X, Y, Width, Num, P : Word; var Menu; Title : Str50) : Word;
{ Menu Select type box }

function LineMenu(Num, P : Word; var Menu) : Word;
{ Menu Select type line }

function IsUpDownChar(Ch : Char) : Boolean;
{ Character classification function }

function IsMiddleChar(Ch : Char) : Boolean;
{ Character classification function }

function CountChar (Data : string) : Byte;
{ Count for consonant character }

procedure PackThai(var ThStr : String);
{ Pack Thai string to shortest form }

function ReadDate : Str8;
{ Read current date in format DD/MM/YY }

function ReadTime : Str5;
{ Read current time in format HH:MM }

function DateOk(Date : Str8) : Boolean;
{ Inspect valid date }

function TimeOk(Time : Str5) : Boolean;
{ Inspect valid time }

function GetField(X, Y, Color, Len : Word; Types : FieldType; Format : Str80; var Data : String) : Word;
{ Get value from keyboard to variable with specified type }

procedure ShowScreen(ScreenData : pointer);
{Instantly pop-up screen that has been linked with application}

procedure Save_scn(scname:str80);
{save screen with all color and attribute}

procedure Load_scn(scname:str80);
{load screen with all color and attribute}

procedure initdisplay;

implementation

const
  MaxLines   = 25;
  MaxFields  = 40;
  Numeric    : Set of FieldType = [BYTES, SHORTINTS, INTEGERS, WORDS, LONGINTS, REALS];
  Consonant  : Set of Char = [#$20..#$7F, #$A1..#$CB, #$D5, #$D6];
  FrontVowel : Set of Char = [#$D0..#$D4];
  BackVowel  : Set of Char = [#$CC..#$CF];
  UpVowel    : Set of Char = [#$D9..#$DF];
  DownVowel  : Set of Char = [#$D7, #$D8, #$E5];
  ToneMarks  : Set of Char = [#$E0..#$E4];
  MixVowel   : Set of Char = [#$E6..#$FE];
  Digit      : Set of Char = [#$30..#$39];
  IntDigit   : Set of Char = [#$30..#$39, #$2D];
  RealDigit  : Set of Char = [#$30..#$39, #$2D, #$2E];

procedure MoveToScreen; external;

procedure MoveFromScreen; external;

{$L MCMVSMEM.OBJ}

procedure InitDisplay;
var
  Reg : Registers;
begin
  Reg.AH := 15;
  Intr($10, Reg);
  ColorCard := Reg.AL <> 7;
  if ColorCard then
    VideoSeg := $B800
  else
    VideoSeg := $B000;
  DisplayPtr := Ptr(VideoSeg, 0);
end; { InitDisplay }


procedure Save_Scn(scname:str80);
  var scnfile:file;
  begin
    if (mem[0000:1040] and $30) = $30 then
      Begin
      MoveFromScreen(mono_page[1],memory_page[1],4000);
      assign(scnfile,scname);
      rewrite(scnfile,sizeof(memory_page[1]));
      blockwrite(scnfile,memory_page[1],4000);
      close(scnfile);
      end
      else
      begin
      MoveFromScreen(color_page[1],memory_page[1],4000);
      assign(scnfile,scname);
      rewrite(scnfile,sizeof(memory_page[1]));
      blockwrite(scnfile,memory_page[1],4000);
      close(scnfile);
      end;
  end;

procedure Load_scn(scname:str80);
  var scnfile:file;
  begin
    if (mem[0000:1040] and $30) = $30 then
       Begin
       Assign(scnfile,scname);
       reset(scnfile,sizeof(memory_page[1]));
       blockread(scnfile,memory_page[1],4000);
       close(scnfile);
       MoveToScreen(memory_page[1],mono_page[1],4000);
       end
       else
       begin
       Assign(scnfile,scname);
       reset(scnfile,sizeof(memory_page[1]));
       blockread(scnfile,memory_page[1],4000);
       close(scnfile);
       MoveToScreen(memory_page[1],color_page[1],4000);
       end;
  end;

procedure ShowScreen(ScreenData : pointer);
    var
      ScreenSegment : word;
    begin
      if (Lo(LastMode) = 7) then            { mono? }
        ScreenSegment := $B000
      else
        ScreenSegment := $B800;
      Move(ScreenData^,                     { from pointer }
           Ptr(ScreenSegment, 0)^,          { to video memory }
           4000);                           { 80 * 25 * 2 }
    end;

procedure Beep;
begin
  Sound(Tone);
  Delay(Time);
  NoSound
end; { Beep }

procedure Bell;
begin
  Beep(640, 250);
  Delay(50);
  Beep(640, 250)
end; { Bell }

procedure PutChar;
begin
  DisplayPtr^[Y, X] := Swap(Color) + Ord(Ch)
end; { PutChar }

procedure PutStr;
var
  Data : Array [0..80] of Byte Absolute Message;
  I    : Word;
begin
  Color := Color Shl 8;
  for I := 1 to Data[0] do
    DisplayPtr^[Y, Pred(X+I)] := Color + Data[I];
end; { PutStr }

procedure WrtTxt;
var
  I : Word;
begin
  Color := Color Shl 8;
  for I := 1 to Length(Txt) do
    DisplayPtr^[Y, Pred(X+I)] := Color + Ord(Txt[I]);
end; { WrtTxt }

procedure WrtColor;
var
  I : Word;
begin
  Color := Color Shl 8;
  for I := 1 to Len do
    DisplayPtr^[Y, Pred(X+I)] := Color + DisplayPtr^[Y, Pred(X+I)] and $00FF;
end; { WrtColor }

function AcceptKey : Word; forward;

procedure ErrorMsg;
var
  Key : Word;
begin
  CursorOff;
  Bell;
  WrtTxt(1, 25, REVERSE OR BLINK, 'ERROR:');
  WrtTxt(8, 25, NORMAL OR INTENSITY, Message);
  repeat
    Key := AcceptKey
  until Key = ESC;
  Scroll(UP, 1, 25, 55, 25, 0, NORMAL);
  CursorOn
end; { ErrorMsg }

procedure SavePic;
var
  Counter, Len : Word;
begin
  if Page < MaxPages then
  begin
    PagePtr := Ptr(VideoSeg, Page Shl 12);
    Len := Succ(X2 - X1) Shl 1;
    for Counter := 0 to Y2 - Y1 do
      MoveFromScreen(DisplayPtr^[Y1 + Counter, X1], PagePtr^[Y1 + Counter, X1], Len);
  end
  else
    ErrorMsg('Invalid page in call to SavePic procedure')
end; { SavePic }

procedure LoadPic;
var
  Counter, Len : Word;
begin
  if Page < MaxPages then
  begin
    PagePtr := Ptr(VideoSeg, Page Shl 12);
    Len := Succ(X2 - X1) Shl 1;
    for Counter := 0 to Y2 - Y1 do
      MoveToScreen(PagePtr^[Y1 + Counter, X1], DisplayPtr^[Y1 + Counter, X1], Len);
  end
  else
    ErrorMsg('Invalid page in call to LoadPic procedure')
end; { LoadPic }

function Exist;
var
  Fil : File;
begin
  Assign(Fil, FileName);
  {$I-} Reset(Fil); Close(Fil); {$I+}
  Exist := (IOresult = 0)
end; { Exist }

procedure Scroll;
var
  Regs : Registers;
begin
  if Direction in [UP, DOWN] then
  begin
    Regs.AX := Swap(Direction) + line;
    Regs.CX := Swap(Pred(Y1)) + Pred(X1);
    Regs.DX := Swap(Pred(Y2)) + Pred(X2);
    Regs.BH := Color;
    Intr($10, Regs)
  end
  else
    ErrorMsg('Invalid direction in call to Scroll procedure')
end; { Scroll }

procedure ClearScreen;
begin
  Scroll(UP, 1, 1, 80, 25, 0, Color)
end; { ClearScreen }

procedure SaveTxt;
var
  TxtFile   : Text;
  TxtLine   : Str80;
  Len, I, J : ShortInt;
begin
  Assign(TxtFile, FileName);
  Rewrite(TxtFile);
  for I := 1 to MaxLines do
  begin
    Len := 0;
    for J := 1 to 80 do
    begin
      TxtLine[J] := Char (Lo(DisplayPtr^[I, J]));
      if TxtLine[J] <> BLANK then
        Len := J
    end;
    TxtLine[0] := Char (Len);
    WriteLn(TxtFile, TxtLine)
  end;
  Close(TxtFile)
end; { SaveTxt }

procedure ShowTxt;
var
  TxtFile : Text;
  Txtln   : Str80;
  Count   : ShortInt;
begin
  if Exist(FileName) then
  begin
    Assign(TxtFile, FileName);
    Reset(TxtFile);
    Scroll(UP, 1, 1, 80, 25, 0, Color);
    Count := 1;
    while not EOF(TxtFile) and (Count <= 25) do
    begin
      ReadLn(TxtFile, TxtLn);
      WrtTxt(1, Count, Color, TxtLn);
      Inc(Count)
    end;
    Close(TxtFile);
  end
  else
    ErrorMsg('File not found in call to ShowTxt procedure')
end; { ShowTxt }

procedure ShowTxtLn;
var
  TxtFile : Text;
  Txtln   : Str80;
  Count   : ShortInt;
begin
  if Exist(FileName) then
  begin
    Assign(TxtFile, FileName);
    Reset(TxtFile);
    Scroll(UP, 1, 1, 80, Line, 0, Color);
    Count := 1;
    while not EOF(TxtFile) and (Count <= Line) do
    begin
      ReadLn(TxtFile, TxtLn);
      WrtTxt(1, Count, Color, TxtLn);
      Inc(Count)
    end;
    Close(TxtFile);
  end
  else
    ErrorMsg('File not found in call to ShowTxt procedure')
end; { ShowTxt }

procedure SetCursor;
var
  PortNo : Word;
begin
  PortNo := MemW[$0040 : $0063];
  Port[PortNo] := 10;
  Port[Succ(PortNo)] := Top;
  Port[PortNo] := 11;
  Port[Succ(PortNo)] := Bottom
end; { SetCursor }

procedure CursorOn;
begin
  SetCursor(12, 13)
end; { CursorOn }

procedure CursorOff;
begin
  SetCursor(32, 0)
end; { CursorOff }

procedure SwapVar;
type
  Bytes = array [0..MaxInt] of Byte;
var
  I    : Integer;
  Temp : Byte;
begin
  I := 0;
  while I < Size do
  begin
    Temp := Bytes (Var1) [I];
    Bytes (Var1) [I] := Bytes (Var2) [I];
    Bytes (Var2) [I] := Temp;
    Inc(I);
  end
end; { SwapVar }

procedure Inspect;
begin
  while Pos(BLANK, S) = 1 do
    Delete(S, 1, 1)
end; { Inspect }

function BiosKey;
var
  Regs : Registers;
begin
  if (cmd >= 0) and (cmd <= 2) then
  begin
    Regs.AH := Cmd;
    Intr($16, Regs);
    case Cmd of
      0 : BiosKey := Regs.AX;
      1 : BiosKey := Regs.Flags;
      2 : BiosKey := Regs.AL
    end
  end
  else
    ErrorMsg('Invalid parameter in call to BiosKey function')
end; { BiosKey }

function GetKey;
var
  Key : Word;
begin
  Key := BiosKey(0);
  if Lo(key) <> 0 then
    GetKey := Lo(Key)
  else
    GetKey := Hi(Key) + 256
end; { GetKey }

procedure ShiftStatus;
const
  ScrollLock    = $10;
  NumLock       = $20;
  CapsLock      = $40;
  InsToggle     = $80;
  Status : Word = $FFFF;
var
  Toggle : Word;
begin
  Toggle := BiosKey(2);
  if Status <> Toggle then
  begin
    if Toggle And CapsLock <> 0 then
      WrtTxt(56, 25, REVERSE, ' CAPS ')
    else
      WrtTxt(56, 25, NORMAL, '      ');
    if Toggle And NumLock <> 0 then
      WrtTxt(63, 25, REVERSE, ' NUM ')
    else
      WrtTxt(63, 25, NORMAL, '     ');
    Insert := (Toggle And InsToggle <> 0);
    if  Insert then
      WrtTxt(69, 25, REVERSE, ' INS ')
    else
      WrtTxt(69, 25, NORMAL, '     ');
    if Toggle And ScrollLock <> 0 then
      WrtTxt(75, 25, REVERSE, ' SCL ')
    else
      WrtTxt(75, 25, NORMAL, '     ');
    Status := Toggle
  end;
end; { ShiftStatus }

function AcceptKey;
var
  Key : Word;
begin
  repeat
    while Not KeyPressed do
      ShiftStatus;
    Key := GetKey
  until Key <> InsKey;
  AcceptKey := Key
end;

function ThaiChar(Ch : Char) : Char;
const
  ThaiKaset : array [#$20..#$7F] of Byte =
    ( $20, $23, $2E, $32, $33, $34, $EB, $A5, $36, $37, $35, $39, $BF,
      $A2, $D3, $BB, $A6, $C3, $2F, $2D, $BE, $B4, $D7, $DB, $A3, $B3,
      $A9, $C4, $B0, $A8, $C9, $CD, $31, $C2, $E5, $A7, $AD, $AC, $D2,
      $AA, $DF, $B1, $E3, $C6, $C5, $3F, $E4, $D6, $AB, $30, $AF, $A4,
      $B6, $E2, $CB, $22, $29, $DE, $28, $B8, $5C, $C3, $D8, $38, $60,
      $BD, $D9, $D1, $A1, $CF, $B2, $D0, $E1, $C1, $E0, $CE, $C7, $B5,
      $DC, $B7, $C0, $D5, $BC, $C8, $CC, $DA, $CA, $D4, $B9, $DD, $BA,
      $AE, $7C, $2C, $7E, $00 );
begin
  if Ch in [#$20..#$7f] then
    ThaiChar := Char (ThaiKaset[Ch])
  else
    ThaiChar := Ch
end; { ThaiChar }

function MixChar(Ch1, Ch2 : Char) : Char;
const
  MixVowelTab : array [#$D9..#$DF, #$E0..#$E4] of Byte =
    (  ( $EE, $EF, $F0, $F1, $F2 ),
       ( $F3, $F4, $F5, $F6, $00 ),
       ( $F7, $F8, $F9, $FA, $00 ),
       ( $FB, $FC, $FD, $FE, $00 ),
       ( $EA, $EB, $EC, $ED, $00 ),
       ( $E6, $E7, $E8, $E9, $00 ),
       ( $00, $00, $00, $00, $00 )  );
var
  C : Char;
begin
  case Ch1 of
    #$D9..#$DF : case Ch2 of
                   #$D9..#$DF : C := Ch2;
                   #$E0..#$E4 : C := Char (MixVowelTab[Ch1, Ch2])
                 end;
    #$E0..#$E4 : case Ch2 of
                   #$D9..#$DF : C := Char (MixVowelTab[Ch2, Ch1]);
                   #$E0..#$E4 : C := Ch2
                 end
  end;
  if C <> NULL then
    MixChar := C
  else
    MixChar := Ch2
end; { MixChar }

function ChangeMixChar(Ch1, Ch2 : Char) : Char;
const
  ChangeTable : array [0..4, #$D9..#$DE] of Byte =
    (  ( $EE, $F3, $F7, $FB, $EA, $E6 ),
       ( $EF, $F4, $F8, $FC, $EB, $E7 ),
       ( $F0, $F5, $F9, $FD, $EC, $E8 ),
       ( $F1, $F6, $FA, $FE, $ED, $E9 ),
       ( $F2, $DA, $DB, $DC, $DD, $DE )  );
var
  Indx : Byte;
begin
  case Ch2 of
    #$D9..#$DE : begin
                   if Ch1 = #$F2 then
                     Indx := 4
                   else if Ch1 < #$F2 then
                     Indx := (Byte(Ch1) - 230) mod 4
                   else
                     Indx := (Byte(Ch1) - 231) mod 4;
                   ChangeMixChar := Char(ChangeTable[Indx, Ch2])
                 end;
    #$DF       : ChangeMixChar := Ch2;
    #$E0..#$E3 : begin
                   if Ch1 < #$F2 then
                     Indx := (Byte(Ch1) - 230) mod 4
                   else
                     Indx := (Byte(Ch1) - 231) mod 4;
                   ChangeMixChar := Char(Byte(Ch1) - Indx + Byte(Ch2) - 224)
                 end;
    #$E4       : if Ch1 in [#$EE..#$F2] then
                   ChangeMixChar := #$F2
                 else
                   ChangeMixChar := #$E4
  end
end; { ChangeMixChar }

function DelMixChar(Ch : Char) : Char;
begin
  case Ch of
    #$E6..#$E9 : DelMixChar := #$DE;
    #$EA..#$ED : DelMixChar := #$DD;
    #$EE..#$F2 : DelMixChar := #$D9;
    #$F3..#$F6 : DelMixChar := #$DA;
    #$F7..#$FA : DelMixChar := #$DB;
    #$FB..#$FE : DelMixChar := #$DC
  end
end; { DelMixChar }

procedure ThreeLevel;
var
  I : Word;
begin
  FillChar(Data[1][1], Length(Data[2]), BLANK);
  FillChar(Data[3][1], Length(Data[2]), BLANK);
  I := 1;
  while I <= Ord(Data[2][0]) do
    case Data[2][I] of
      #$D9..#$DF,
      #$E0..#$E4,
      #$E6..#$FE  : if Data[2][I+1] in UpVowel + ToneMarks then
                    begin
                      if Data[2][I] in MixVowel then
                        Data[2][I] := ChangeMixChar(Data[2][I], Data[2][I+1])
                      else
                        Data[2][I] := MixChar(Data[2][I], Data[2][I+1]);
                      Delete(Data[2], I+1, 1);
                      Data[2][Length(Data[2]) + 1] := BLANK
                    end
                    else
                    begin
                      Data[1][I-1] := Data[2][I];
                      Delete(Data[2], I, 1)
                    end;
      #$D7, #$D8,
      #$E5        : begin
                      Data[3][I-1] := Data[2][I];
                      Delete(Data[2], I, 1)
                    end;
    else
      Inc(I)
    end;
  Data[1][0] := Data[2][0];
  Data[3][0] := Data[2][0]
end; { ThreeLevel }

function Space;
var
  Buff : Str80;
begin
  FillChar(Buff[1], Len, Blank);
  Buff[0] := Char (Len);
  Space := Buff
end; { Space }

procedure DrawBox;
var
  Row : Word;
begin
  Scroll(UP, X1, Y1, X2, Y2, 0, NORMAL);
  WrtTxt(X1, Y1, REVERSE, Space(X2 - Pred(X1)));
  for Row := Succ(Y1) to Pred(Y2) do
  begin
    PutChar(X1, Row, REVERSE, BLANK);
    PutChar(X2, Row, REVERSE, BLANK)
  end;
  WrtTxt(X1, Y2, REVERSE, Space(X2 - Pred(X1)));
  WrtTxt(X1 + (X2 - Pred(X1) - Length(Title)) div 2, Y1, REVERSE, Title)
end; { DrawBox }

function BoxMenu;
type
  MenuList = array [1..21] of BoxMenuList;
var
  Select, Key, I : Word;
  Exit           : Boolean;

procedure WriteMenu(X, Y, Color : Word; S : Str50);
begin
  WrtTxt(X, Y, Color, BLANK + S + Space(Width - Length(S)))
end;

begin
  CursorOff;
  DrawBox(X, Y, X + Pred(Width), Y + Num + 3, Title);
  Dec(Width, 3);
  for I := 1 to Num do
    if I <> P then
      WriteMenu(Succ(X), Succ(Y) + I, NORMAL OR INTENSITY, MenuList(Menu)[I].Command)
    else
      WriteMenu(Succ(X), Succ(Y) + I, REVERSE, MenuList(Menu)[I].Command);
  Select := P;
  Exit := False;
  while not Exit do
  begin
    Key := AcceptKey;
    case Key of
      CR,
      ESC     : Exit := True;
      UPKEY   : if Select > 1 then
                  Dec(Select)
                else
                  Select := Num;
      DOWNKEY : if Select < Num then
                  Inc(Select)
                else
                  Select := 1;
      HOMEKEY : Select := 1;
      ENDKEY  : Select := Num;
    else
      if Key < $FF then
      begin
        I := 1;
        while (I <= Num) and (UpCase(Chr(Key)) <> UpCase(MenuList(Menu)[I].Ch)) do
          Inc(I);
        if I <= Num then
        begin
          Select := I;
          Exit := True
        end
      end
    end;
    if P <> Select then
    begin
      WriteMenu(Succ(X), Succ(Y) + P, NORMAL OR INTENSITY, MenuList(Menu)[P].Command);
      WriteMenu(Succ(X), Succ(Y) + Select, REVERSE, MenuList(Menu)[Select].Command);
      P := Select
    end
  end;
  CursorOn;
  if Key <> ESC then
    BoxMenu := Select
  else
    BoxMenu := Key
end; { BoxMenu }

function LineMenu;
type
  MenuList = array [1..40] of LineMenuList;
var
  Select, Key, I : Word;
  Exit           : Boolean;
begin
  CursorOff;
  for I := 1 to Num do
    with MenuList(Menu)[I] do
      if I <> P then
      begin
        WrtTxt(X, Y, NORMAL, Command);
        PutChar(Pred(X) + Pos(UpCase(Ch), Command), Y, NORMAL OR INTENSITY, UpCase(Ch))
      end
      else
        WrtTxt(X, Y, REVERSE, Command);
  Select := P;
  Exit := False;
  while not Exit do
  begin
    Key := AcceptKey;
    case Key of
      CR,
      ESC      : Exit := True;
      UPKEY,LEFTKEY  : if Select > 1 then
                   Dec(Select)
                 else
                   Select := Num;
 DOWNKEY,32,RIGHTKEY : if Select < Num then
                   Inc(Select)
                 else
                   Select := 1;
      HOMEKEY  : Select := 1;
      ENDKEY   : Select := Num;
    else
      if Key < $FF then
      begin
        I := 1;
        while (I <= Num) and (UpCase(Chr(Key)) <> UpCase(MenuList(Menu)[I].Ch)) do
          Inc(I);
        if I <= Num then
        begin
          Select := I;
          Exit := True
        end
      end
    end;
    if P <> Select then
    begin
      with MenuList(Menu)[P] do
      begin
        WrtTxt(X, Y, NORMAL, Command);
        PutChar(Pred(X) + Pos(UpCase(Ch), Command), Y, NORMAL OR INTENSITY, UpCase(Ch))
      end;
      with MenuList(Menu)[Select] do
        WrtTxt(X, Y, REVERSE, Command);
      P := Select
    end
  end;
  CursorOn;
  if Key <> ESC then
    LineMenu := Select
  else
    LineMenu := Key
end; { LineMenu }

function IsUpDownChar;
begin
  IsUpDownChar := Ch in UpVowel + DownVowel + ToneMarks + MixVowel
end; { IsUpDownChar }

function IsMiddleChar;
begin
  IsMiddleChar := not IsUpDownChar(Ch)
end; { IsMiddleChar }

function CountChar;
var
  Count, I : Byte;
begin
  Count := Length(Data);
  for I := 1 to Count do
    if IsUpDownChar(Data[I]) then
      Dec(Count);
  CountChar := Count
end; { CountChar }

procedure PackThai;
var
  Index : Word;
begin
  Index := 1;
  while Index <= Length(ThStr) do
    case ThStr[Index] of
      #$D0..#$D4 : if ThStr[Pred(Index)] in FrontVowel then
                     Delete(ThStr, Pred(Index), 1)
                   else
                     Inc(Index);
      #$CC..#$CF : if (ThStr[Pred(Index)] in BackVowel) and not
                      ((ThStr[Index]=#$CC) and (ThStr[Pred(Index)]=#$CE)) then
                     Delete(ThStr, Pred(Index), 1)
                   else
                     Inc(Index);
      #$D7, #$D8,
      #$E5       : if IsUpDownChar(ThStr[Pred(Index)]) then
                     if (ThStr[Pred(Index)] in DownVowel) then
                       Delete(ThStr, Pred(Index), 1)
                     else
                       SwapVar(ThStr[Pred(Index)], ThStr[Index], 1)
                   else
                     Inc(Index);
      #$D9..#$DF,
      #$E0..#$E4,
      #$E6..#$FE : if ThStr[Pred(Index)] in UpVowel + ToneMarks + MixVowel then
                   begin
                     if (ThStr[Pred(Index)] in UpVowel + ToneMarks) and
                        (ThStr[Index] in UpVowel + ToneMarks) then
                       ThStr[Pred(Index)] := MixChar(ThStr[Pred(Index)], ThStr[Index])
                     else
                     if (ThStr[Pred(Index)] in MixVowel) and
                        (ThStr[Index] in UpVowel + ToneMarks) then
                       ThStr[Pred(Index)] := ChangeMixChar(ThStr[Pred(Index)], ThStr[Index])
                     else
                       ThStr[Pred(Index)] := ThStr[Index];
                     Delete(Thstr, Index, 1)
                   end
                   else
                     Inc(Index);
    else
      Inc(Index)
    end
end; { PackThai }

function ReadDate;
var
  Year, Month, Day, DayOfWeek : Word;
  DD, MM, YY                  : Str2;
  Date                        : Str8;
begin
  GetDate(Year, Month, Day, DayOfWeek);
  Str(Year - 1900 : 2, YY);
  Str(Month : 2, MM);
  Str(Day : 2, DD);
  Date := DD + '/' + MM + '/' + YY;
  while Pos(BLANK, Date) > 0 do
    Date[Pos(BLANK, Date)] := '0';
  ReadDate := Date
end; { ReadDate }

function ReadTime;
var
  Hour, Minute, Second, Sec100 : Word;
  HH, MM                       : Str2;
  Time                         : Str5;
begin
  GetTime(Hour, Minute, Second, Sec100);
  Str(Hour : 2, HH);
  Str(Minute : 2, MM);
  Time := HH + ':' + MM;
  while Pos(BLANK, Time) > 0 do
    Time[Pos(BLANK, Time)] := '0';
  ReadTime := Time
end; { ReadTime }

function DateOk;
const
  DayTable : array [Boolean, 1..12] of Byte =
    (  ( 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ),
       ( 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 )  );
var
  Year, Month, Day, Code : Word;
  Leap                   : Boolean;
begin
  Val(Copy(Date, 1, 2), Day, Code);
  Val(Copy(Date, 4, 2), Month, Code);
  Val(Copy(Date, 7, 2), Year, Code);
  Inc(Year, 1900);
  Leap := (Year mod 4 = 0) and (Year mod 100 <> 0) or (Year mod 400 = 0);
  if (Month in [1..12]) and (Day <= DayTable[Leap, Month]) then
    DateOk := True
  else
    DateOk := False
end; { DateOk }

function TimeOk;
var
  Hour, Minute, Code : Word;
begin
  Val(Copy(Time, 1, 2), Hour, Code);
  Val(Copy(Time, 4, 2), Minute, Code);
  if (Hour in [0..23]) and (Minute in [0..59]) then
    TimeOk := True
  else
    TimeOk := False
end; { TimeOk }

function GetField;
const
  FormatSet : Set of Char = ['9', 'A', 'a', 'T', 't', 'X', 'x'];
  Terminate : Word = CR;
var
  Exit, FormatCheck, Error : Boolean;
  ValidChar, ValidForm     : Set of Char;
  Key, Indx, Col, I        : Word;
  Buff                     : String;
  Temp                     : Str80;
  Ch                       : Char;

  function StringOverwrite(Ch : Char; var S : String; Index : Byte) : Char;
  var
    Len : Byte;
  begin
    Len := Length(S) + 1;
    if Index >= Len then
    begin
      FillChar(S[Len], Index - Len, Blank);
      S[0] := Char (Index)
    end;
    S[Index] := Ch;
    StringOverwrite := Ch
  end;

  function StringInsert(Ch : Char; var S : String; Index : Byte) : String;
  var
    Width : Byte;
  begin
    Width := Length(S) + 1;
    if Index < Width then
    begin
      Move(S[Index], S[Index + 1], Width - Index);
      if Width < Len then
        S[0] := Char (Width)
      else
        S[0] := Char (Len)
    end
    else
    begin
      FillChar(S[Width], Index - Width, Blank);
      S[0] := Char (Index)
    end;
    S[Index] := Ch;
    StringInsert := Copy(S, Index, 255)
  end;

  function StringBackSpace(var S : String; Index : Byte) : String;
  var
    Len : Byte;
  begin
    Len := Length(S) + 1;
    if Index <= Len then
    begin
      Move(S[Index], S[Pred(Index)], Len - Index);
      Dec(Len, 2);
      while S[Len] = Blank do
        Dec(Len);
      S[0] := Char (Len)
    end;
    StringBackSpace := Copy(S, Pred(Index), 255) + BLANK
  end;

  function StringDelete(var S : String; Index : Byte) : String;
  var
    Len, Pos : Byte;
  begin
    Len := Length(S) + 1;
    if Index < Len then
    begin
      Pos := Index + 1;
      while (Pos < Len) and IsUpDownChar(S[Pos]) do
        Inc(Pos);
      Move(S[Pos], S[Index], Len - Pos);
      Len := Len - (Pos - Index + 1);
      while S[Len] = Blank do
        Dec(Len);
      S[0] := Char (Len)
    end;
    StringDelete := Copy(S, Index, 255) + BLANK
  end;

  procedure UpdateIndex;
  begin
    while not (Format[Indx] in FormatSet) do
      case Key of
        LEFTKEY,
        CTRL_S,
        ENDKEY  : begin
                    Dec(Indx);
                    Dec(Col)
                  end;
      else
        Inc(Indx);
        Inc(Col)
      end;
  end;

begin { GetField }
  SetCursor(1, 11);
  case Types of
    BYTES,
    SHORTINTS,
    INTEGERS,
    WORDS,
    LONGINTS  : ValidChar := IntDigit;
    REALS     : ValidChar := RealDigit;
    CHARS,
    STRINGS   : begin
                  ValidChar := [#$20..#$7F, #$A1..#$FE];
                  Temp := '';
                  if Types = CHARS then
                  begin
                    Len := 1;
                    Data[0] := Char (Len)
                  end
                end;
    BOOLEANS,
    ENGLISH   : ValidChar := [#$20..#$7F];
    DATE,
    TIME      : begin
                  ValidChar := Digit;
                  if Types = DATE then
                    Format := '99/99/99'
                  else
                    Format := '99:99'
                end
  end;
  if not (Types in [STRINGS, BOOLEANS, ENGLISH, DATE, TIME]) then
    Format := NOFORMAT;
  FormatCheck := Format <> NOFORMAT;
  if FormatCheck then
  begin
    Len := Length(Format);
    for Indx := 1 to Len do
      if not (Format[Indx] in FormatSet) then
        Data[Indx] := Format[Indx];
    Data[0] := Char (Len)
  end;
  if FormatCheck or (Types <> STRINGS) then
    WrtTxt(X, Y, Color, Data + Space(Len - length(Data)))
  else
  begin
    PackThai(Data);
    Wrttxt(X, Y, Color, Data + Space(Len - CountChar(Data)))
  end;
  if (Terminate = LEFTKEY) or (Terminate = CTRL_S) then
  begin
    Indx := Len;
    if FormatCheck then
      Col := X + Pred(Len)
    else
    begin
      Col  := X + Len - (Length(Data) - CountChar(Data) + 1);
      if Length(Data) = Len then
        while IsUpDownChar(Data[Indx]) do
          Dec(Indx)
    end
  end
  else
  begin
    Indx := 1;
    Col  := X
  end;
  if FormatCheck then
    UpdateIndex;
  Buff := Data;
  repeat
    Exit := False;
    while not Exit and (Indx in [1..Len]) do
    begin
      GotoXY(Col, Y);
      Key := AcceptKey;
      case Key of
        TAB,CR,
        ESC,
        UPKEY,
        CTRLLEFTKEY,
        CTRL_E,
        DOWNKEY,
        CTRLRIGHTKEY,
        CTRL_X,
        CTRLHOMEKEY,
        CTRLENDKEY,
        F1..F10      : Exit := True;    (*ITS HERE*)
        RIGHTKEY,
        CTRL_D       : begin
                         Inc(Indx);
                         Inc(Col);
                         while not FormatCheck and (Indx <= Length(Buff)) and IsUpDownChar(Buff[Indx]) do
                           Inc(Indx)
                       end;
        LEFTKEY,
        CTRL_S       : begin
                         Dec(Indx);
                         Dec(Col);
                         while not FormatCheck and (Indx <= Length(Buff)) and IsUpDownChar(Buff[Indx]) do
                           Dec(Indx)
                       end;
        HOMEKEY      : begin
                         Indx := 1;
                         Col  := X
                       end;
        ENDKEY       : begin
                         Indx := Length(Buff) + 1;
                         if FormatCheck then
                           Col := X + Pred(Indx)
                         else
                           Col  := X + CountChar(Buff);
                         if Indx > Len then
                         begin
                           Dec(Indx);
                           while IsUpDownChar(Buff[Indx]) do
                             Dec(Indx);
                           Dec(Col)
                         end
                       end;
        BS,
        CTRL_H       : if not FormatCheck and (Indx > 1) then
                         if IsUpDownChar(Buff[Pred(Indx)]) then
                           if Buff[Pred(Indx)] in MixVowel then
                           begin
                             Buff[Pred(Indx)] := DelMixChar(Buff[Pred(Indx)]);
                             PutChar(Pred(Col), Pred(Y), Color, Buff[Pred(Indx)])
                           end
                           else
                           begin
                             Dec(Indx);
                             if Buff[Indx] in DownVowel then
                               PutChar(Pred(Col), Succ(Y), Color, Blank)
                             else
                               PutChar(Pred(Col), Pred(Y), Color, Blank);
                             Delete(Buff, Indx, 1)
                           end
                         else
                         begin
                           Dec(Col);
                           if Types = STRINGS then
                             Wrttxt(Col, Y, Color, StringBackSpace(Buff, Indx))
                           else
                             WrtTxt(Col, Y, Color, StringBackSpace(Buff, Indx));
                           Dec(Indx)
                         end
                       else
                         Beep(1000, 300);
        DELKEY,
        CTRL_G       : if not FormatCheck then
                         if Types = STRINGS then
                           Wrttxt(Col, Y, Color, StringDelete(Buff, Indx))
                         else
                           WrtTxt(Col, Y, Color, StringDelete(Buff, Indx))
                       else
                         Beep(1000, 300);
        F2,
        CTRL_R       : begin
                         Buff := Data;
                         if FormatCheck or (Types <> STRINGS) then
                           WrtTxt(X, Y, Color, Buff + Space(Len - Length(Buff)))
                         else
                         begin
                           Wrttxt(X, Y, Color, Buff + Space(Len - CountChar(Buff)));
                           Indx := 1;
                           Col  := X
                         end
                       end;
        F3,
        CTRL_Y       : if FormatCheck then
                       begin
                         for I := 1 to Len do
                           if Format[I] in FormatSet then
                             Buff[I] := BLANK;
                         WrtTxt(X, Y, Color, Buff)
                       end
                       else
                       begin
                         if Types <> STRINGS then
                           WrtTxt(X, Y, Color, Space(Length(Buff)))
                         else
                           Wrttxt(X, Y, Color, Space(CountChar(Buff)));
                         Buff := NOFORMAT;
                         Indx := 1;
                         Col  := X
                       end;
        $20..$FF     : begin
                         if Thai then
                           Ch := ThaiChar(Char (Key))
                         else
                           Ch := Char (Key);
                         if Ch in ValidChar then
                           case Types of
                             BYTES,
                             SHORTINTS,
                             INTEGERS,
                             WORDS,
                             LONGINTS,
                             REALS    : if ((Ch in Digit) and (not Insert or (Indx <> 1) or (Buff[1] <> '-'))) or
                                           ((Ch = '-') and (Indx = 1) and (not Insert or (Buff[1] <> '-'))) or
                                           ((Ch = '.') and ((Indx <> 1) or not Insert or (Buff[1] <> '-'))) then
                                          if Indx <= Length(Buff) + 1 then
                                          begin
                                            if (Ch <> '.') or (Pos('.', Buff) = 0) then
                                              if Insert then
                                                WrtTxt(Col, Y, Color, StringInsert(Ch, Buff, Indx))
                                              else
                                                PutChar(Col, Y, Color, StringOverwrite(Ch, Buff, Indx))
                                            else
                                            begin
                                              Delete(Buff, Indx, Pos('.', Buff) - Indx);
                                              WrtTxt(X, Y, Color, Buff + Space(Len - Length(Buff)))
                                            end;
                                            Inc(Indx);
                                            Inc(Col)
                                          end
                                          else
                                            Beep(1000, 300)
                                        else
                                          Beep(1000, 300);
                             CHARS    : begin
                                          PutChar(X, Y, Color, Ch);
                                          Buff[Indx] := Ch;
                                          Inc(Indx)
                                        end;
                             STRINGS,
                             BOOLEANS,
                             ENGLISH,
                             DATE,
                             TIME     : if FormatCheck then
                                        begin
                                          case Format[Indx] of
                                            '9'      : ValidForm := Digit;
                                            'A', 'a' : ValidForm := ['A'..'Z', 'a'..'z'];
                                            'T', 't' : ValidForm := [#$A1..#$FE];
                                            'X', 'x' : ValidForm := [#$20..#$7F];
                                          end;
                                          if Ch in ValidForm then
                                          begin
                                            PutChar(Col, Y, Color, StringOverwrite(Ch, Buff, Indx));
                                            Inc(Indx);
                                            Inc(Col)
                                          end
                                          else
                                            Beep(1000, 300)
                                        end
                                        else
                                          if IsMiddleChar(Ch) then
                                          begin
                                            Error := False;
                                            case Ch of
                                              #$D0..#$D4 : if Buff[Pred(Indx)] in FrontVowel then
                                                             Error := True;
                                              #$CC..#$CF : if ((Buff[Pred(Indx)] in BackVowel) and not
                                                              ((Buff[Pred(Indx)] = #$CE) and (Ch = #$CC))) or
                                                              (Buff[Pred(Indx)] in
                                                               [#$20..#$7F, #$D5, #$D6] + FrontVowel) then
                                                             Error := True;
                                            end;
                                            if not Error then
                                            begin
                                              if Insert then
                                                if (Types = ENGLISH) or (Types = BOOLEANS) then
                                                  WrtTxt(Col, Y, Color, StringInsert(Ch, Buff, Indx))
                                                else
                                                  Wrttxt(Col, Y, Color, StringInsert(Ch, Buff, Indx))
                                              else
                                                PutChar(Col, Y, Color, StringOverwrite(Ch, Buff, Indx));
                                              Inc(Indx);
                                              while (Indx <= Length(Buff)) and IsUpDownChar(Buff[Indx]) do
                                                Inc(Indx);
                                              Inc(Col)
                                            end
                                            else
                                              Beep(1000, 300)
                                          end
                                          else
                                            if (Indx > 1) and not (Buff[Pred(Indx)] in
                                                [#$20..#$7F, #$D5, #$D6] + FrontVowel + BackVowel) then
                                            begin
                                              if Ch in DownVowel then
                                              begin
                                                PutChar(Pred(Col), Succ(Y), Color, Ch);
                                                if Buff[Pred(Indx)] in DownVowel then
                                                  Buff[Pred(Indx)] := Ch
                                                else
                                                  if IsUpDownChar(Buff[Pred(Indx)]) and
                                                     (Buff[Indx - 2] in DownVowel) then
                                                    Buff[Indx - 2] := Ch
                                                  else
                                                  begin
                                                    if IsMiddleChar(Buff[Pred(Indx)]) then
                                                      Temp := StringInsert(Ch, Buff, Indx)
                                                    else
                                                      Temp := StringInsert(Ch, Buff, Pred(Indx));
                                                    Inc(Indx)
                                                  end
                                              end
                                              else
                                                if Buff[Pred(Indx)] in UpVowel + ToneMarks + MixVowel then
                                                begin
                                                  if Ch in UpVowel + ToneMarks then
                                                    if Buff[Pred(Indx)] in UpVowel + ToneMarks then
                                                      Buff[Pred(Indx)] := MixChar(Buff[Pred(Indx)], Ch)
                                                    else
                                                      Buff[Pred(Indx)] := ChangeMixChar(Buff[Pred(Indx)], Ch)
                                                  else
                                                    Buff[Pred(Indx)] := Ch;
                                                  PutChar(Pred(Col), Pred(Y), Color, Buff[Pred(Indx)])
                                                end
                                                else
                                                begin
                                                  PutChar(Pred(Col), Pred(Y), Color, Ch);
                                                  Temp := StringInsert(Ch, Buff, Indx);
                                                  Inc(Indx)
                                                end;
                                              if (Ord(Buff[0]) = Len) and (Temp <> '') then
                                              begin
                                                Wrttxt(Col, Y, Color, Temp + BLANK);
                                                Temp := ''
                                              end
                                            end
                                            else
                                              Beep(1000, 300);
                           end
                         else
                           Beep(1000, 300);
                       end;
      else
        Beep(1000, 300)
      end;
      if FormatCheck then
        UpdateIndex;
    end;
    case Types of
      DATE : begin
               Error := not DateOk(Buff);
               if Error then
                 ErrorMsg('Invalid date')
             end;
      TIME : begin
               Error := not TimeOk(Buff);
               if Error then
                 ErrorMsg('Invalid time')
             end;
    else
      Error := False
    end;
    Indx := 1;
    Col  := X
  until not Error;
  if Types in Numeric then
    WrtTxt(X, Y, Color, Space(Len - Length(Buff)) + Buff);
  Data := Buff;
  Terminate := Key;
  CursorOn;
  GetField := Terminate
end; { GetField }

begin
  thai := false;
  InitDisplay;
  if ColorCard then
    MaxPages := 4
  else
    MaxPages := 7;
  Confirm := F10;
  Cancel  := ESC;
  NewLine := RETURN + LINEFEED;
end. { TSLTOOLS Unit }
