                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Member name list routines to support TPARCV.PAS.  Author: Michael Quinlan.
Version 1.01.  Turbo Pascal 4.0.

* ASSOCIATED FILES
TPARCV.PAS
TPARC.DOC
TPARCCIO.INC
TPARCDAT.INC
TPARCGFN.INC
TPARCINI.INC
TPARCIO.INC
TPARCLST.INC
TPARCSVC.INC

* KEYWORDS
TURBO PASCAL 4.0 PROGRAM ARC COMPRESS FILE LIBRARY UTILITY

==========================================================================
}

{======================================================================}
{                                                                      }
{  Turbo Pascal ARC Utility                                            }
{                                                                      }
{  A group project by the Borland SIG.                                 }
{                                                                      }
{======================================================================}

{======================================================================}
{                                                                      }
{  TPARCLST - List all member names in an archive.                     }
{  From ARCLST.C.                                                      }
{                                                                      }
{  Initial version 9/28/85 by Michael Quinlan                          }
{                                                                      }
{  Version 1.01 - changed calls to FSEEK to support larger files.      }
{                                                                      }
{======================================================================}

procedure lstfile(var hdr : heads);
  var yr, mo, dy : integer;
      hh, mm, ss : integer;
      i          : integer;
      fn         : strtype;
      rlen, rsiz : real;
      aorp       : char;
  const mon : array [1..12] of string[3] =
    ( 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
      'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec' );

  procedure twodig(n : integer);
    var s : string[2];
    begin
      str(n:2, s);
      if s[1] = ' ' then s[1] := '0';
      if s[2] = ' ' then s[2] := '0';
      write(s)
    end;

  procedure fourhex(n : integer);
    var h : integer;
        i : integer;
    const hexdigit : array [0..15] of char = '0123456789ABCDEF';
    begin
      for i := 1 to 4 do begin
        h := (n shr 12) and $000F;
        write(hexdigit[h]);
        n := n shl 4
      end
    end;

  begin
    fn := fn_to_str(hdr.name);
    rlen := long_to_real(hdr.length);
    rsiz := long_to_real(hdr.size);

    yr := (hdr.date shr 9) and $7F;
    mo := (hdr.date shr 5) and $0F;
    dy := hdr.date and $1F;

    hh := (hdr.time shr 11) and $1F;
    if hh > 12 then begin
      hh := hh - 12;
      aorp := 'p'
    end else
      aorp := 'a';
    mm := (hdr.time shr 5) and $3F;
    ss := (hdr.time and $1F) * 2;

    write(fn);
    for i := length(fn) to 13 do write(' ');
    write(rlen:8:0, '  ');

    if bose then begin
      case hdrver of
        1, 2 : write('   --   ');
        3    : write(' Packed ');
        4    : write('Squeezed');
        5    : write('crunched');
        6    : write('Crunched')
      else
        write('Unknown!')
      end;
      write('  ', 100 - Trunc(100.0 * rsiz / rlen):3, '%  ');
      write(rsiz:8:0, '  ')
    end;

    write(dy:2, ' ', mon[mo]:3, ' ');
    twodig((yr + 80) mod 100);

    if bose then begin
      write('  ', hh:2, ':');
      twodig(mm);
      write(aorp, '  ');
      fourhex(hdr.crc)
    end;

    writeln
  end;

procedure lstarc;
  var hdr : heads;
  begin
    write('Name          Length  ');
    if bose then write('  Storage    SF   Size now');
    write('  Date     ');
    if bose then write('  Time    CRC');
    writeln;

    write('============  ========');
    if bose then write('  ========  ====  ========');
    write('  =========');
    if bose then write('  ======  ====');
    writeln;

    openarc(FALSE);
    while readhdr(hdr, arc) do begin
      lstfile(hdr);
      fseek(arc, long_to_real(hdr.size), 1)
    end;
    closearc(FALSE)
  end;

