                       F i l e    I n f o r m a t i o n

* DESCRIPTION
C Language I/O simulation routines for TPARCV.PAS.  Author: Michael
Quinlan.  Version 1.01.  Turbo Pascal 4.0.

* ASSOCIATED FILES
TPARCV.PAS
TPARC.DOC
TPARCCIO.INC
TPARCDAT.INC
TPARCGFN.INC
TPARCINI.INC
TPARCIO.INC
TPARCLST.INC
TPARCSVC.INC

* KEYWORDS
TURBO PASCAL 4.0 PROGRAM ARC COMPRESS FILE LIBRARY UTILITY

==========================================================================
}

{======================================================================}
{                                                                      }
{  Turbo Pascal ARC Utility                                            }
{                                                                      }
{  A group project by the Borland SIG.                                 }
{                                                                      }
{======================================================================}

{======================================================================}
{                                                                      }
{  TPARCCIO - Simulate C I/O and other functions in Turbo Pascal.      }
{  Based on the CI-C86 runtime library.                                }
{  Uses BlockRead and BlockWrite for I/O.                              }
{                                                                      }
{  Initial version 9/28/85 by Michael Quinlan                          }
{                                                                      }
{  Version 1.01 9/29/85. Support archive files up to 8 Meg in size.    }
{                                                                      }
{======================================================================}

procedure abort(s : strtype);
  begin
    writeln('ABORT: ', s);
    halt(1)
  end;

function fn_to_str(var fn : fntype) : strtype;
{ convert strings from C format (trailing 0) to Turbo Pascal format (leading
    length byte). }
  var s : strtype;
      i : integer;
  begin
    s := '';
    i := 0;
    while fn[i] <> #0 do begin
      s := s + fn[i];
      i := i + 1
    end;
    fn_to_str := s
  end;

function unsigned_to_real(u : word) : real;
{ convert unsigned integer to real }
{ note: INT is a function that returns a REAL!!!}
  begin
    {----------
    if u >= 0 then unsigned_to_real := Int(u)
    else if u = $8000 then unsigned_to_real := 32768.0
    else unsigned_to_real := 65536.0 + u
    ---------- modified for 4.0 compatibility: - DSMB }
    unsigned_to_real := Int(u);
  end;

function long_to_real(l : long) : real;
{ convert long integer to a real }
{ note: INT is a function that returns a REAL!!! }
  var r : real;
      s : (POS, NEG);
  const rcon = 65536.0;
  begin
    {----------
    if l.h >= 0 then begin
      r := Int(l.h) * rcon;
      s := POS
    end else begin
      s := NEG;
      if l.h = $8000 then r := rcon * rcon
      else r := Int(-l.h) * rcon
    end;
    r := r + unsigned_to_real(l.l);
    if s = NEG then long_to_real := -r
    else long_to_real := r
    ---------- rewriten for 4.0 compabitility: - DSMB }
    long_to_real := Int(l.h) * rcon + Int(l.l);
  end;

procedure file_init;
  var i : integer;
  begin
    for i := 1 to NUMFILES do FFs[i].inuse := FALSE
  end;

procedure Read_Block(f : cfile);
  begin
    with FFs[f] do begin
      if EOF(fil) then endfile := TRUE
      else BlockRead(fil, buf, 1);
      next := 1
    end
  end;

procedure Write_Block(f : cfile);
  begin
    with FFs[f] do begin
      BlockWrite(fil, buf, 1);
      next := 1
    end
  end;

function fopen(var f : cfile; name : strtype; opentype : strtype) : boolean;
{ only binary I/O supported; only the first letter of opentype is examined }
{ Append mode is not supported. }
  begin
    f := 1;
    while FFs[f].inuse do
      if f = NUMFILES then abort('Too many files open at once.')
      else f := f + 1;
    with FFs[f] do begin
      {$I-} assign(fil, name); {$I+}
      if ioresult <> 0 then begin
        fopen := FALSE;
        exit
      end;

      case UpCase(opentype[1]) of
        'R' : begin
                {$I-} reset(fil); {$I+}
                if ioresult <> 0 then begin
                  fopen := FALSE;
                  exit
                end;
                endfile  := FALSE;
                rw := 'R';
                Read_Block(f)
              end;
        'W' : begin
                {$I-} rewrite(fil); {$I+}
                if ioresult <> 0 then begin
                  fopen := FALSE;
                  exit
                end;
                next := 1;
                rw := 'W';
                lastout := chr(0)
              end
      else
        abort('Invalid parameters for fopen')
      end;
      inuse := TRUE
    end;
    fopen := TRUE
  end;

function fgetc(f : cfile) : char;
  begin
    with FFs[f] do begin
      if endfile then fgetc := chr(0)
      else begin
        fgetc := buf[next];
        if next = BLOCKSIZE then Read_Block(f)
        else next := next + 1
      end
    end
  end;

function fgetb(f : cfile) : byte;
  begin
    with FFs[f] do begin
      if endfile then fgetb := 0
      else begin
        fgetb := ord(buf[next]);
        if next = BLOCKSIZE then Read_Block(f)
        else next := next + 1
      end
    end
  end;

procedure fputc(c : char; f : cfile);
  begin
    with FFs[f] do begin
      buf[next] := c;
      if next = BLOCKSIZE then Write_Block(f)
      else next := next + 1;
      lastout := c
    end
  end;

procedure fputb(b : byte; f : cfile);
  begin
    with FFs[f] do begin
      buf[next] := Chr(b);
      if next = BLOCKSIZE then Write_Block(f)
      else next := next + 1;
      lastout := Chr(b)
    end
  end;

function feof(f : cfile) : boolean;
  begin
    feof := FFs[f].endfile
  end;

procedure fclose(f : cfile);
  begin
    with FFs[f] do begin
      if (rw = 'W') and (lastout <> ^Z) then fputc(^Z, f);
      if next <> 1 then Write_Block(f);
      close(fil);
      inuse := FALSE
    end
  end;

procedure do_seek(f : cfile; offset : real);
  var i, ofs, rec : integer;
      c           : char;
  begin
    rec := Trunc(Offset / BLOCKSIZE);
    ofs := Trunc(Offset - (Int(rec) * BLOCKSIZE));  { Int converts to Real }
    seek(FFs[f].fil, rec);
    Read_Block(f);
    for i := 1 to ofs do c := fgetc(f)
  end;

procedure fseek(f : cfile; offset : real; base : integer);
{ only works with input files }
  var b : real;
  begin
    with FFs[f] do begin
      case base of
        0 : b := 0.0;
        1 : b := (unsigned_to_real(FilePos(fil)) - 1.0) * BLOCKSIZE + next - 1.0;
        2 : b := unsigned_to_real(FileSize(fil)) * BLOCKSIZE - 1.0
      else
        abort('Invalid parameters to fseek')
      end;
      do_seek(f, b + offset)
    end
  end;

procedure fread(var buf; reclen, numrec : integer; f : cfile);
  var i, n : integer;
      b : array [1..MaxInt] of char absolute buf;
  begin
    n := reclen * numrec;
    for i := 1 to n do b[i] := fgetc(f)
  end;

