                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Program to display a directory of files on an MSDOS disk, including options
to selectively display attributes.  Author: Jim McCarthy.  Version 2.00A.
Turbo Pascal 4.0.

* KEYWORDS
TURBO PASCAL 4.0 PROGRAM UTILITY DIRECTORY LIST MSDOS DISK

==========================================================================
}

PROGRAM qdl;

{------------------------------------------------------------------------------
     PROGRAM QDL Version 2.00A                                  09/01/84

     QDL uses MSDos to get a listing of an IBM formated diskette.
  The function calls used can be found in the DOS Technical Reference Manual.
  This program saves the current Data Transfer Area ( DTA ) in the variables
  DTAseg and DTAofs.  The DTA is then reset to the segment and offset of
  a buffer variable 'DTA'.

                                                    Written by

                                                       Jim McCarthy
                                                       Technical Support
                                                       Borland Int.

------------------------------------------------------------------------------}
{$I-}


Uses
  Crt,
  Dos;

TYPE                            { TYPE declarations }
      char80arr = array [ 1..80 ] of char;
      string80 = string[ 80 ];

   VAR                              { VARIABLE declarations }
      DTA : array [ 1..43 ] of byte;       { Data Transfer Area buffer }
      DTAseg,                              { DTA segment before execution }
      DTAofs,                              { DTA offset    "        "     }
      setDTAseg,                           { DTA segment and offset set after }
      setDTAofs,                           { start of program }
      error,                               { error return }
      i, j,                                { used as counters }
      option : word;                       { used to specify file types }
      regs : registers;                    { register pack for the DOS call }
      buffer,                              { generic buffer }
      namr : string80;                     { file name }
      mask : char80arr;                    { file mask }

{------------------------------------------------------------------------------
     SetDTA resets the current DTA to the new address specified in the
parameters 'SEGMENT' and 'OFFSET'.
------------------------------------------------------------------------------}

   PROCEDURE SetDTA( segment, offset : word; var error : word );

      BEGIN
         regs.ax := $1A00;         { Function used to set the DTA }
         regs.ds := segment;       { store the parameter segment in DS }
         regs.dx := offset;        {   "    "      "     offset in DX }
         MSDos( regs );            { Set DTA location }
         error := regs.ax and $FF; { get error return }
      END;

{------------------------------------------------------------------------------
     GetCurrentDTA is used to get the current Disk Transfer Area ( DTA )
address.  A function code of $2F is stored in the high byte of the AX
register and a call to the predefined procedure MSDos is made.  This can
also be accomplished by using the "Intr" procedure with the same register
record and a $21 specification for the interrupt.
------------------------------------------------------------------------------}

   PROCEDURE GetCurrentDTA( var segment, offset : word;
                            var error : word );

      BEGIN
         regs.ax := $2F00;    { Function used to get current DTA address }
                              { $2F00 is used instead of $2F shl 8 to save
                                three assembly instructions.  An idea for
                                optimization. }
         MSDos( regs );       { Execute MSDos function request }
         segment := regs.es;  { Segment of DTA returned by DOS }
         offset := regs.bx;   { Offset of DTA returned }
         error := regs.ax and $FF;
      END;

{------------------------------------------------------------------------------
     GetOption returns the code used to find the file names on the current
directory ( ie. hidden, standard, or directory ).
------------------------------------------------------------------------------}

   PROCEDURE GetOption( var option : word );

      VAR
        ch : char;

      BEGIN
         ch := '?';
         option := 1;
         While ( ch = '?' ) Do
            Begin
               write( 'File option to use, [ ? ] for list : ' );
               readln( ch );
               writeln;
               Case ( ch ) of
                  '1' : option := 1;        { -\                             }
                  '2' : option := 7;        {   \                            }
                  '3' : option := 8;        {    - These are the options.    }
                  '4' : option := 16;       {    - Look below for an expla-  }
                  '5' : option := 22;       {   /  of each.                  }
                  '6' : option := 31;       { -/                             }
                  '?' : Begin               { gives list of possible options }
                           writeln( 'File options are : ' );
                           writeln;
                           writeln( ' [ 1 ] for standard files [ default ].' );
                           write( ' [ 2 ] for system or hidden files ' );
                           writeln( 'and standard files.' );
                           writeln( ' [ 3 ] for volume label.' );
                           write( ' [ 4 ] for directories and ' );
                           writeln( 'standard files.' );
                           writeln( ' [ 5 ] for directories, hidden or ' );
                           write( '       system files, and standard' );
                           writeln( ' files.' );
                           write( ' [ 6 ] same as 5, but with volume' );
                           writeln( ' label included.' );
                           writeln;
                        End;
                  else option := 1;     { If nothing is typed or an }
               End;                     { incorrect entry is made the option }
            End;                        { is set to 1 }
      END;

{------------------------------------------------------------------------------
     GetFirst gets the first directory entry of a particular file mask.  The
mask is passed as a parameter 'mask' and,  the option was previosly specified
in the SpecifyOption procedure.
------------------------------------------------------------------------------}

   PROCEDURE GetFirst( mask : char80arr; var namr : string80;
                       segment, offset : word; option : word;
                       var error : word );
                     { compare Dos.FindFirst - DSMB }
      VAR
         i : word;

      BEGIN
         error := 0;
         regs.ax := $4E00;          { Get first directory entry }
         regs.ds := seg( mask );    { Point to the file mask }
         regs.dx := ofs( mask );
         regs.cx := option;         { Store the option }
         MSDos( regs );             { Execute MSDos call }
         error := regs.ax and $FF;  { Get error return }
         i := 1;                    { initialize 'i' to the first element }
         Repeat                     { Enter the loop that reads in the }
                                    { first file entry }
            namr[ i ] := chr( mem[ segment : offset + 29 + i ] );
            i := i + 1;
         Until ( not ( namr[ i - 1 ] in [ ' '..'~' ] ));
         namr[ 0 ] := chr( i - 1 );  { set string length because assigning }
                                     { by element does not set length }
      END;

{------------------------------------------------------------------------------
     GetNextEntry uses the first bytes of the DTA for the file mask, and
returns the next file entry on disk corresponding to the file mask.
------------------------------------------------------------------------------}

   PROCEDURE GetNextEntry( var namr : string80; segment, offset : word;
                           option : word; var error : word );
                         { compare Dos.FindNext - DSMB }
      VAR
         i : word;

      BEGIN
         error := 0;
         regs.ax := $4F00;           { Function used to get the next }
                                     { directory entry }
         regs.cx := option;          { Set the file option }
         MSDos( regs );              { Call MSDos }
         error := regs.ax and $FF;   { get the error return }
         i := 1;
         Repeat
            namr[ i ] := chr( mem[ segment : offset + 29 + i ] );
            i := i + 1;
         Until ( not ( namr[ i - 1 ] in [ ' '..'~' ] ));
         namr[ 0 ] := chr( i - 1 );
      END;


   BEGIN            { Begin Main Program }
      CheckBreak := false;        { replaces 3.0 $C- directive - DSMB }
      For i := 1 to 21 Do DTA[ i ] := 0;  { Initialize the DTA buffer }
      For i := 1 to 80 Do                 { Initialize the mask and }
         Begin                            { file name buffers }
            mask[ i ] := chr( 0 );
            namr[ i ] := chr( 0 );
         End;
      namr[ 0 ] := chr( 0 );              { Set the file name length to 0 }
      writeln( 'QDL version 2.00A' );
      writeln;
      GetCurrentDTA( DTAseg, DTAofs, error );  { Get the current DTA address }
      If ( error <> 0 ) then                        { Check for errors }
         Begin                                      { If yes then inform user }
            writeln( 'Unable to get current DTA' );
            writeln( 'Program aborting.' );         { and abort. }
            Halt;                                   { End program now }
         End;
      setDTAseg := seg( DTA );
      setDTAofs := ofs( DTA );
      SetDTA( setDTAseg, setDTAofs, error );        { Reset DTA addresses }
      If ( error <> 0 ) then
         Begin                                      { Check for errors }
            writeln( 'Cannot reset DTA' );          { Error message }
            writeln( 'Program aborting.' );
            Halt;                                   { End program }
         End;
      error := 0;
      buffer[ 0 ] := chr( 0 );                      { Set buffer length to 0 }
      GetOption( option );                          { Get file option }
      If ( option <> 8 ) then
         Begin
            write( 'File mask : ' );                { prompt }
            readln( buffer );
            writeln;
         End;
      If ( length( buffer ) = 0 ) then              { If nothing was entered }
         buffer := '????????.???';                  { then use global search }
      For i := 1 to length( buffer ) Do       { Assign buffer to mask }
         mask[ i ] := buffer[ i ];
      GetFirst( mask, namr, setDTAseg, setDTAofs, option, error );
      If ( error = 0 ) then                   { Get the first directory entry }
         Begin
            If ( option <> 8 ) then                 { If not volume label }
               Begin
                  writeln( 'Directory of : ', buffer );
                                                { write directory message }
                  writeln;
               End;
            writeln( namr )
         End
      else If ( option = 8 ) then
         writeln( 'Volume label not found.' )
      else
         writeln( 'File ''', buffer, ''' not found.' );
      While ( error = 0 ) Do
         Begin
            GetNextEntry( namr, setDTAseg, setDTAofs, option, error );
            If ( error = 0 ) then writeln( namr );
         End;
      SetDTA( DTAseg, DTAofs, error );
   END. { End Main }

