                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Printer setup program for the Epson RX-80.  Includes options for setting
pitch, emphasized print, doublespacing, italics and more.  Author: Pete
Eschman.  Version 1.2.  Turbo Pascal 4.0.

* KEYWORDS
TURBO PASCAL 4.0 PROGRAM UTILITY EPSON PRINTER SETUP

==========================================================================
}

Program PSET;    {Printer configuration program for Epson}

Uses
  Crt,
  Printer;

var choice:char;
    done:boolean;
BEGIN
done := false;
ClrScr;
While not done do
   begin
   writeln;
   writeln(' PSET.COM          Printer Options for Epson RX-80   version 1.2');
   writeln('                                         written by Pete Eschman');
   writeln;
   writeln(' Allow one extra line at the print head for this program.');
   writeln(' First make sure printer is powered up and on line.');
   writeln(' You may chose a series of options.');
   writeln;
   writeln(' Chose one at a time from the following options:');
   writeln('   0  standard (Pica) type font');
   writeln('   1  Elite type font');
   writeln('   2  double strike');
   writeln('   3  emphasized');
   writeln('   4  italics');
   writeln('   5  set left margin to 0 spaces');
   writeln('   6  set left margin to 10 spaces = 1 inch in Pica');
   writeln('   7  set left margin to 15 spaces = 1 1/2 inch in Pica');
   writeln('   8  single space print (do NOT use WordStar page formats)');
   writeln('   9  double space print (do NOT use WordStar page formats)');
 writeln('   C  Compressed set-up (Compressed,1/8 inch line,15 space L margin');
   writeln('   P  Perforation skip over for Compressed set-up');
   writeln('   R  master reset (returns to default settings)');
   readln(choice);
   choice := Upcase(choice);
   while not done do
      begin
      Case choice of
         '0': begin writeln('standard (Pica) selected...');
                    write(Lst,#27,'@') end;
         '1': begin writeln('Elite selected...');
                    write(Lst,#27,'M') end;
         '2': begin writeln('double strike selected...');
                    write(Lst,#27,'G') end;
         '3': begin writeln('emphasized selected...');
                    write(Lst,#27,'E') end;
         '4': begin writeln('italics selected...');
                    write(Lst,#27,'4') end;
         '5': begin writeln('left margin set to 0 spaces...');
                    write(Lst,#27,'l',#0) end;
         '6': begin writeln('left margin set to 10 spaces...');
                    write(Lst,#27,'l',#10) end;
         '7': begin writeln('left margin set to 15 spaces...');
                    write(Lst,#27,'l',#15) end;
         '8': begin writeln('single spacing, do NOT use WordStar page formats');
                    write(Lst,#27,'2',#27,'N',#12#27,'l',#8) end;
         '9': begin writeln('double spacing, do NOT use WordStar page formats');
                    write(Lst,#27,'A',#24#27,'N',#6#27,'l',#8) end;
         'C': begin writeln('Compressed set-up selected...');
                    write(Lst,#15#27,'0',#27,'l',#15) end;
         'P': begin writeln('Perforation skip over for Compressed set-up');
                    write(Lst,#27,'N',#16) end;
         'R': begin writeln('returing to default settings...');
                    write(Lst,#27,'@') end
         else writeln(Chr(7),Chr(7),Chr(7),'not a valid option')
         end;
      writeln('Enter another option or "N" if you are done');
      readln(choice);
      choice := UpCase(choice);
      if choice = 'N' then
         done := true;
      end;
   writeln(Lst)
   end;
END.

