                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Program to "park" the heads on all fixed disk drives on a PC system.  Locks
the system up from keyboard input in preparation for power-down.  Author:
Sam Smith.  Version T1.0.  Turbo Pascal 4.0.

* ASSOCIATED FILES
PARK.PAS
PARK.DOC

* KEYWORDS
TURBO PASCAL 4.0 PROGRAM HARDDISK KEYBOARD LOCK UTILITY

==========================================================================
}

program park_heads;


Uses
  Dos;

procedure park;

{ Parks heads on all available hard disk drives }
{ Author: Sam Smith              Date: 2-Nov-85 }
{ Copyright 1985 by SamWise Information Systems }
{ All other rights reserved.                    }
{ Rights for non-profit usage and distribution  }
{ by individual users are hereby granted.       }

var  reg:        registers;
     drive:      word;
     numdrv:     word;
     maxcyl:     word;

begin
  reg.ax := $0801;    { Get # of drives }
  reg.cx := $0000;
  reg.dx := $0080;
  intr($13,reg);
  numdrv := reg.dx and 7;
  writeln('Number of fixed disk drives: ',numdrv);
  writeln;
  for drive := 0 to numdrv-1 do
  begin
    reg.ax := $0801;  { Get drive parameters for next drive }
    reg.cx := $0000;
    reg.dx := drive or $0080;
    intr($13,reg);
    maxcyl := ((reg.cx shr 8) or ((reg.cx shl 2) and $0300)) + 1;
    writeln('Parking drive ',drive,' at cylinder ',maxcyl,'.');
    reg.ax := $0C01;  { Seek to the max cylinder + 1; sector #1 }
    reg.cx := ((maxcyl and $00FF) shl 8) or ((maxcyl and $0300) shr 2) or 1;
    reg.dx := drive or $0080;
    intr($13,reg);
    if reg.flags and 1 <> 0 then
      writeln('Error code on drive ',drive,': ',trunc(reg.ax/256))
    else
    begin
      writeln('Drive ',drive,' parked successfully.');
      writeln;
    end;
  end;
end;


begin
  park;
  writeln('***** Turn off the power now. *****');
  while true do;
end.

