                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Program to display and examine the contents of memory locations in the IBM
PC.  Author: Roger McCarty.  Version 0.0.  Turbo Pascal 4.0.


* KEYWORDS
TURBO PASCAL 4.0 PROGRAM UTILITY MEMORY DISPLAY

==========================================================================
}

program memlook;

Uses
  Crt,
  Dos;

type
  halfregister = byte;
  screen = array[0..3839] of char;
  display_line = string[80];
  memory_segment = array[0..255] of byte;
  ch2 = string[2];
  ch4 = string[4];

var
  mono_display : screen absolute $B000:0000;
  color_display : screen absolute $B800:0000;
  scrn : screen;
  video_mode : byte;
  seg_data : memory_segment;
  segment : word;
  offset : word;
  quit : boolean;

procedure get_key(var key:char;var ekey:boolean);
begin
  { while not keypressed do;}      { no effect - DSMB }
  ekey:=false;
  key := readkey;
  if (key=#0) then
     begin
     ekey:=true;
     key := readkey;
     end;
end;

function get_video_mode:byte;
var
  regs : registers;
  ah,al : halfregister;

begin
  al:=0;
  ah:=15;
  regs.ax:=ah shl 8 + al;          { shorter: regs.ax:=$0F00 - DSMB }
  intr($10,regs);
  get_video_mode:=regs.ax shl 8 shr 8;
                           { shorter: get_video_mode:=regs.al - DSMB }
end;

procedure set_video_mode(mode:byte);
var
  regs : registers;
  ah,al : halfregister;

begin
  ah:=0;
  if mode <> 2 then
     if mode <> 3 then
        mode:=2;
  al:=mode;
  regs.ax:=ah shl 8 + al;
  intr($10,regs);
end;

procedure put_screen(scrn:screen);
begin
  if video_mode = 7 then { 2 replaced by 7 - DSMB }
     mono_display:=scrn
  else
     color_display:=scrn;
end;

procedure clr_screen(var scrn:screen);
var
  counter : word;

begin
  counter:=0;
  while counter <= 3839 do
    begin
    scrn[counter]:=' ';
    scrn[counter+1]:=chr(7);
    counter:=counter+2;
    end;
end;

procedure put_char_row_col(var scrn:screen;ch:char;r,c:word);
begin
  scrn[160*(r-1)+2*(c-1)]:=ch;
end;

procedure put_string_row_col(var scrn:screen;st:display_line;r,c:word);
var
  counter : word;

begin
  counter:=1;
  while counter <= length(st) do
    begin
    put_char_row_col(scrn,st[counter],r,c+counter-1);
    counter:=counter+1;
    end;
end;

procedure init_screen(var scrn:screen);
var
  line : display_line;
  counter : word;

begin
  TextAttr := 15;
  clr_screen(scrn);
  line:='';
  counter:=1;
  while counter <= 80 do
    begin
    line:=line+chr(205);
    counter:=counter+1;
    end;
  put_string_row_col(scrn,line,1,1);
  put_string_row_col(scrn,line,19,1);
  line:='0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F    0123456789ABCDEF';
  put_string_row_col(scrn,line,2,14);
  counter:=0;
  while counter <= 15 do
    begin
    put_string_row_col(scrn,':',counter+3,5);
    put_char_row_col(scrn,chr(16),counter+3,63);
    put_char_row_col(scrn,chr(17),counter+3,80);
    counter:=counter+1;
    end;
  put_string_row_col(scrn,'MEMLOOK <0.0>',20,1);
  put_string_row_col(scrn,'>0000:0000<  -  Specify starting display address',21,28);
  put_string_row_col(scrn,'Press ? for Help',24,1);
end;

procedure init_program(var scrn:screen;var video_mode:byte);
begin
  video_mode:=get_video_mode;
  if not video_mode in [2,7] then    { modified for mono compatibility - DSMB }
     if video_mode <> 3 then
        begin
        set_video_mode(3);
        video_mode:=get_video_mode;
        end;
  init_screen(scrn);
end;

procedure word_to_hex(int:word;var hx:ch4);
var
  nibble1 : word;
  nibble2 : word;
  nibble3 : word;
  nibble4 : word;

begin
  nibble1:=int shr 12;
  nibble2:=int shl 4 shr 12;
  nibble3:=int shl 8 shr 12;
  nibble4:=int shl 12 shr 12;
  if nibble1 > 9 then
     nibble1:=nibble1+55
  else
     nibble1:=nibble1+48;
  if nibble2 > 9 then
     nibble2:=nibble2+55
  else
     nibble2:=nibble2+48;
  if nibble3 > 9 then
     nibble3:=nibble3+55
  else
     nibble3:=nibble3+48;
  if nibble4 > 9 then
     nibble4:=nibble4+55
  else
     nibble4:=nibble4+48;
  hx[1]:=chr(nibble1);
  hx[2]:=chr(nibble2);
  hx[3]:=chr(nibble3);
  hx[4]:=chr(nibble4);
end;

procedure byte_to_hex(ch:byte;var hx:ch2);
var
  high : byte;
  low : byte;

begin
  high:=ord(ch) shr 4;
  low:=ord(ch) and $F;
  if high > 9 then
     high:=high+55
  else
     high:=high+48;
  if low > 9 then
     low:=low+55
  else
     low:=low+48;
  hx[1]:=chr(high);
  hx[2]:=chr(low);
end;

procedure convert_seg(seg_data:memory_segment;var scrn:screen);
var
  para : word;
  pos : word;
  hx : ch2;

begin
  para:=0;
  while para <= 15 do
    begin
    pos:=0;
    while pos <= 15 do
      begin
      byte_to_hex(seg_data[16*para+pos],hx);
      put_char_row_col(scrn,hx[1],para+3,13+3*pos);
      put_char_row_col(scrn,hx[2],para+3,14+3*pos);
      put_char_row_col(scrn,chr(ord(seg_data[16*para+pos])),para+3,64+pos);
      pos:=pos+1;
      end;
    para:=para+1;
    end;
end;

procedure put_address(s,o:word;var scrn:screen);
var
  seg_hx : ch4;
  ofs_hx : ch4;
  oft : word;
  counter : word;

begin
  word_to_hex(s,seg_hx);
  put_char_row_col(scrn,seg_hx[1],21,29);
  put_char_row_col(scrn,seg_hx[2],21,30);
  put_char_row_col(scrn,seg_hx[3],21,31);
  put_char_row_col(scrn,seg_hx[4],21,32);
  word_to_hex(o,ofs_hx);
  put_char_row_col(scrn,ofs_hx[1],21,34);
  put_char_row_col(scrn,ofs_hx[2],21,35);
  put_char_row_col(scrn,ofs_hx[3],21,36);
  put_char_row_col(scrn,ofs_hx[4],21,37);
  counter:=0;
  while counter <= 15 do
    begin
    put_char_row_col(scrn,seg_hx[1],counter+3,1);
    put_char_row_col(scrn,seg_hx[2],counter+3,2);
    put_char_row_col(scrn,seg_hx[3],counter+3,3);
    put_char_row_col(scrn,seg_hx[4],counter+3,4);
    oft:=o+counter*16;
    word_to_hex(oft,ofs_hx);
    put_char_row_col(scrn,ofs_hx[1],counter+3,6);
    put_char_row_col(scrn,ofs_hx[2],counter+3,7);
    put_char_row_col(scrn,ofs_hx[3],counter+3,8);
    put_char_row_col(scrn,ofs_hx[4],counter+3,9);
    counter:=counter+1;
    end;
end;

procedure get_segment(s,o:word;var seg_data:memory_segment);
begin
  move(mem[s:o],seg_data,256);
end;

procedure remove_dos_cursor;
var
  reg : registers;

begin
  reg.ax:=$100;
  reg.cx:=3598;
  intr($10,reg);
end;

procedure wait_for_space;
var
  input : char;
  ekey : boolean;

begin
  input:=chr(0);
  while input<>' ' do
    begin
    gotoxy(1,24);
    writeln('Please press the SPACE bar to continue ...');
    { while not keypressed do;}      { no effect - DSMB }
    get_key(input,ekey);
    if input<>' ' then
       begin
       clrscr;
       writeln(chr(7));
       textattr:=15;
       end;
    end;
  clrscr;
  textattr:=15;
end;

procedure restore_dos_cursor;
var
  reg : registers;

begin
  reg.ax:=$100;
  reg.cx:=1802;
  intr($10,reg);
end;

procedure help;
begin
  textattr:=7;
  clrscr;
  remove_dos_cursor;
  writeln('HELP INFORMATION PANEL  -  MEMLOOK <0.0>  03/17/85');
  writeln('==================================================');
  writeln('');
  writeln('The following functions are currently available:');
  writeln('');
  writeln(chr(24)+' .................... Show previous line of 16 bytes.');
  writeln(chr(25)+' .................... Show next line of 16 bytes.');
  writeln('PgUp ................. Show previous page of 256 bytes.');
  writeln('PgDn ................. Show next page of 256 bytes.');
  writeln('Home ................. Starting display address = 0000:0000.');
  writeln('End .................. Starting display address = FFF0:0000.');
  writeln('? .................... This panel.');
  writeln('Esc .................. Exit program.');
  writeln('');
  writeln('');
  writeln('Comments/Suggestions - Contact  Roger McCarty');
  writeln('                                11534 Breckenridge Dr.');
  writeln('                                Whittier, CA 90604');
  writeln('                                (213) 944-4191');
  wait_for_space;
  restore_dos_cursor;
end;

procedure up_key(var s,o:word);
begin
  if o=0 then
     begin
     s:=s-1;
     o:=0
     end
  else
     begin
     o:=o-16;
     end;
end;

procedure down_key(var s,o:word);
begin
  o:=o+16;
end;

procedure home_key(var s,o:word);
begin
  s:=0;
  o:=0;
end;

procedure end_key(var s,o:word);
begin
  s:=$FFF0;
  o:=0;
end;

procedure page_up_key(var s,o:word);
begin
  s:=s-16;
end;

procedure page_down_key(var s,o:word);
begin
  s:=s+16;
end;

function hex_char(ch:char):boolean;
var
  result : boolean;

begin
  result:=false;
  if ord(ch) > 47 then
     if ord(ch) < 58 then
        result:=true;
  if ord(ch) > 64 then
     if ord(ch) < 71 then
        result:=true;
  hex_char:=result;
end;

function hex_char_to_word(hx:ch4):word;
var
  counter : word;
  nibble1 : word;
  nibble2 : word;
  nibble3 : word;
  nibble4 : word;

begin
  nibble1:=ord(hx[1]);
  nibble2:=ord(hx[2]);
  nibble3:=ord(hx[3]);
  nibble4:=ord(hx[4]);
  if nibble1 > 57 then
     nibble1:=nibble1-55
  else
     nibble1:=nibble1-48;
  if nibble2 > 57 then
     nibble2:=nibble2-55
  else
     nibble2:=nibble2-48;
  if nibble3 > 57 then
     nibble3:=nibble3-55
  else
     nibble3:=nibble3-48;
  if nibble4 > 57 then
     nibble4:=nibble4-55
  else
     nibble4:=nibble4-48;
  hex_char_to_word:=nibble1*4096+nibble2*256+nibble3*16+nibble4;
end;

procedure process_command(var s,o:word;var quit:boolean);
var
  segx : ch4;
  ofsx : ch4;
  _pointer : word;
  do_again : boolean;
  command : char;
  ekey : boolean;

begin
  gotoxy(29,21);
  _pointer:=1;
  do_again:=true;
  segx:='';
  ofsx:='';
  while do_again do
    begin
    command:=chr(0);
    while command < #$1A do
      get_key(command,ekey);
    do_again:=false;
    command:=upcase(command);
    if (command=#27) and not ekey then
       begin
       clrscr;
       quit:=true;
       end;
    if hex_char(command) then
       begin
       if _pointer < 5 then
          begin
          gotoxy(29+_pointer-1,21);
          writeln(command);
          if _pointer = 4 then
             gotoxy(30+_pointer,21)
          else
             gotoxy(29+_pointer,21);
          segx:=segx+command
          end
       else
          begin
          gotoxy(30+_pointer-1,21);
          writeln(command);
          gotoxy(30+_pointer,21);
          ofsx:=ofsx+command;
          end;
       _pointer:=_pointer+1;
       if _pointer > 8 then
          begin
          s:=hex_char_to_word(segx);
          o:=hex_char_to_word(ofsx);
          end
       else
          begin
          do_again:=true;
          end;
       end;
    case command of
      #$48 : begin {Up arrow}
             up_key(s,o);
             end;
      #$50 : begin {Down arrow}
             down_key(s,o);
             end;
      #$47 : begin {Home key}
             home_key(s,o);
             end;
      #$4F : begin {End key}
             end_key(s,o);
             end;
      #$49 : begin {Page up key}
             page_up_key(s,o);
             end;
      #$51 : begin {Page down key}
             page_down_key(s,o);
             end;
      #$3F : begin {Help key}
             help;
             end;
    end;
    end;
end;

begin
  init_program(scrn,video_mode);
  segment:=0;
  offset:=0;
  quit:=false;
  while not quit do
    begin
    get_segment(segment,offset,seg_data);
    convert_seg(seg_data,scrn);
    put_address(segment,offset,scrn);
    put_screen(scrn);
    process_command(segment,offset,quit);
    end;
end.

