                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Program to demonstrate the use of reading a character from the keyboard,
while allowing full extended keycode detection.  Author: Kevin Bales.
Version T1.0.  Turbo Pascal 4.0.

* ASSOCIATED FILES


* KEYWORDS
TURBO PASCAL 4.0 PROGRAM DEMO ROUTINE GET CHAR EXTEND KEY CODE

==========================================================================
}

Program Buffered_Keyboard_Routine;

{   This Routine Calls DOS when a key is pressed to get a character. }
{ This allows full access to the extended key codes.                 }
{ The Demo with the routine Beeps every so often when a character    }
{ has not been typed. Extended characters are printed in highlight.  }
{ Written by: Kevin Bales   Atlanta,Georgia 404-321-3841             }
{ ***NOTE: The DOS routine used has the side effect of having Ctrl-S }
{          and Ctrl-C having the same effects as in DOS. Ctrl-S      }
{          Pauses, and Ctrl-C Interupts like a Ctrl-Break .          }


Uses
  Crt,
  Dos;

Var
 Ch:           Char;
 Extended_K:   Boolean;
 Count:       Integer;

Procedure GetChar(VAR Ch: Char; VAR _Extended: Boolean);
{ This Procedure acts similar to the BASIC "Inkey$" command. }
{ If no Character is in the Keyboard buffer, then Ch is set  }
{ to ASCII code 0. If the character in the buffer is a char  }
{ with an extended scan code, then _Extended is set to true, }
{ and Ch is equal to the characters scan code.               }
Var
 Reg: Registers;
 AL:  Integer;
Begin
Ch:=#0; _Extended:=False;
If KeyPressed Then
 Begin
 Reg.Ax:=$0800;                { -Set AH as $8 for Dos Function call      }
 Intr($21,Reg);                { -Calls Interupt $21 for Dos Function call}
 AL:=(Reg.AX AND $00FF);       { -Derive AL from AX                       }
 Ch:=Chr(AL);                  { -Set Ch to character to AL               }
 If Ch=#0 then
  Begin                       { Routine to get extended character scan code }
  Reg.Ax:=$0800;
  Intr($21,Reg);
  Ch:=Chr(Reg.AX AND $00FF);
  _Extended:=True;
  End;
 End;
End;

(* the following procedure serves exactly the same purpose - DSMB
Procedure GetChar(VAR Ch: Char; VAR _Extended: Boolean);
Begin
  Ch:=#0;
  _Extended:=True; { no effect while Ch=#0 anyway - DSMB }
  If KeyPressed Then Begin
    Ch:=ReadKey;
    If Ch=#0 then Ch:=ReadKey else _Extended:=False;
  End;
End;                                                        *)


Begin
TextAttr := 7;
Write('Enter Line:');
Repeat
 GetChar(Ch,Extended_K);
 If Ch<>#0 then
  Begin
  If Extended_K then HighVideo Else LowVideo;
  If Ch=#8 then Write(#8,' ',#8)
   Else Write(Ch);
  End
 Else
  Begin
  Count:=Count+1;
  If Count=5000 then
   Begin
   Count:=0;
   Sound(1000); Delay(100); NoSound;
   End;
  End;
Until Ch=#13;
End.

