                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Program to demonstrate the routines in FLASHPRO.PAS.  Author: Bill Hileman.
Version 1.00.  Turbo Pascal 4.0.

* ASSOCIATED FILES
FLASH.PAS
FLASHPRO.PAS


* KEYWORDS
TURBO PASCAL 4.0 HARDWARE CONFIGURATION CURSOR ROUTINE

==========================================================================
}

{ FLASH.PAS (C) Copyright 1985 by Bill Hileman

  The following routines are released to the Public Domain to be used
  in programs and/or be distributed free of charge, provided that they
  are distributed in their original form, and including this copyright
  notice.

  Version 1.00  09/08/85

  Program to demonstrate use of FLASHPRO.PAS routines        }

program flash;

Uses
  Crt,
  Dos,
  FlashPro;

const
  version = '1.00';
  v_date  = '09/08/85';

var
  org_c_start,
  org_c_end,
  equip_flag,
  printers,
  rs_232s,
  floppies, ram : word;
  mono, color,
  game_adapt,
  dma_chip,
  flop          : boolean;

procedure press_enter;

var
  ch   : char;
  done : boolean;

begin
  done:=false;
  repeat
    { repeat until keypressed; { superfluous - DSMB }
    ch := readkey;
    if ch=chr(13) then
      done:=true;
  until done;
end;

begin
  get_cursor_size(org_c_start,org_c_end);
  set_cursor_size(32,0); { off }
  equip_flag:=get_equip_flag;
  printers:=(equip_flag shr 14);
  game_adapt:=((equip_flag and $1000)=$1000);
  rs_232s:=((equip_flag shr 9) and $0007);
  dma_chip:=((equip_flag and $0100)=0);
                               { corrected: installed if this bit is 0 - DSMB }
  floppies:=((equip_flag shr 6) and $0003)+1;
  mono:=((equip_flag and $0030)=$0030);{ $0300 replaced twice by $0030 - DSMB }
  color:=(not mono);
  flop:=((equip_flag and $0001)=$0001);
  ram:=get_installed_ram;
  clrscr;
  textcolor(white+blink);
  textbackground(black);
  write  ('FLASH');
  if mono then
    textcolor(white)
  else
    textcolor(blue);
  writeln(' - (C) Copyright 1985 by Bill Hileman');
  writeln('        Version ',version,'  ',v_date);
  writeln;
  if color then
    textcolor(red);
  writeln('Demonstrates the capabilities of the functions');
  writeln('and procedures contained in ''FLASHPRO.PAS''.');
  writeln;
  if color then
    textcolor(cyan);
  writeln('Current hardware configuration:');
  writeln;
  writeln('       Installed RAM: ',ram:3,'k');
  write  ('               Video: ');
  if mono then
    writeln('monochrome')
  else
    writeln('color');
  write  ('   Printers attached: ');
  if (printers>0) then
    writeln(printers:1)
  else
    writeln('none');
  write  ('  Floppy Disk Drives: ');
  if flop then
    writeln(floppies:1)
  else
    writeln('none');
  write  ('        Game Adapter: ');
  if (not game_adapt) then
    write('not ');
  writeln('installed');
  write  ('RS232 (serial) Ports: ');
  if (rs_232s>0) then
    writeln(rs_232s:1)
  else
    writeln('none');
  write  ('            DMA Chip: ');
  if (not dma_chip) then
    write('not ');
  writeln('installed');
  writeln;
  if color then
    textcolor (magenta);
  write('Block cursor - Press [ENTER] < >',#8,#8);
  if mono then
    set_cursor_size(0,13)
  else
    set_cursor_size(0,7);
  press_enter;
  writeln;
  writeln;
  if color then
    textcolor(yellow);
  write('  Bar cursor - Press [ENTER] < >',#8,#8);
  if mono then
    set_cursor_size(12,13)
  else
    set_cursor_size(6,7);
  press_enter;
  writeln;
  writeln;
  if color then
    textcolor(green);
  write('   No cursor - Press [ENTER] < >',#8,#8);
  set_cursor_size(32,0);
  press_enter;
  writeln;
  if color then
    textcolor(white);
  set_cursor_size(org_c_start,org_c_end);
end.

