                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Program to print address on 3.5-inch tractor-feed envelopes.  Designed
for Epson FX-80 printer.  Author: Drew Letcher.  Version T1.0.  Turbo
Pascal 4.0.

* ASSOCIATED FILES


* KEYWORDS
TURBO PASCAL 4.0 PROGRAM EPSON PRINTER ADDRESS

==========================================================================
}

PROGRAM EnvelopeAddresser ( Input, Output );

{     Written By:  Drew Letcher          November, 1984
      Language:    TurboPascal

  This program is designed to address and print tractor feed envelopes.  The
  envelopes must be 3.5" top to top.  Parameters that may need to be changed
  are in the CONST declarations, and in the PrinterCommands routine.  The
  printer command line in this source code is set for the Epson FX-80, in the
  compiled version it is left empty.
}


Uses
  Crt,
  Printer;

CONST
     Title           =  ' Envelope Address Generator ';

    { Default Return address }
    DefAddress1      =  'Drew Letcher';
    DefAddress2      =  '104 Hawkeye Ct.';
    DefAddress3      =  'Iowa City, IA  52240';
    DefAddress4      =  '';
    DefAddress5      =  '';
    DefAddress6      =  '';

    { Window dimensions }
     X1              =  2;
     Y1              =  8;
     X2              =  79;
     Y2              =  22;


TYPE

   addressinfo  =  ARRAY[ 1..6 ] OF string[ 30 ];
   printerline  =  string[ 16 ];

VAR

   DefaultInfo,
   ReturnInfo,
   SendInfo          :  addressinfo;

   Answer,
   Satisfied         :  char;

   I                 :  integer;

{  end of Main declaractions  }



FUNCTION  PrinterCommands : printerline;

   BEGIN

      PrinterCommands := chr(27) + '@' + chr(27) + 'G' + chr(27) + 'p1';
      {  For the Epson FX-80:  reset, double-strike, proportional  }

   END;  {  Function PrinterCommands  }



PROCEDURE InitDefault ( VAR DefaultInfo : addressinfo );

   BEGIN

      DefaultInfo[ 1 ] := DefAddress1;
      DefaultInfo[ 2 ] := DefAddress2;
      DefaultInfo[ 3 ] := DefAddress3;
      DefaultInfo[ 4 ] := DefAddress4;
      DefaultInfo[ 5 ] := DefAddress5;
      DefaultInfo[ 6 ] := DefAddress6;

   END;  { Procedure InitDefault  }


PROCEDURE ClearLastLine;

   CONST
      ClearHalfLine  =  '                                       ';

   BEGIN

      Window( 1,1, 80,25 );
      GotoXY( 1,25 );
      TextBackground( red );
      write( ClearHalfLine, ClearHalfLine );
      GotoXY( 1,25 );

   END;  { Procedure ClearLastLine }



PROCEDURE ScreenLayout( DefaultInfo : addressinfo );

   VAR
      I  :  integer;

   BEGIN

      { reset window }
      Window( 1,1, 80,25 );
      TextColor( yellow );

      {  title }
      TextBackground( green );
      ClrScr;
      GotoXY( 25, 3 );
      TextBackground( red );
      writeln( Title );

      { command line }
      GotoXY( 1,25 );
      writeln;
      GotoXY( 1,25 );
      write( ' Enter each line and press ENTER.   Press ENTER for defaults.' );

      { envelope outline }
      Window( X1, Y1, X2, Y2 );
      TextBackground( blue );
      ClrScr;

      { stamp outline }
      Window( 72,Y1+1, 77,Y1+3 );
      TextBackground( magenta );
      ClrScr;

      { return address window }
      Window( X1+1, Y1+1, X1+30, Y1+6 );
      TextBackground( lightgray );
      ClrScr;

      FOR I := 1 TO 6 DO
         BEGIN
            write( DefaultInfo[ I ] );
            IF I < 6 THEN
               writeln;
         END;

      { send addres window }
      Window( X1+33, Y1+8,  X1+62, Y1+13 );
      TextBackground( lightgray );
      ClrScr;

   END;  {  Procedure ScreenLayout }


PROCEDURE InputInfo ( DefaultInfo : addressinfo;
                      VAR ReturnInfo, SendInfo : addressinfo );

   VAR
      I  :  integer;

   BEGIN

      Window( 1,1, 80,24 );

      FOR I := 1 TO 6 DO
         BEGIN
            GotoXY( X1+1, Y1+I );
            readln( ReturnInfo[ I ] );
            IF Length( ReturnInfo[ I ] ) = 0 THEN
               ReturnInfo[ I ] := DefaultInfo[ I ];

         END;

      FOR I := 1 TO 6 DO
         BEGIN
            GotoXY( X1+33, Y1+7+I );
            readln( SendInfo[ I ] );
         END;

   END;  { Procedure InputInfo }



PROCEDURE PrintEnvelope ( VAR ReturnInfo, SendInfo : addressinfo );

   VAR
      I                 :  integer;

   BEGIN

      write( lst, PrinterCommands );

      FOR I := 1 TO 6 DO
         writeln( lst, ReturnInfo[ I ] );

      writeln( lst );
      writeln( lst );
      writeln( lst );

      FOR I := 1 TO 6 DO
         writeln( lst, '                                  ', SendInfo[ I ] );

     FOR I := 1 TO 6 DO
        writeln( lst );

   END;  { procedure PrintEnvelope }


BEGIN  { Main Routine }

   InitDefault( DefaultInfo );

   REPEAT

      REPEAT
         ScreenLayout( DefaultInfo );
         InputInfo( DefaultInfo, ReturnInfo, SendInfo );

         ClearLastLine;
         write( 'Satisfied with this envelope Y/N ? ' );
         Satisfied := readkey;
      UNTIL ( Satisfied = 'y' ) or ( Satisfied = 'Y' );

      ClearLastLine;
      write( 'Do you want to print this envelope Y/N ? ' );
      Answer := readkey;
      IF ( Answer = 'y' ) or ( Answer = 'Y' ) THEN
         PrintEnvelope( ReturnInfo, SendInfo );

      ClearLastLine;
      write( 'How about another Y/N ? ' );
      Answer := readkey;
   UNTIL NOT ( ( Answer = 'y' ) or ( Answer = 'Y' ) );

   TextBackground( black ); TextColor ( lightgray );
                                    {  modified for 4.0 Compatibility - DSMB }
END.

