                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Program to selectively list the contents of a hard or floppy disk.  Options
to select all files, those stamped after a specified date, or duplicate
files only. Maximum of 50 subdirectories. Author: George Goldberg.
Version: T1.0.  Turbo Pascal 4.0.

* ASSOCIATED FILES


* KEYWORDS
TURBO PASCAL 4.0 PROGRAM LIST HARDDISK FLOPPY FILE DATE TIME UTILITY

==========================================================================
}

PROGRAM dir;

{written by George Goldberg
 copyright 1985 The Catalog Company
 Released to public domain}

{$B+}  { necessary to clear IOResult in PROCEDURE INTRODUCTION - DSMB }

Uses
  Crt,
  Dos;

CONST
   max_record = 2000;
   max_dir = 50;

   TYPE
     file_record=RECORD
                catalog:BYTE;
                name:STRING[12];
                attribute:BYTE;
                file_month,file_day,file_year,file_hour,file_min:BYTE;
                file_size:REAL;
              END;
     char80arr=ARRAY[1..80] OF CHAR;
     string80=STRING[80];

   VAR
     file_catalog:ARRAY [1..max_record] OF file_record;
     dev:TEXT;
     dta:ARRAY[1..43] OF BYTE;
     subdir:ARRAY [1..max_dir] OF string80;
     dir1,dir2:STRING[3];
     ok,printer:BOOLEAN;
     origdir,sub:string80;
     end_page,linecount,num,num1,num2,opt,index,pagenum:INTEGER;
     dtaseg,dtaofs,error,
     i,j,loop,scan_month,scan_day,scan_year,ok_date,
     att,option,year,month,day,hour,min,sec:INTEGER;
     setdtaseg,setdtaofs:WORD;
     size:REAL;
     regs:registers;
     buffer,namr:string80;
     mask:char80arr;
     ch:CHAR;

PROCEDURE setdta(segment,offset:WORD;VAR error:INTEGER);

BEGIN
  regs.ax:=$1a00;
  regs.ds:=segment;
  regs.dx:=offset;
  MSDOS(regs);
  error:=regs.ax AND $ff;
END;

PROCEDURE time;
          { compare Dos.GetDate and Dos.GetTime - DSMB }
BEGIN
  regs.ax:=$2a00;
  WITH regs DO
  BEGIN
    MSDOS(regs);
    WRITE (dev,' ',HI(dx):2,'-',LO(dx):2,'-',cx-1900:2,' ');
    regs.ax:=$2c00;
    MSDOS(regs);
    WRITE (dev,'   ',HI(cx):2,':',LO(cx):2)
  END;
END;

PROCEDURE getcurrentdta(VAR segment,offset:INTEGER; VAR error:INTEGER);

BEGIN
  regs.ax:=$2f00;
  MSDOS(regs);
  segment:=regs.es;
  offset:=regs.bx;
  error:=regs.ax AND $ff;
END;


PROCEDURE information (segm,offs:WORD);

BEGIN
  i:=1;
  REPEAT
    namr[i]:=CHR(MEM[segm:offs+29+i]);
    i:=i+1;
  UNTIL (NOT(namr[i-1] IN [' '..'~']));
  att:=MEM[segm:offs+21];
  hour:=((MEM[segm:offs+23])SHR 3 )AND $1f  ;
  month:=((MEM[segm:offs+25] AND $01))*8
      +((MEM[segm:offs+24]SHR 5)AND $07);
  min:=(MEM[segm:offs+23] AND $07)*8
      +((MEM[segm:offs+22]SHR 5)AND $07);
  day:=(MEM[segm:offs+24] AND $1f);
  year:=80+(MEM[segm:offs+25] AND $0fe) SHR 1;
  size:=(MEM[segm:offs+26]* 1.0)+
        (MEM[segm:offs+27]* 256.0)+
        (MEM[segm:offs+28]* 65536.0)+
        (MEM[segm:offs+29]* 16777216.0);
  namr[0]:=CHR(i-1);
END;


PROCEDURE getfirst(mask:char80arr;VAR namr:string80;segment,
                   offset:WORD;option:INTEGER; VAR error:INTEGER);
          { compare Dos.FindFirst - DSMB }
VAR
  i:INTEGER;

BEGIN
  error:=0;
  regs.ax:=$4e00;
  regs.ds:=SEG(mask);
  regs.dx:=OFS(mask);
  regs.cx:=option;
  MSDOS(regs);
  error:=regs.ax AND $ff;
  information(segment,offset);
END;

PROCEDURE getnextentry(VAR namr:string80; segment,offset:WORD;
                       option:INTEGER;VAR error:INTEGER);
          { compare Dos.FindNext - DSMB }
VAR
  i:INTEGER;

BEGIN
  error:=0;
  regs.ax:=$4f00;
  regs.cx:=option;
  MSDOS(regs);
  error:=regs.ax AND $ff;
  information(segment,offset);
END;

PROCEDURE print_listings;
VAR
  temp:STRING[13];

BEGIN
  IF (namr<>dir1) AND (namr<>dir2) THEN
  WITH file_catalog[index] DO
  BEGIN
    IF (opt =  3) AND (ok_date <= (year-80)*365+month*31+day) OR (opt<>3)
    THEN
    BEGIN
      IF sub[LENGTH(sub)]<>'\' THEN sub:=sub+'\';
      catalog:=loop;
      temp:=namr;
      DELETE (temp,LENGTH(temp),1); {remove chr(0) at end of string}
      name:=temp;
      attribute:=att;
      file_year:=year;
      file_day:=day;
      file_month:=month;
      file_hour:=hour;
      file_min:=min;
      file_size:=size;
      index:=index+1;
      IF index > max_record THEN
      BEGIN
        CLRSCR;
        GOTOXY (5,10);
        WRITELN ('########  PROGRAM HALTED #########');
        WRITELN;
        WRITELN ('MAXIMUM NUMBER OF FILES [',max_record,'] EXCEEDED');
        WRITELN ;
        WRITELN ('Cannot Use this program - sorry ');
        CHDIR (origdir);
        HALT;
      END;
    END;
  END;
END;

PROCEDURE getinfo;
BEGIN
  FOR i:=1 TO 21 DO dta[i]:=0;
  FOR i:=1 TO 80 DO
  BEGIN
    mask[i]:=CHR(0);
    namr[i]:=CHR(0);
  END;
  namr[0]:=CHR(0);
  getcurrentdta(dtaseg,dtaofs,error);
  IF (error<>0 ) THEN
  BEGIN
    WRITELN('unable to get current dta');
    WRITELN('program aborting');
    HALT;
  END;
  setdtaseg:=SEG(dta);
  setdtaofs:=OFS(dta);
  setdta(setdtaseg,setdtaofs,error);
  IF (error<>0) THEN
  BEGIN
    WRITELN('Cannot reset dta');
    WRITELN('Program aborting');
    HALT;
  END;
  error:=0;
  buffer[0]:=CHR(0);
  option:=22;
  buffer:='????????.???';
  FOR i:=1 TO LENGTH(buffer) DO
    mask[i]:=buffer[i];
  getfirst(mask,namr,setdtaseg,setdtaofs,option,error);
  IF (error=0) THEN
  BEGIN
    GETDIR(0,sub);
    GOTOXY (27,15);
    WRITE (' ':50);
    GOTOXY (27,15);
    TEXTATTR := 7;
    WRITELN (sub);
    TEXTATTR := 15;
    print_listings
  END;
  WHILE (error=0) DO
  BEGIN
    getnextentry(namr,setdtaseg,setdtaofs,option,error);
    IF (error=0) THEN
    BEGIN
      print_listings;
      IF (att AND $10 <>0) AND (namr <>('..'+CHR(0))) THEN
      BEGIN
        num:=num+1;
        IF num > max_dir THEN
        BEGIN
          CLRSCR;
          GOTOXY (5,10);
          WRITELN ('########  PROGRAM HALTED #########');
          WRITELN;
          WRITELN ('MAXIUMUM NUMBER OF DIRECTORIES [',
                        max_dir,'] EXCEEDED');
          WRITELN ;
          WRITELN ('Cannot Use this program - sorry ');
          CHDIR (origdir);
          HALT;
        END;
        GETDIR(0,sub);
        IF sub[LENGTH(sub)] <> '\' THEN sub:=sub+'\';
            subdir[num]:=sub+namr;
        DELETE (subdir[num],LENGTH(subdir[num]),1) {get rid of
                                terminal chr(0) }
      END
    END
  END;
  setdta(dtaseg,dtaofs,error);
END;


{Quicksort in Turbo Pascal}

PROCEDURE sort(bottom,top: INTEGER);
VAR lower_ptr, upper_ptr: INTEGER;
      middle_element, temp: file_record;

BEGIN
  lower_ptr := bottom;
  upper_ptr :=top;
  middle_element := file_catalog[(bottom+top)DIV 2] ;
  REPEAT
    WHILE file_catalog[lower_ptr].name <
              middle_element.name DO lower_ptr := lower_ptr + 1;
    WHILE middle_element.name <
          file_catalog[upper_ptr].name DO upper_ptr := upper_ptr - 1;
    IF lower_ptr <= upper_ptr THEN
    BEGIN
      temp := file_catalog[lower_ptr];
      file_catalog[lower_ptr]:= file_catalog[upper_ptr];
      file_catalog[upper_ptr] := temp;
      lower_ptr := lower_ptr + 1;
      upper_ptr := upper_ptr - 1;
    END;
  UNTIL lower_ptr > upper_ptr;
  IF bottom < upper_ptr THEN sort(bottom,upper_ptr);
  IF lower_ptr < top THEN sort(lower_ptr,top);
END;

PROCEDURE header;

BEGIN
  IF opt=1 THEN WRITE (dev,'Directory list for all files.',' ':15)
     ELSE
  IF opt=2 THEN WRITE (dev,'Directory list for duplicate files.',' ':9)
     ELSE     WRITE (dev,'Directory list for files by selected date',' ':3);
  time;
  WRITELN (dev,'   Page ',pagenum:3);
  pagenum:=pagenum+1;
  WRITELN (dev,'* = Sub dir: A = Archive bit on: R = Read only: ',
               'H = Hidden: S = System');
  WRITELN (dev);
  WRITELN (dev,' ':6,'Files',' ':10,'Directory',' ':12,'Date',' ':6,'Time',
            ' ':8,'Size');
  WRITELN (dev);
  linecount:=5;
END;

PROCEDURE checkcount;

BEGIN
  IF linecount = end_page THEN
  BEGIN
    IF NOT printer THEN
    BEGIN
      WRITE (dev,' ':35,'-MORE-');
      REPEAT UNTIL KEYPRESSED;
      ch := READKEY;
      CLRSCR
    END
    ELSE
    BEGIN
      GOTOXY (8,17);
      WRITE (' ':67);
      GOTOXY (8,17);
      WRITE ('Page #',pagenum:3,' ');
      WRITELN (dev,CHR(12));
    END;
    header;
  END;
  IF printer THEN WRITE ('.');
END;


PROCEDURE print_data1;
VAR
  count:INTEGER;
  am:STRING[2];

BEGIN
  TEXTATTR := 7;
  WITH file_catalog[i] DO
  BEGIN
    count:=0;
    IF (attribute AND $01)<>0 THEN
    BEGIN
      count:=count+1;
      WRITE (dev,'R');
    END;
    IF (attribute AND $02)<>0 THEN
    BEGIN
      count:=count+1;
      WRITE (dev,'H');
    END;
    IF (attribute AND $04)<>0 THEN
    BEGIN
      count:=count+1;
      WRITE (dev,'S');
    END;
    IF (attribute AND $08)<>0 THEN
    BEGIN
      count:=count+1;
      WRITE (dev,'V');
    END;
    IF (attribute AND $10)<>0 THEN
    BEGIN
      count:=count+1;
      WRITE (dev,'*');
    END;
    IF (attribute AND $20)<>0 THEN
    BEGIN
      count:=count+1;
      WRITE (dev,'A');
    END;
    WRITE (dev,' ':6-count);
    WRITE (dev,name,' ':15-LENGTH(name),
          subdir[catalog],' ':20-LENGTH(subdir[catalog]));
    IF LENGTH (subdir[catalog]) > 19 THEN
    BEGIN
      WRITELN (dev);
      linecount:=linecount+1;
      checkcount;
      WRITE (dev,' ':41);
    END;
    am:='pm';
    IF file_hour <12 THEN am:='am';
    IF file_hour >12 THEN file_hour :=file_hour-12;
    IF file_hour=0 THEN file_hour :=12;
    WRITE (dev,file_month:2,'-');
    IF file_day >9 THEN WRITE (dev,file_day:2)
    ELSE
    WRITE (dev,'0',file_day:1);
    WRITE (dev,'-',file_year:2,'  ',file_hour:2,':');
    IF file_min >9 THEN WRITE (dev,file_min:2)
    ELSE
    WRITE (dev,'0',file_min:1);
    WRITELN  (dev,am,' ',file_size:10:0);
    linecount:=linecount+1;
    TEXTATTR := 15;
    checkcount;
  END;
END;



PROCEDURE print_data;
VAR
  oklast:BOOLEAN;

BEGIN
  oklast:=FALSE;
  FOR i:=1 TO index DO
  WITH file_catalog[i] DO
  BEGIN
    IF opt <>2 THEN print_data1;
    IF i<>index THEN ok:= ((opt=2) AND (name=file_catalog[i+1].name))
       ELSE ok:= FALSE;
    IF ok THEN print_data1;
    IF oklast AND NOT ok THEN
    BEGIN
      print_data1;
      WRITELN (dev);
      linecount:=linecount+1;
      checkcount;
    END;
    oklast:=ok;
  END;
END;

PROCEDURE boarder;
VAR
  block : CHAR;

BEGIN
  BLOCK := CHR(176);
  GOTOXY (1,1);
  FOR i:= 1 TO 79 DO
    WRITE (block);
  GOTOXY (1,25);
  FOR i:= 1 TO 79 DO
    WRITE (block);
  GOTOXY( 1,2);
  FOR i:= 1 TO 24 DO
  BEGIN
    GOTOXY (1,i);
    WRITE (block,block);
    GOTOXY (78,i);
    WRITE (block,block);
  END;
END;

PROCEDURE introduction;
VAR
  ch:CHAR;
  logdrive:STRING[3];

BEGIN
  pagenum:=1;
  CLRSCR;
  boarder;
  GOTOXY (5,3);
  WRITELN ('DIR\SUBDIRECTORY LISTER PROGRAM');
  WRITELN;
  GOTOXY (5,7);
  WRITELN ('OPTIONS');
  TEXTATTR := 7;
  GOTOXY (10,9);
  WRITELN (' 1 -  List ALL files on the disk');
  GOTOXY (10,10);
  WRITELN (' 2 -  List only DUPLICATE files on the disk');
  GOTOXY (10,11);
  WRITELN (' 3 -  List files DATED on/or after mm/dd/yy');
  GOTOXY (10,12);
  WRITELN (' 4 -  Exit');
  GOTOXY (6,20);
  WRITELN ('For output on printer  - enter (P) prior to number option');
  GOTOXY (6,21);
  WRITELN ('To change to new drive - enter (L) prior to number option');
  GOTOXY (12,24);
  WRITE ('(C) The Catalog Company 1985 - Public Domain Release');
  printer:=FALSE;
  TEXTATTR := 15;
  GOTOXY (38,20);
  WRITE ('P');
  GOTOXY (38,21);
  WRITE ('L');
  GETDIR(0,logdrive);
  REPEAT
    GOTOXY (60,3);
    TEXTATTR := 7;
    WRITE ('Drive : = ');
    TEXTATTR := 15;
    WRITE (logdrive);
    GOTOXY (6,14);
    WRITE ('OPTION <1-4>: ');
    REPEAT UNTIL KEYPRESSED;
    ch := READKEY;
    IF ch IN ['p','P'] THEN printer:=NOT printer;
    IF ch IN ['l','L'] THEN
    BEGIN
      GOTOXY (6,15);
      WRITE ('New Drive (A..Z) ');
      REPEAT UNTIL KEYPRESSED;
      ch:=UPCASE(READKEY);
      IF ch IN ['A'..'Z'] THEN
      BEGIN
        CHDIR(ch+':\');         {runtime error if drive not ready - DSMB }
        WRITE (ch,':');
        GETDIR(0,logdrive);
      END;
    END;
    GOTOXY (6,15);
    WRITE (' ':64);
    opt:=ORD(ch)-48;
    IF opt<0 THEN opt:=0; {line added to prevent trouble 2 lines below - DSMB }
    GOTOXY (20,14);
    IF opt IN [1..4] THEN WRITE (opt);
    GOTOXY (21,14);
    IF printer THEN WRITE (' - PRINTER ACTIVE') ELSE WRITE (' ':25);
  UNTIL opt IN [1..4];
  IF opt = 4 THEN EXIT;
  IF opt = 3 THEN
  {$I-}
  BEGIN
    REPEAT
      TEXTATTR := 7;
      GOTOXY (6,15);
      WRITE (' ':30);
      GOTOXY (6,15);
      WRITE ('MONTH [01-12] ');
      READLN (scan_month)
    UNTIL (scan_month IN [01..12]) AND (ioresult =0);
    REPEAT
      GOTOXY (6,15);
      WRITE (' ':30);
      GOTOXY (6,15);
      WRITE ('DAY [01-31] ');
      READLN (scan_day)
    UNTIL (scan_day IN [01..31]) AND (ioresult =0);
    REPEAT
      GOTOXY (6,15);
      WRITE (' ':30);
      GOTOXY (6,15);
      WRITE ('YEAR [80-99] ');
      READLN (scan_year)
    UNTIL (scan_year IN [80..99]) AND (ioresult =0);
    {$I+}
    ok_date:= (scan_year-80)*365+scan_month*31+scan_day;
  END;
  TEXTATTR := 15;
  IF printer THEN
  BEGIN
    ASSIGN (dev,'PRN');
    end_page:=60;
  END
  ELSE
  BEGIN
    ASSIGNCRT (dev);
    end_page:=24;
  END;
  REWRITE(dev);
  GOTOXY (6,15);
  WRITE (' ':64);
  GOTOXY (6,15);
  WRITE ('Reading Directory of ');
END;


BEGIN
  GETDIR(0,origdir);
  REPEAT
    CHDIR ('\');
    introduction;
    IF opt <> 4 THEN
    BEGIN
      GETDIR(0,namr);
      subdir[1]:=namr;
      dir1:='.'+CHR(0);
      dir2:='..'+CHR(0);
      num:=1;
      index:=1;
      loop:=1;
      getinfo;
      num1:=2;
      num2:=num;
      IF num<>1 THEN
      REPEAT
        FOR loop:=num1 TO num2 DO
        BEGIN
          CHDIR(subdir[loop]);
          getinfo;
        END;
        IF num2<>num THEN
        BEGIN
          ok:=FALSE;
          num1:=num2+1;
          num2:=num;
        END
        ELSE ok:=TRUE;
      UNTIL ok;
      index:=index-1;
      GOTOXY (6,15);
      WRITE (' ':64);
      GOTOXY (6,15);
      WRITELN ('Sorting ');
      IF index>0 then     { line inserted to prevent error 201 in sort - DSMB }
       sort(1,index);
      GOTOXY (6,16);
      WRITE ('Printing ');
      GOTOXY (8,17);
      WRITE ('Page #',pagenum:3,' ');
      IF NOT printer THEN CLRSCR;
      header;
      print_data;
      WRITELN;
      IF linecount +2 >= end_page THEN
      BEGIN
        linecount:=end_page;
        checkcount;
      END;
      WRITE (dev,' ':6,'Number of dir/subdir : ',num,' ':12,'Number of files : ');
      IF opt <> 3 THEN WRITELN (dev,index-num+1)
              ELSE WRITELN (dev,index);
      IF printer THEN
      BEGIN
        GOTOXY (1,24);
        WRITELN (dev,CHR(12));
      END
      ELSE
      BEGIN
        linecount:=linecount+1;
        checkcount;
        WRITE (dev,' ':35,'-DONE-');
        REPEAT UNTIL KEYPRESSED;
        ch := READKEY;
        CLRSCR;
      END;
    END
    ELSE
    BEGIN
      CHDIR (origdir);
      GOTOXY (1,24);
    END;
  UNTIL opt = 4;
  CLRSCR
END.

