                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Program to check communications adapter settings. Sets the mode of
operation of COM1 to 2400 baud, no parity, 8 databits, and 1 stopbit.
Author John Roberts. Version T1.0.

* ASSOCIATED FILES
COMMCHK.PAS
COMMCHK.DOC

* KEYWORDS
TURBO PASCAL V4.0 COM COMMUNICATIONS PARITY BIT

==========================================================================
}
PROGRAM COMMUNICATIONS_PORT_CHECKER;
{----------------------------------------------}
PROCEDURE UNCODE_SETUP_OF_PORT(NR: INTEGER);
   VAR
      B,M,V1,V2,TLRC,D,MSB,LSB: INTEGER;
      S,C0: INTEGER;
      BAUD: REAL;
      ANSWER: STRING[10];
   BEGIN
     CASE NR OF  {PORT ADDRESSES OF THE UARTS.}
       1: C0:=$03F8; {1016}
       2: C0:=$02F8; {760}
       3: C0:=$03E8; {1000}
       4: C0:=$02E8; {744}
       ELSE
          BEGIN
            WRITELN('NOT PROGRAMMED TO HANDLE PORT ',NR);
            HALT;
          END;
       END; {CASE}
     S:=PORT[C0+3];
     TLRC:=PORT[C0+3];
     PORT[C0+3]:=TLRC OR $80; {NECESSARY IN ORDER TO READ C0, C0+1}
     LSB:=PORT[C0];
     MSB:=PORT[C0+1];
     D:=256*MSB+LSB;
     BAUD:=115200.0/D;
     WRITELN;
     PORT[C0+3]:=TLRC AND $7F; {RESTORES "LATCH" AFTER READ}
     WRITE('COMM PORT NUMBER ',NR,': ');
     IF BAUD<=0 THEN
        BEGIN
           WRITELN(' NOT INSTALLED ');
           EXIT;
        END
     ELSE
        WRITELN;
     WRITELN('  TRANSMISSION SPEED: ',BAUD:5:0);
     IF S AND 3 = 3 THEN B:=8
     ELSE IF S AND 2 = 2 THEN B:=7
     ELSE IF S AND 1 = 1 THEN B:=6
     ELSE B:=5;
     WRITELN(B:5,' DATA BITS');
     IF S AND 4 = 4 THEN B:=2 ELSE B:=1;
     WRITELN(B:5,' STOP BITS');
     IF S AND 24=24 THEN ANSWER:='EVEN'
     ELSE IF S AND 8 = 8 THEN ANSWER:='ODD' ELSE ANSWER:='NO';
     WRITELN('  PARITY: ',ANSWER);
   END;
{-------------MAIN PROGRAM-------------------}
BEGIN
  UNCODE_SETUP_OF_PORT(1);
  UNCODE_SETUP_OF_PORT(2);
  UNCODE_SETUP_OF_PORT(3);
  UNCODE_SETUP_OF_PORT(4);
END.

