{
                       F i l e    I n f o r m a t i o n 

* DESCRIPTION
Program to test the virtual array unit VIRTUAL.TPU. Requires TPRARRAY.TPU
and TPVARRAY.TPU from Turbo Professional 4.0 by TurboPower Software.
Author: R. Jones.

* ASSOCIATED FILES
VIRTUAL.PAS
TESTVIRT.PAS

* KEYWORDS TURBO PASCAL V4.0 ARRAY RAM DISK 
========================================================================== } 
program TestVirtualArray; 

{
  Program to test the virtual array unit "VIRTUAL.TPU".  This unit and
  this program both require Turbo Professional 4.0 by TurboPower Software.
  Refer to their outstanding manual for complete details regarding
  Turbo Professional array handling (408-438-8608).  (I have no affiliation
  with them, I simply enjoy using their product.)

  Change the values for MaxR and MaxC to have the unit VIRTUAL.TPU
  automatically select either RAM-only (for smaller values) or RAM/disk
  virtual arrays.  For example a 3,000 by 10 array will require 180k
  of disk space.  The default 30 x 10 array only 1.8k RAM.

  Author:  Robert L. Jones
           4521 Campus Drive, #111
           Irvine, CA  92715

  CompuServe User ID 71251,2566

  Released to the public domain 9/5/88.
}

USES tpRarray, tpVarray, virtual, dos;

CONST
  MaxR = 30;                        { array row maximum }
  MaxC = 10;                        { array column maximum }
  FName : string = 'AnyName.xxx';   { change to '' to have unit supply names }

VAR
  value : real;      { used to provide input/output from large arrays }
  VR : VirtualRec;   { define a new VirtualRec for each array }
  i  : integer;
  s  : searchrec;

BEGIN
  WriteLn('available RAM at start of program:     ',longint (MemAvail));

  IF MakeRealArray (VR, MaxR, MaxC, FName) THEN

    BEGIN
      WriteLn('available RAM after requesting array:  ',longint (MemAvail));

      { demo setting a particular element of the array to 1.0 }
      value := 1;
      WriteLn('setting element (',MaxR-1,',',MaxC-1,') = ',value:1:3);

      IF (VR.UH) THEN
          tpRarray.SetA(VR.A, MaxR-1, MaxC-1, value)
      ELSE
        BEGIN
          tpVarray.SetA(VR.A, MaxR-1, MaxC-1, value);

          { a file must have been created on disk, find it & its size }
          FindFirst(VR.FName,$3F,s);
          IF (DosError = 0) THEN
             WriteLn(VR.FName,' contains ',s.size,' bytes');
        END;

      { demo saving arrays }
      IF (SaveArray (VR, TRUE)) THEN
        BEGIN
          WriteLn('Data successfully saved in file ',FName);
          WriteLn('File is a large RAM-only array: ',VR.UH);
        END
      ELSE WriteLn('Data not saved');
      WriteLn;

      { illustrates how to locate specific items within the array }
      WriteLn('here are the final 10 sample elements:');
      for i := MaxC-10 to MaxC-1 do
        BEGIN
          IF (VR.UH) THEN tpRarray.RetA(VR.A, MaxR-1, i, value)
                     ELSE tpVarray.RetA(VR.A, MaxR-1, i, value);
          WriteLn(value:12:1);
        END;

      { demo disposing of arrays }
      IF DisposeArray (VR, FALSE) THEN { a do nothing example };
      WriteLn;

      { demo the loading of a previously stored file }
      IF (LoadArray (FName,VR)) THEN
        WriteLn('Data successfully loaded from file ',FName)
      ELSE
        WriteLn('Data not loaded');
      WriteLn;

      { again remove array from memory/disk }
      IF DisposeArray (VR, TRUE) THEN
         WriteLn('Disposed file:  ',VR.FName)
      ELSE WriteLn('Unable to dispose file:  ',VR.FName);
      WriteLn('available RAM after disposing of array:  ',longint (MemAvail));
      WriteLn;
    END   { of MakeRealArray = TRUE }

  { program detects < 1024 bytes of available RAM during MakeRealArray call }
  ELSE
    WriteLn('insufficient memory to create virtual array');
END.
