{
                       F i l e    I n f o r m a t i o n 

* DESCRIPTION
SOUNDEX.PAS - This unit contains one function, SoundexCode, that returns
the Soundex code of a string. The Soundex code may then be compared with
other codes to find words that have similar pronunciations. Author: Eric
Krammerer, Version: 1.1, Turbo Pascal 4.0.

* ASSOCIATED FILES
SOUNDEX.PAS
DEMO.EXE
DEMO.PAS
SOUNDEX.TXT


* KEYWORDS
TURBO PASCAL V4.0 SOUND UNIT CONVERT STRING

==========================================================================
}
{---------------------}
{ (C) Copyright 1988  }
{  by Eric Kammerer   }
{ All Rights Reserved }
{---------------------}

UNIT Soundex;

{

    Description     :   This unit contains one function, SoundexCode,
                        that returns the Soundex code of a string.  The
                        Soundex code may then be compared with other
                        codes to find words that have similar
                        pronunciations.

    Author          :   Eric Kammerer

    Date Written    :   May 29, 1988

    Distribution    :   Public Domain

    Version         :   1.1

}

{------------------------------------- REVISIONS ----------------------}

{
    Version    Date           Description
    -------    ---------      ------------------------------------------
    1.0        22May1988      Initial Version
    1.1        29May1988      Fix incorrect assignment of first code
                              character.  Optimize for speed/space.

}

{------------------------------------- DIRECTIVES ---------------------}

{$B-}   {Default to short-circuit boolean evaluation}
{$F-}   {Automatic choice of call model}
{$I-}   {No automatic I/O result checking}
{$R-}   {Do not generate range-check code}
{$S-}   {Do not generate stack-overflow-check code}
{$V-}   {No strict type checking of VAR-strings}

{------------------------------------- INTERFACE ----------------------}

INTERFACE

TYPE

   CodeString = STRING[4];

FUNCTION SoundexCode (CodeWord : STRING) : CodeString;

{

    Description     :   Converts a string into a soundex code.

    Author          :   Eric Kammerer

    Date Written    :   May 22, 1988

    Inputs          :   CodeWord -- The string to be converted.  This
                                    must be an alphabetic string.
                                    Non-alphabetic characters will be
                                    ignored.  Completely invalid values
                                    will cause a value of '0000' to be
                                    returned by the function.  Note that
                                    '0000' is not neccessarily an error,
                                    short words may also return this
                                    value (e.g. 'a', 'I', 'oh').

    Returns         :   A four-character soundex code.

}

{------------------------------------- COPYRIGHT ----------------------}

CONST

    Copyright = '(C)Copyright 1988 by Eric Kammerer';

{------------------------------------- IMPLEMENTATION -----------------}

IMPLEMENTATION

FUNCTION SoundexCode (CodeWord : STRING) : CodeString;

VAR

   Current,                               {Current position in CodeWord}
   Location : BYTE;                         {Current position in result}
   Temp     : CHAR;                    {Converted character from string}

CONST

   ConversionTable : ARRAY ['B' .. 'Z'] OF CHAR
                   = (
                        '1', '2', '3', '0', '1',   {'B' .. 'F'}
                        '2', '0', '0', '2', '2',   {'G' .. 'K'}
                        '4', '5', '5', '0', '1',   {'L' .. 'P'}
                        '2', '6', '2', '3', '0',   {'Q' .. 'U'}
                        '1', '0', '2', '0', '2'    {'V' .. 'Z'}
                     );

BEGIN

   SoundexCode := '0000';

   Current := 1;
   Location := 1;

   WHILE (
            (Current <= Length (CodeWord)) AND
            (Location <= 4               )
   ) DO BEGIN
      Temp := UpCase (CodeWord [Current]);
      IF (
            (Temp IN ['B' .. 'Z']) AND
            (NOT (Temp IN ['E', 'H', 'I', 'O', 'U', 'W', 'Y']))
      ) THEN BEGIN
         IF Location <> 1 THEN BEGIN
            IF (Temp <> (Upcase (CodeWord [Current - 1]))) THEN BEGIN
               SoundexCode [Location] :=ConversionTable [Temp];
               Location := Location + 1;
            END;
            END
         ELSE
            BEGIN
            SoundexCode [1] := Temp;
            Location := Location + 1;
         END;
      END;
      Current := Current + 1;
   END;

END;

END.

{---------------------}
{ (C) Copyright 1988  }
{  by Eric Kammerer   }
{ All Rights Reserved }
{---------------------}

