{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with LCU.PAS.

* ASSOCIATED FILES
LCU.PAS
COLORS.PAS
DRVPARMS.PAS
ERRPROCS.PAS
FILEFCNS.PAS
LCU.DOC
LCU.FFF
LCU.TPM
MEMCOMP.ASM
MEMCOMP.OBJ
MEMCOMP.PAS

}
{$R-}    {Range checking off}
{$B-}    {Boolean complete evaluation off}
{$S-}    {Stack checking off}
{$N-}    {No numeric coprocessor}
{$I-}    {IO Checking Off}
{$D-}
{$T-}

unit DrvParms;
{JW Sparks, last modified 6/30/88}

interface
uses dos;

type
   DriveType       = (HardDisk, EightSect, DSDD, SSDD, HiDensity, Unknown);
   DriveNameType   = string[30];

   DriveSpecification = Record
      DriveNum  : Integer;
      DriveType : DriveType;
      Fixed     : Boolean;
      DriveSize : longInt;
      DriveName : DriveNameType;
      end;


Procedure DosGetDriveParms(var DrSp : DriveSpecification;
                           var IO_Error:Integer);
implementation

Procedure DosGetDriveParms(var DrSp : DriveSpecification;
                           var IO_Error:Integer);
var
   DtypeNum : Integer;
   Regs     : Registers;

begin
with Regs do       { Use DOS function $1C}
begin
{AX = Sectors per cluster}
{DS:BX = Identification Byte, where
         0F8H = Hard Drive, 0FCh through 0FEh = Floppy}
{CX = Bytes per sector}
{DX = Clusters per drive}

AX := $1C00;
DX := DrSp.DriveNum;
MSDos(Regs);

DrSp.Fixed := False;
if (AX = $FFFF) then
      begin
      IO_Error := AX;
      DrSp.DriveType := Unknown  ;
      DrSp.DriveSize := 0;
   end
else
   DrSp.DriveSize :=  DX * Lo(AX);
   DrSp.DriveSize := DrSp.DriveSize * CX;
   DTypeNum := Mem[DS:BX];
   IO_Error := 0;
end; {with}

Case DTypeNum of
$F8 : begin
      DrSp.DriveType := HardDisk;
      DrSp.DriveName := 'Hard Disk';
      DrSp.Fixed := TRUE;
      end;

$FE : begin
      DrSp.DriveType := EightSect;
      DrSp.DriveName := 'Floppy Disk (8)';
      end;

$FD : begin
      DrSp.DriveType := DSDD;
      DrSp.DriveName := 'Floppy Disk (DSDD)';
      end;

$FC : begin
      DrSp.DriveType := SSDD;
      DrSp.DriveName := 'Floppy Disk (SSDD)';
      end;

$F9 : begin
      DrSp.DriveType := HiDensity;
      DrSp.DriveName := 'Floppy Disk (High Capacity)';
      end;

else  begin
      DrSp.DriveType := Unknown;
      DrSp.DriveName := 'Unknown Drive Type';
      end;

end; {Case}

end;

{***}

end.

