{ XORPIC.PAS }

{
Description:  Program to demonstrate the use of the XOR function when
              displaying graphics.

Author:       Abi Wong
Date:         2/18/87
Last revised: 02/27/1989  13:10:28
Application:  IBM PC and compatibles; Turbo Pascal 3.0/4.0/5.0

}
{

XorPic is compatible with the PUTPIC and GETPIC

   Syntax: XorPic(Buffer,X,Y)  (Top Left conner is 0,0)

   Copies the contents of the variable Buffer onto a rectangular area on the
   screen. The integer expressions X and Y define the lower left-hand corner
   of the picture area. The present routine is written for HIRES mode
   only. It should not be difficult to modify it for GraphMode or GraphColorMode.
   The routine does not check if the Buffer data has been stored for Hires mode,
   but this can be done by checking If Buffer[0]=1 (Ref: Turbo 3.0 manual,
   p.174).

   There are a few bugs in PUTPIC:
   - when X is negative then we should expect to go up one line, but PutPic
     goes up two lines instead.
   - when X is negative and Y is below the screen (i.e., >199) then PutPic will
     ignore the line 198,199 even when Y goes up to within the screen:

             197 --------->xxxxxxxxxx
             198           xxxxxxxxxx <---- This 2 lines will disappear if X
             199           xxxxxxxxxx <----   is negative
             200           xxxxxxxxxx
        line 201---------->xxxxxxxxxx

    in order to maintain compatibility, all these bugs are implemented!      }

Program XORGRAPH;
{ Remain bits are stored but not used }

{ *** Delete next line for use with TP 3.0 *** }
USES Crt, Graph3;

TYPE
  Array_type=ARRAY [0..16384] OF BYTE;
VAR
  BUFFER: ARRAY_TYPE;
  I,J   : INTEGER;
  Screen: ARRAY[0..16383] OF BYTE ABSOLUTE $B800:0;
  A     : CHAR;

{ *** Delete next line for use with TP 4.0/5.0 *** }
{$I GRAPH.P}

PROCEDURE XorPic( Var Buf:ARRAY_TYPE ;X,Y:INTEGER);
VAR
    Data,  Hor_Address, Address, Bit_To_Shift,
      WIDTH, TALL, Byte_Width, I, J , Hor_Limit ,Y_Limit   : INTEGER;

    REMAIN, Last_Mask                                      : BYTE;

BEGIN
IF X>-(Buf[2]+ Buf[3] SHL 8) THEN

              {  *********************************************************
                 *  For some unknown reason GRAPH.P has this limitation: *
                 *  If you delete this IF statement you can let X take   *
                 *  on any value.                                        *
                 ******************************************************* }
BEGIN

Hor_Limit:=((Y SHR 1)+1)*80;
IF X>=0 THEN Y_Limit:=200 ELSE Y_Limit:=198;
WHILE X<0 DO BEGIN X:=X+640; Y:=Y-2; END;  {if X is negative go back one line}

          {    *********************************************************
               *  It is more logical to have Y:=Y-1. However there is  *
               *  a bug in PUTPIC; in order to remain compatible with  *
               *  PUTPIC, Y:=Y-2 is used here.                         *
               ********************************************************* }

IF Y>=0  THEN   {if bottom is over the top nothing to disp}
BEGIN
  Bit_To_Shift:=8-(X AND 7);
  Hor_Address:=((Y SHR 1) * 80) + X SHR 3;
  Width:=Buf[2]+Buf[3] SHL 8;
  TALL:=BUF[4]+Buf[5] SHL 8;
  Byte_Width:=Width SHR 3;
  Last_Mask:=$FF SHL (8-(Width AND 7)); {Mask of last byte}
  IF TALL>Y THEN TALL:=SUCC(Y);
  J:=6;                                {1st byte position after header}
  WHILE TALL>0 DO
  BEGIN
    IF ODD(Y) THEN Address:=$2000+Hor_Address ELSE Address:=Hor_Address;
    Remain:=0;
    FOR I:=1 TO Byte_Width DO
    BEGIN
      IF ((Address AND $1FFF)  < Hor_Limit) AND (Y<Y_Limit) THEN
                      {If out of Limit then don't update the Screen}
      BEGIN
        Data:=Buf[J] SHL (Bit_To_Shift);
        Screen [Address]:=Screen [Address] XOR (Remain or (HI(Data)) );
        Remain:=LO(Data);
      END;
      Address:=SUCC(Address);
      J:=SUCC(J);
    END;
    IF (Last_Mask<>0) THEN
    BEGIN
      IF ((Address AND $1FFF) < Hor_Limit) AND (Y<Y_Limit) THEN
      BEGIN
        Data:=(Buf[J] AND Last_Mask) SHL (Bit_To_Shift);
        Screen [Address]:=Screen [Address] XOR (Remain or (HI(Data)));
      END;
      Address:=SUCC(Address);
      J:=SUCC(J);
    END;
    IF (LO(Data)<>0) AND ((Address AND $1FFF) < Hor_Limit) AND (Y<Y_Limit) THEN
         Screen[Address]:=Screen [Address] XOR (LO(Data));
    Y:=PRED(Y);
    TALL:=PRED(TALL);
    IF ODD(Y) THEN
    BEGIN
      Hor_Address:=Hor_Address-80; Hor_Limit:=Hor_Limit-80;
    END;
  END;
END;
END;
END;

{ Here is just an example showing how the XORPIC clears the PUTPIC. Both
  coordinates are set out of limits to check for compatibility.}

BEGIN
  HIRES;
  GOTOXY(1,1);WRITE('AB');
  DRAW(0,7,200,7,1);
  GETPIC(Buffer,0,0,13,7);
  FOR J:=-1 TO 201 DO
  BEGIN
   FOR I:= -14 to 639 do
   BEGIN
     PUTPIC(Buffer,i,J);
     XORPIC(Buffer,i,J);
     IF KEYPRESSED THEN HALT;
   END;
  END;
END.

