{ FXORPIC.PAS }

{
Description:  Program to demonstrate the use of the XOR function when
              displaying graphics. This version uses an external (binary)
              XorPic function for better performance.

Author:       Abi Wong
Date:         2/18/87
Last revised: 02/27/1989  11:12:13
Application:  IBM PC and compatibles; Turbo Pascal 3.0

}


{

XorPic is compatible with the PUTPIC and GETPIC

   Syntax: XorPic(Buffer,X,Y)  (Top Left conner is 0,0)

   Copies the contents of the variable Buffer onto a rectangular area on the
   screen. The integer expressions X and Y define the lower left-hand corner
   of the picture area. The present routine is written for HIRES mode
   only. It should not be difficult to modify it for GraphMode or GraphColorMode.
   The routine does not check if the Buffer data has been stored for Hires mode,
   but this can be done by checking If Buffer[0]=1 (Ref: Turbo 3.0 manual,
   p.174).

   There are a few bugs in PUTPIC:
   - when X is negative then we should expect to go up one line, but PutPic
     goes up two lines instead.
   - when X is negative and Y is below the screen (i.e., >199) then PutPic will
     ignore the line 198,199 even when Y goes up to within the screen:

             197 --------->xxxxxxxxxx
             198           xxxxxxxxxx <---- This 2 lines will disappear if X
             199           xxxxxxxxxx <----   is negative
             200           xxxxxxxxxx
        line 201---------->xxxxxxxxxx

    in order to maintain compatibility, all these bugs are implemented!      }

Program XORGRAPH;
{ Remaining bits are stored, but not used }

VAR
  BUFFER: ARRAY[0..1023] OF BYTE;
  I,J   : INTEGER;
  A     : CHAR;

{$I GRAPH.P}
PROCEDURE XorPic( Var Buf ;X,Y:INTEGER); EXTERNAL 'XORPIC.BIN';

{ Here is just an example showing how XORPIC clears the PUTPIC. Both
  coordinates are set to out of limits, to check for compatibility.}

BEGIN
  HIRES;
  GOTOXY(1,1);WRITE('AB');
  DRAW(0,7,200,7,1);
  GETPIC(Buffer,0,0,13,9);
  FOR J:=-1 TO 201 DO
  BEGIN
   FOR I:= -14 to 639 do
   BEGIN
     PUTPIC(Buffer,i,J);
     XORPIC(Buffer,i,J);
     IF KEYPRESSED THEN HALT;   {Press any key to abort the test}
   END;
  END;
END.

