{ KBDSTUF.PAS }

UNIT KbdStuf;

{
Description:  PC-specific keyboard routines

Author:       Don Taylor
Date:         6/14/87
Last revised: 10/06/1988  13:29:21
Application:  IBM PC and compatibles
}


{--------------------}
     INTERFACE
{--------------------}

USES
 Dos;          { Built-in DOS interface routines                  }


CONST  { Public Constants }
 Bell          =   #7; { ASCII bell character                    }
 BS            =   #8; { ASCII backspace character               }
 LF            =  #10; { ASCII line feed character               }
 FF            =  #12; { ASCII form feed character               }
 CR            =  #13; { ASCII carriage return                   }
 Esc           =  #27; { ASCII Escape character                  }

 LtArrKey      = #203; { Left  arrow key on PC keyboard          }
 RtArrKey      = #205; { Right arrow key on PC keyboard          }
 PgUpKey       = #201; { PgUp key on PC keyboard                 }
 PgDnKey       = #209; { PgDn key on PC keyboard                 }
 HomeKey       = #199; { Home key on PC keyboard                 }
 EndKey        = #207; { End key on PC keyboard                  }
 UpKey         = #200; { Up   arrow key on PC keyboard           }
 DownKey       = #208; { Down arrow key on PC keyboard           }

 BellVal       =    7; { Value of bell character                 }
 BSVal         =    8; { Value of backspace character            }
 LFVal         =   10; { Value of line feed character            }
 FFVal         =   12; { Value of form feed character            }
 CRVal         =   13; { Value of carriage return                }
 ESCVal        =   27; { Value of Escape character               }
 LArrVal       =  203; { Value of left arrow on PC keyboard      }
 RArrVal       =  205; { Value of right arrow on PC keyboard     }


FUNCTION ReadExtKey : CHAR;                  { Read extended key }

{--------------------}
   IMPLEMENTATION
{--------------------}


FUNCTION ReadExtKey : CHAR;

{ Read a key from the keyboard with no echo.                        }
{ Modifies values of extended codes by adding 128 to them.          }

CONST
 KbdIntr    = $16;    { BIOS keyboard interrupt           }
 ReadNextFn =   0;    { BIOS read next keyboard character }

VAR
 DOSRec : Registers;
 KeyVal : INTEGER;

BEGIN
 WITH DOSRec DO
  BEGIN
   AH := ReadNextFn;
   INTR(KbdIntr, DosRec);
   IF AL = 0
    THEN KeyVal := AH + 128
    ELSE KeyVal := AL;
  END; { WITH }
 ReadExtKey := CHR(KeyVal)
END; { ReadExtKey }


{====================}
{   INITIALIZATION   }
{====================}

BEGIN { UNIT KbdStuf }
END.  { UNIT KbdStuf }

