{ DOSSTUF.PAS }
{
Description:  Extended DOS interface routines

Author:       Michael Burton and Don Taylor
Date:         12/14/87
Last revised: 10/06/1988  11:34:54
Application:  IBM PC and compatibles; Turbo Pascal 4.0
}

UNIT DOSStuf;

{--------------------}
     INTERFACE
{--------------------}

USES
 Dos;                   { Built-in DOS interface routines                    }

FUNCTION GetEnv(st : STRING) : STRING;

{--------------------}
   IMPLEMENTATION
{--------------------}

FUNCTION GetEnv(st : STRING) : STRING;

CONST
 PrefixSegOfs = $2C;    { Offset to environment segment address in PSP       }

VAR
 tmpst  : STRING;
 envseg : WORD;
 i      : INTEGER;

BEGIN
 envseg := MemW[PrefixSeg:PrefixSegOfs];  { Get environment segment from PSP }
 FOR i := 1 TO LENGTH(st) DO
  st[i] := UpCase(st[i]);                 { Convert name to upper case       }
  i := 0;
  WHILE(Mem[envseg:i] <> 0) DO            { Process any environment strings  }
   BEGIN
    tmpst  := '';
    GetEnv := '';
    WHILE(Mem[envseg:i] <> 0) DO
     BEGIN
      tmpst := tmpst + UpCase(CHR(Mem[envseg:i])); { Gather up a string      }
      i := i + 1
     END;
      IF (POS(st,tmpst) = 1)              { Variable in this string?         }
       THEN GetEnv := COPY(tmpst, POS('=', tmpst) + 1, 255)
       ELSE i := i + 1
   END
END; { GetEnv }

{--------------------}
{  INITIALIZATION    }
{--------------------}

BEGIN { UNIT DOSStuf }
END.  { UNIT DOSStuf }

