{ Base Pointer protection procedures }

unit PROFACE;

interface

  procedure SaveBP_0;
  procedure RestoreBP_0;

implementation

Var
  BPStorage: Word;

  Procedure SaveBP_0;
  Begin
    { Save the base pointer BP in a Turbo Pascal
      global variable - BPStorage. BP should
      be on the stack, pushed there by Turbo
      Pascal. Push it back onto the stack to
      insure a proper return for Turbo Pascal }
    InLine($58/           {  pop Ax               }
           $50/           {  push Ax              }
           $BF/BPStorage/ {  mov Di,Ofs BPStorage }
           $89/$05        {  mov [Di],Ax (DS)     } );
  end;

  Procedure RestoreBP_0;
  Begin
    { Reset the Turbo Prolog base pointer (BP)
      what it was before initialization calls }

    { Remove the BP value pushed on the stack by
      by Turbo Pascal. Move the old (BPStorage) BP
      value that was pushed on the stack by
      Turbo Prolog into Ax, and push it onto the
      stack. when RestoreBP returns turbo will be
      fooled into resetting the BP to the value
      we pushed on the stack, not the value it
      placed there. }
    InLine($58/           { pop Ax               }
           $BF/BPStorage/ { mov Di,Ofs BPStorage }
           $8B/$05/       { mov Ax,[Di]          }
           $50            { push Ax              }  );
  end;
end.
