/* PRO2PAS.PRO - a simple example of interfacing Turbo Prolog 2.0 to
   Turbo Pascal 4.0 */

project "PRO2PAS.PRJ"

global predicates

  systeminit - language pascal    /* This predicate calls the */
                                  /* SYSTEM unit initialization */
                                  /* code */

  square(integer,integer) -        /* Our Turbo Pascal proce- */
     (i,o) language pascal         /* dure takes a number and */
                                   /* takes its square. There-*/
                                   /* fore it has an (i,o) */
                                   /* flow pattern */

  systemexit - language pascal     /* This predicate calls the */
                                   /* exit code for the SYSTEM */
                                   /* unit */

  saveBP     -  language pascal
  restoreBP  -  language pascal


predicates
  initialize
  run
  goodbye
goal
  run.

clauses
  run:-
    initialize, /* Initialize all units that have initialization */
                /*   code and maintain BP */
    clearwindow,
    square(4,Result),
    write("The square of 4 is ",Result),
    nl,
    write("Press any key to continue."),
    readchar(_),
    goodbye.   /* Call the exit code of any units that have them */

  /* Call all the unit initializaton code */
  initialize:-
    saveBP,     /* Save the Base Pointer register from harm */
    systeminit, /* Make the calls to the unit initialization */
    RestoreBP.  /* Restore the Base Pointer register */

/* Call any necessary unit exit code. */
  goodbye:-
    systemexit. /* systemexit will terminate program  */


/* END PRO2PAS */

