UNIT SysDebug;

{ System globals debugging unit }

INTERFACE

IMPLEMENTATION

TYPE  String15 = String[15];    { WPointer string parameter }

VAR   savedExitProc : Pointer;  { Old ExitProc value }


PROCEDURE WHex( v : word );
{ Display v as a 4-digit hex string }
CONST
   digits : ARRAY[ 0 .. 15 ] OF char = '0123456789ABCDEF';
BEGIN
   Write( digits[ hi( v ) div 16 ],
          digits[ hi( v ) mod 16 ],
          digits[ lo( v ) div 16 ],
          digits[ lo( v ) mod 16 ]  )
END; { WHex }


PROCEDURE WPointer( description : String15; p : Pointer );
{ Display pointer value in 0000:0000 format }
BEGIN
   Write( description );
   IF p = NIL THEN Write( 'NIL' ) ELSE
   BEGIN
      Write( '$' );
      WHex( Seg(p^) );
      Write( ':' );
      WHex( Ofs(p^) )
   END; { if }
   Writeln
END; { WPointer }


PROCEDURE WWord( description : String15; w : Word );
{ Display word value in 0000 hex format }
BEGIN
   Write( description, '$' );
   WHex( w );
   Writeln
END; { WWord }


{$F+} PROCEDURE CustomExit; {$F-}

{ Display system global variables at exit }

BEGIN
   Writeln;
   Writeln(  'System unit global variables' );
   Writeln(  '----------------------------' );
   Writeln(  'Memavail  = ', memavail, ' bytes');
   Writeln(  'Maxavail  = ', maxavail, ' bytes');
   WWord(    'PrefixSeg = ', prefixSeg );
   WWord(    'CSeg      = ', cSeg      );
   WWord(    'DSeg      = ', dSeg      );
   WWord(    'SSeg      = ', sSeg      );
   WWord(    'SPtr      = ', sPtr      );
   WPointer( 'HeapOrg   = ', heapOrg   );
   WPointer( 'HeapPtr   = ', heapPtr   );
   WPointer( 'FreePtr   = ', freePtr   );
   Writeln(  'FreeMin   = ', freeMin   );
   WPointer( 'HeapError = ', heapError );
   WPointer( 'ExitProc  = ', exitProc  );
   Writeln(  'ExitCode  = ', exitCode  );
   WPointer( 'ErrorAddr = ', errorAddr );
   Writeln(  'RandSeed  = ', randSeed  );
   Writeln(  'FileMode  = ', fileMode  );

   exitProc := savedExitProc    { Restore saved exitProc pointer }

END; { CustomExit }


BEGIN
   savedExitProc := exitProc;   { Save ExitProc pointer }
   exitProc := @CustomExit      { Install custom exit procedure }
END.
