PROGRAM ErrorShell;

{ Demonstrate how to write a custom halt and
  runtime error handler. }

VAR   savedExitProc : Pointer;  { Old ExitProc value }
      num : integer;            { Test number }


{$F+} PROCEDURE CustomExit; {$F-}

{ Custom exit and runtime error handler }

BEGIN

   IF ( exitCode <> 0 ) AND ( errorAddr = NIL ) THEN
   BEGIN
      Writeln;
      Writeln( 'Program halted!' );
      Writeln( 'Exit code = ', exitCode )  { Display halt code }
   END; { if }

   exitProc := savedExitProc    { Restore saved exitProc pointer }

END; { CustomExit }


BEGIN

   savedExitProc := exitProc;   { Save ExitProc pointer }
   exitProc := @CustomExit;     { Install custom error procedure }

   Writeln;
   Writeln( 'Welcome to ErrorShell' );
   Writeln;
   Write( 'Enter an integer value: ' );
   Readln( num );
   Halt( num )

END.
