    title UCASESTR
CODE segment byte public
    assume   cs:code
    public   UCASESTR

; procedure UcaseStr(var S);
UCASESTR proc far
    Str       equ dword ptr [bp+6]
    StackSize equ 4

    push   bp       ;save bp & ds
    mov    bp,sp
    push   ds

    lds si, Str     ;ds:si is ptr to S
    xor cx,cx       ;clear cx
    mov cl, [si]    ;length of S

    jcxz    NullStr ;0 length, skip

    inc si          ;pt to char 1
                    ;as STOSB writes to ds:[ei], copy ds:[si] to es:[di]
    mov di,si
    mov ax,ds
    mov es,ax
    mov bx, 'za'    ;faster compares in registers
    mov ah, 020h    ;for XORing 5th bit

    ;we now have:
    ;    ds:[si] & es:[di] both pt to S[1]
    ;    bx contains 'za'
    ;    ah contains 10h
    ;    cx contains length of S
    cld             ;as Karl says, try this
DoIt:
    lodsb           ;[si] to al
    cmp   al, bl    ;al ? 'a'
    jl    NoChange  ; its <
    cmp   al, bh    ;al ? 'z'
    jg    NoChange  ; its >
    xor   al, ah    ;turno bit 5 off
    stosb           ;save it back
    jmp   DoneYet
NoChange:
    inc   di        ;no stosb done
DoneYet:
    loop  DoIt      ;any more chars

NullStr:
Exit:
    pop ds          ;restore ds & bp
    pop bp
    ret StackSize   ;clean stack params

UCASESTR endp
CODE     ends
    end
