{TEXTRD3.PAS}
{
Description:  Blockread routines for reading input file into a character
              array for parsing.

Author:       Karl Gerhard
Date:         7/19/87
Application:  IBM PC and compatibles
}


{ Note that this entire file is one procedure }

{--------------------------------------}
Procedure  textblockread(var input_array:input_array_Type; var F:file);
{ read text file, return length }
Var Recs:integer; n,fptr,ptr1,ptr2:integer;

Procedure showinput;
Begin
writeln(' Input Array length:',input_length, '::'); writeln;
for n := 1 to input_length do write(input_array[n] );
writeln;
for n := 1 to input_length do write( n mod 10);
writeln;
End;


{--------------------------------------}
Function find(cy:char):boolean;
{ find the cy, set fptr, return found/not_found }
Begin
fptr := 0;
repeat     fptr := fptr + 1;
until (input_array[fptr] = cy) or (fptr > input_length);
find := fptr <= input_length;
{writeln('Find fptr= ',fptr); {}
End;

{--------------------------------------}
Procedure delete_input(p1,p2:integer);
{ move upper part of input down }
Var n:integer;
Begin
if (p2 - p1) <= 0 then error('delete_input',' bad lengths');
move(input_array[p2], input_array[p1], input_length - p2 + 1);
input_length := input_length - (p2 - p1);
input_array[p1] := ' ';
End;
{***}

{ Block for textread }
Begin
reset(F);
Recs := filesize(F);
blockread(F,input_array,Recs);
close(F);
input_length := 0;
repeat input_length := input_length + 1; until input_array[input_length] = #26;
input_length := input_length - 1;


{ ** replace #13#10 with blanks }
for n := 1 to input_length do
  if input_array[n] in [#13,#10] then input_array[n] := ' ';

{ delte commentary }
while find('{') do begin
  ptr1 := fptr;
  if find('}') then begin
    ptr2 := fptr;
    delete_input(ptr1,ptr2);
  end
  else begin
    showinput;error('delete commentary','Missing closing }');end;
end;

End;

