{PARSE4.PAS}
{
Description:  Parsing routines for Pascal source code
Author:       Karl Gerhard
Date:         9/30/87
Application:  IBM PC and compatibles
}

{---------------------------------}
Procedure emitter(s:stdstr);
Begin
{ writeln(FLOG,'  EMITTING ',s);
writeln(' Emitting: ',s); }
print_string := print_string + s + ' ';
End;

{---------------------------------}
Function parse(plevel:integer; stack:stack_type):boolean;
{ main parse routine }
Var
  option_op,tops,rhs:stdstr;
  statok:boolean;
  p:integer;

Begin { ----- main parse ------ }
logging(strint(plevel),' -------- PARSER ENTRY');
statok := true;
while statok and (length(stack) > 0) {and (the_token <> '')} do begin
  tops := pop(stack);
  logging(strint(plevel),' STACK  ' + tops + ' ' + stack);

  { optional phrase }
  if tops = '{' then begin
    p := pos('}',stack);
    option_op := copy(stack,1, p - 2);
    delete(stack,1,p + 1);
    repeat logging(#13#10 + strint(plevel), ' OPTION CALL');
    until ( the_token = '' ) or not parse(plevel + 1,option_op);
  end


  { OR phrase }
  else if stack[1] = '|' then begin
    logging(#13#10 + strint(plevel), ' ALT CALL');
    if parse(plevel + 1,tops) then begin
      while stack[1] = '|' do begin tops := pop(stack); tops := pop(stack);end;
    end
    else begin
      tops := pop(stack);
    end
  end

  { check for Any token }
  else if tops = '!ID' then begin
    if the_token[1] in [#58..#64,#32..#47] then begin
      statok := false;
{      writeln( 'Parser expected ',color(0,7), ' IDENTIFIER ', color(7,0),
               ' Found ', color(0,7), ' ', the_token, ' ', color(7,0) );
      logging( 'Parser ','Expected  IDENTIFIER  Found '+ the_token);      }
    end
    else begin
      emitter(the_token);
      the_token := getoken;
    end;
  end

  { check for EXIT token }
  else if tops = '!EXIT' then begin
    tops := '-' + pop(stack) + '-';
    if pos( '-'+struc(the_token)+'-',tops) > 0 then begin
      statok := false;
    end;
  end

  { check for EMPTY token }
  else if tops = '!EMPTY' then begin
  end

  { check for Action token }
  else if tops[1] = '@' then begin
  actions(tops);
  end

  { Non-terminal token }
  else if  search_lhs(tops,rhs) then begin
    push(rhs, stack );
  end

  { terminal token }
  else if struc(tops) = struc(the_token) then begin
    {statok := true;}
    emitter(the_token);
    the_token := getoken;
  end { terminal token }

  { Parse failed }
  else begin
    statok := false;
    if plevel = 1 then begin
      writeln( 'Parser expected ',color(0,7), ' ', tops, ' ', color(7,0),
               ' Found ', color(0,7), ' ', the_token, ' ', color(7,0) );
      logging( 'Parser ','Expected '+ tops + ' Found ' + the_token);
    end;
  end;
end;
logging(strint(plevel), ' -------- PARSER EXIT ' + bool(statok) + #13#10 );
parse := statok;
End;

