{STATKEYS.PAS}
PROGRAM StatusKeys;
{
Description:  Program to demonstrate the use of user-provided keyboard
              routines to detect and display the status of NumLock,
              ScrollLock, CapsLock and Insert/Overwrite toggles on
              the IBM PC.

Author:       Don Taylor
Date:         7/16/87
Last revised: 12/03/1987  17:42:20
Application:  IBM PC or compatible with DOS 2.0 or greater
}

USES DOS, Crt;

TYPE
 Str80     = STRING[80];

VAR
 ch          : CHAR;
 s           : Str80;
 ExtendedKey : BOOLEAN;
 StatusByte  : BYTE ABSOLUTE $0000:$0417;
 TheStatus   : BYTE;

{--------------------}

PROCEDURE UpdateStatusDisplay;

CONST
 StatusLine   =  24;

VAR
 XPosn         : INTEGER;
 YPosn         : INTEGER;
 InsertOn      : BOOLEAN;
 CapsLock      : BOOLEAN;
 NumLock       : BOOLEAN;
 ScrollLock    : BOOLEAN;
 StatusMessage : Str80;

BEGIN
 XPosn      := WhereX;                      { Remember cursor position  }
 YPosn      := WhereY;
 InsertOn   := (TheStatus AND $08) <> 0;    { Detect status of switches }
 CapsLock   := (TheStatus AND $04) <> 0;
 NumLock    := (TheStatus AND $02) <> 0;
 ScrollLock := (TheStatus AND $01) <> 0;
 NormVideo;
 IF InsertOn
  THEN StatusMessage := 'Insert   '
  ELSE StatusMessage := 'Overwrite';
 GOTOXY(20,StatusLine); WRITE(StatusMessage);
 IF CapsLock
  THEN StatusMessage := 'Caps Lock'
  ELSE StatusMessage := '         ';
 GOTOXY(35,StatusLine); WRITE(StatusMessage);
 IF NumLock
  THEN StatusMessage := 'Num Lock'
  ELSE StatusMessage := '        ';
 GOTOXY(50,StatusLine); WRITE(StatusMessage);
 IF ScrollLock
  THEN StatusMessage := 'Scroll Lock'
  ELSE StatusMessage := '           ';
 GOTOXY(65,StatusLine); WRITE(StatusMessage);
 GOTOXY(XPosn,YPosn)                        { Restore cursor            }
END;  {UpdateStatusDisplay}

{--------------------}

FUNCTION ScanKey : CHAR;

CONST
 KeyboardIntr = $16;

VAR
 n           : INTEGER;
 GotKey      : BOOLEAN;
 KeyboardRec : Registers;

BEGIN
 REPEAT
  IF TheStatus <> StatusByte SHR 4          { See if status changed     }
   THEN BEGIN                               { If so, update screen      }
         TheStatus := StatusByte SHR 4;
         UpdateStatusDisplay
        END;
 UNTIL KeyPressed;
 KeyboardRec.AX := 0;                       { Read keyboard when key is }
 INTR(KeyboardIntr, KeyboardRec);           { finally pressed           }
 n := LO(KeyboardRec.AX);
 ExtendedKey := (n = 0);                    { Mark extended keycodes    }
 IF ExtendedKey THEN n := HI(KeyboardRec.AX);
 ScanKey := CHR(n)
END;  {ScanKey}

{--------------------}

FUNCTION ReadLine : Str80;

CONST
 BS = ^H;     { ASCII Backspace       }
 CR = ^M;     { ASCII Carriage Return }

VAR
 RLch : CHAR;
 Lin  : Str80;

BEGIN
 Lin       := '';
 TheStatus := 0;             { Assume all status clear, but display }
 UpdateStatusDisplay;        { status anyway                        }
 REPEAT
  REPEAT
    RLch := ScanKey
  UNTIL NOT ExtendedKey;
  IF (RLch = BS) AND (LENGTH(Lin) >= 1)
   THEN BEGIN                { Handle backspace key }
         IF LENGTH(Lin) > 0
          THEN WRITE(BS,' ',BS)
          ELSE WRITE(' ',BS);
         DELETE(Lin,LENGTH(Lin),1)
        END;
  IF (RLch IN [' '..'~'])    { Handle printable characters }
   THEN BEGIN
         WRITE(RLch);
         Lin := CONCAT(Lin,RLch)
        END;
 UNTIL RLch = CR;
 ReadLine := Lin
END;  {ReadLine}

{====================}

BEGIN {StatusKeys}
 ClrScr;
 WRITELN('Special Key Demo ----------');
 LowVideo;
 GOTOXY(1,10);  WRITE('Enter a string: ');
 s := ReadLine;
 LowVideo;
 GOTOXY(1,10); ClrEOL;
 GOTOXY(1,5); WRITE('String entered: "', s,'"');
 NormVideo;
 GOTOXY(24,12); WRITE('(Press "X" to exit...)');
 REPEAT
  GOTOXY(78,24);
  ch := ScanKey;
 UNTIL ch IN ['X','x'];
 GOTOXY(1,12); ClrEOL
END.  {StatusKeys}
