PROGRAM Kaleidoscope;

(*      PURPOSE: Display Kaleidoscope Patterns
 *      SYSTEM:  Turbo Pascal 4.0
 *      AUTHOR:  Tom Swan
 *)

USES    Crt, Graph;


VAR     grDriver : Integer;     { Graphics driver number }
        grMode   : Integer;     { Graphics driver mode }
        grError  : Integer;     { Graphics error code }


PROCEDURE DoGraphics;

{ Display graphics until a key is pressed }

VAR	xmax, ymax : Integer;		{ Maximum x, y values }
	x1, y1, x2, y2 : Integer;	{ Line endings }
	dx1, dy1, dx2, dy2 : Integer;	{ Change in x1,y1,x2,y2 }
	displayPeriod : Word;		{ Time between clearing }
	linePeriod : Word;		{ Time each pattern lives }
	ch : Char;			{ For clearing keypress }
	

    PROCEDURE Initialize;
    
    { Perform various initializations }
    
    BEGIN
	Randomize;		{ "Seed" new random sequence }
	displayPeriod := 0;	{ Force call to NewDisplayPeriod }
	xmax := GetMaxX DIV 2;	{ Set x and y maximums to middle }
	ymax := GetMaxY DIV 2;	{  of display resolution }
	
      { Restrict viewport to 1/4 entire display.  With clipping
        off, this centers the origin (0,0) and makes mirror
        images in the four quadrants easy to draw. }
       
	SetViewPort( xmax, ymax, GetMaxX, GetMaxY, ClipOff )
	
    END; { Initialize }
    
    
    PROCEDURE NewDisplayPeriod;
    
    { Clear screen and initialize displayPeriod,
      controlling length of time between screen clears }
      
    BEGIN
	ClearDevice;	{ Clear entire display }
	displayPeriod := 6 + Random( 24 )  { 6..29 }
    END; { NewDisplayPeriod }
    
    
    PROCEDURE NewValues;
    
    { Select coordinates, movements, linePeriod,
      and line color at random }
    
    BEGIN
	x1  := Random( xMax + 1 );	{ x1 <- 0..xmax }
	y1  := Random( yMax + 1 );	{ y1 <- 0..ymax }
	x2  := Random( xMax + 1 );	{ x2 <- 0..xmax }
	y2  := Random( yMax + 1 );	{ y2 <- 0..ymax }
	dx1 := Random( 16 ) - 8;	{ dx1 <- -8..+7 }
	dy1 := Random( 16 ) - 8;	{ dy1 <- -8..+7 }
	dx2 := Random( 16 ) - 8;	{ dx2 <- -8..+7 }
	dy2 := Random( 16 ) - 8;	{ dy3 <- -8..+7 }

	linePeriod := 5 + Random(120);	{ linePeriod <- 5..124 }

	SetColor( 1 + Random( GetMaxColor ) )
	
    END; { NewValues }
    
    
    PROCEDURE MoveCoordinates;
    
    { Adjust line coordinates, making lines appear
      to move }
    
    BEGIN
	x1 := x1 + dx1;		{ Add appropriate "delta," }
	y1 := y1 + dy1;		{  meaning "change in," value }
	x2 := x2 + dx2;		{  to line end coordinates. }
	y2 := y2 + dy2
    END; { MoveCoordinates }
    
    
    PROCEDURE DrawLines;
    
    { Draw lines mirrored in four quadrants }
    
    BEGIN
	Line( -x1, -y1, -x2, -y2 );	{ upper left quadrant }
	Line( -x1,  y1, -x2,  y2 );	{ lower left quadrant }
	Line(  x1, -y1,  x2, -y2 );	{ upper right quadrant }
	Line(  x1,  y1,  x2,  y2 )	{ lower right quadrant }
    END; { DrawLines }
    
    
BEGIN
    Initialize;
    REPEAT
	IF displayPeriod <= 0 
	    THEN NewDisplayPeriod;	{ Clear screen }
	NewValues;
	WHILE ( linePeriod > 0 ) AND ( NOT Keypressed ) DO
	BEGIN
	    Delay( 5 );			{ Set the speed limit }
	    MoveCoordinates;		{ Animate display }
	    DrawLines;			{ Draw mirror images }
	    linePeriod := linePeriod - 1
	END; { while }
	displayPeriod := displayPeriod - 1
    UNTIL Keypressed;
    ch := Readkey
END; { DoGraphics }


BEGIN
    grDriver := Detect;
    InitGraph( grDriver, grMode, '' );
    grError := GraphResult;
    IF grError <> GrOk
     THEN
        Writeln( 'Graphics error : ', GraphErrorMsg( grError ) )
     ELSE
        BEGIN
            DoGraphics;
            CloseGraph
        END
END.
