PROGRAM FontDemo;

(*      PURPOSE: Demonstrate BGI text fonts
 *      SYSTEM:  Turbo Pascal 4.0
 *      AUTHOR:  Tom Swan
 *)

USES    Crt, Graph;

VAR     grDriver, grMode, grError : Integer;


PROCEDURE Pause;

{ Display message, wait for Enter key, clear screen. }

BEGIN
    GotoXY( 2, 23 );
    Write( ' Press Enter to continue...' );
    Readln;
    ClearViewPort
END; { Pause }


PROCEDURE TestFont( fn : Integer );

{ Display test text for font number fn }

VAR     size : Integer;     { Font size }
        name : String[10];  { Font name }

BEGIN
   CASE fn OF
      DefaultFont   : name := 'Default';
      TriplexFont   : name := 'Triplex';
      SmallFont     : name := 'Small';
      SansSerifFont : name := 'Sans Serif';
      GothicFont    : name := 'Gothic'
   END; { case }

   FOR size := 1 TO 8 DO
   BEGIN
      SetColor( size );
      SetTextStyle( fn, HorizDir, size );
      MoveTo( 0, GetY + TextHeight('M') + 2 );
      OutText( name + ' Font test pattern ABCDEFG 123456 !@#$%^' )
   END { for }

END; { TestFont }


PROCEDURE WritelnTest;

{ Display text via Writeln }

BEGIN
    GotoXY( 2, 2 );
    Writeln( ' This text is displayed by Writeln' );
    Pause
END; { WritelnTest }


PROCEDURE DoGraphics;

{ Display graphics }

VAR     fontNumber : Integer;
        ch : Char;

BEGIN

    DirectVideo := False;  { So Write, Writeln work in graphics
                             when using the Crt unit. }

  { Draw blue border and restrict viewport to protect
    border from erasure. }

    SetColor( Blue );
    Rectangle( 0, 0, GetMaxX, GetMaxY );
    SetViewPort( 1, 1, GetMaxX-1, GetMaxY-1, ClipOn );

    WritelnTest;  { Demonstrate Writeln in graphics mode }

    FOR fontNumber := DefaultFont TO GothicFont DO
    BEGIN
        TestFont( fontNumber );
        Pause
    END { for }

END; { DoGraphics }


BEGIN
    grDriver := Detect;
    InitGraph( grDriver, grMode, '' );
    grError := GraphResult;
    IF grError <> GrOk
    THEN Writeln( 'Graphics error : ', GraphErrorMsg( grError ) )
    ELSE BEGIN
             DoGraphics;
             CloseGraph
         END
END.
