PROGRAM No_Reboot;
{=============}
{BEGIN INCLUDE}
{=============}
Uses Crt, Dos;
CONST
  D_Key = 83; (* SCAN code of the Del key *)
  Kbd_Int = 9;

VAR
  Kbd_Vec, Exit_Vec : Pointer;

{$I ERROR.INC}

  PROCEDURE INT9_ISR(_Flags, _CS, _IP, _AX, _BX, _CX, _DX,
                             _SI, _DI, _DS, _ES, _BP:word);
  INTERRUPT;
  (* ======================================== *)
  (* This routine suppresses the <Del> key.   *)
  (* If it detects either a "make" or a       *)
  (* "break" from the <Del> key, it simply    *)
  (* resets the keyboard.  Without <Del>      *)
  (* there's no way to enter <Ctrl><Alt><Del> *)
  (* so you can't reboot.                     *)
  (* ======================================== *)
  BEGIN
    INLINE(
    $FB/              {STI            ;Allow interrupts}
    $9C/              {PUSHF          ;Save the flags}
    $E4/$60/          {IN   AL,$60    ;READ the keyboard port}
    $24/$7F/          {AND  AL,$7F    ;Mask off "break bit"}
    $3C/<D_KEY/       {CMP  AL,<D_KEY ;Is it a "Del" key?}
    $74/$18/          {JZ   GetOut    ;If so, throw it away}
    (* ============================ *)
    (* CHAIN to the regular INT 9   *)
    (* ============================ *)
    $9D/              {POPF         ;Restore the flags}
    $A1/>KBD_VEC+2/   {MOV  AX,[>KBD_VEC+2] ;Old vector seg to AX}
    $8B/$1E/>KBD_VEC/ {MOV  BX,[>KBD_VEC]   ;Old vector ofs to BX}
    $87/$5E/$0E/      {XCHG BX,[BP+$0E] ;Swap ofs w/ return address}
    $87/$46/$10/      {XCHG AX,[BP+$10] ;Swap seg w/ return address}
    $89/$EC/          {MOV  SP,BP ;UNDO procedure's entry code}
    $5D/              {POP  BP}
    $07/              {POP  ES}
    $1F/              {POP  DS}
    $5F/              {POP  DI}
    $5E/              {POP  SI}
    $5A/              {POP  DX}
    $59/              {POP  CX}
    $CB/              {RETF ;in effect, JMP to old vector}
{GetOut:}
    $E4/$61/          {IN   AL,$61  ;Read Kbd controller port}
    $88/$C4/          {MOV  AH,AL}
    $0C/$80/          {OR   AL,$80  ;Set the "reset" bit and}
    $E6/$61/          {OUT  $61,AL  ;  send it back to control}
    $86/$C4/          {XCHG AH,AL   ;Get back control value}
    $E6/$61/          {OUT  $61,AL  ;  and send it too}
    $9D/              {POPF         ;Restore the flags}
    $FA/              {CLI          ;No interrupts }
    $B0/$20/          {MOV  AL,+$20 ;Send an EOI to the}
    $E6/$20);         {OUT  $20,AL  ;  interrupt controller }
  END;

{=============}
{END INCLUDE  }
{=============}

  PROCEDURE Do_Demo;
  VAR
    L : STRING[80];
  BEGIN
    ClrScr;
    WriteLn('KEYBOARD INTERRUPT DEMO "REBOOT PROHIBITED"');
    WriteLn('===========================================');
    WriteLn;
    Write('IF SideKick is not loaded, you ');
    WriteLn('cannot reboot from within');
    Write('this program.  Try it!  You can ');
    WriteLn('enter text, but you cannot');
    WriteLn('reboot.  Enter a blank line to quit.');
    WriteLn;
    REPEAT
      ReadLn(L);
      WriteLn(L);
    UNTIL L = '';
  END;

BEGIN
  CheckBreak := TRUE;
  GetIntVec(Kbd_Int, Kbd_Vec);   {save "old" INT9}
  SetIntVec(Kbd_Int, @INT9_ISR); {install new}
  Exit_Vec := ExitProc;          {save old ExitProc}
  ExitProc := @My_Error;         {install new}
  Do_Demo;                       {show yer stuff!}
  {Interrupt vector is RESTORED in the ExitProc}
END.
