(*  HEX functions *)
type
  string2 = string[2];
  string4 = string[4];

  const
    HexDigit : Array[0..15] of Char = '0123456789ABCDEF';

  function HexByte(B : byte) : string2;
  begin
    HexByte := HexDigit[B shr 4] + HexDigit[B and $F];
  end;

  function Hex(I : integer) : string4;
  begin
    Hex := HexByte(Hi(I)) + HexByte(Lo(I));
  end;
