{
--------------------------------------------------------------------------
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
FileManager (version 1.0) by Jim Zwick provides a visual display of DOS
directories and their contents, and it permits files to be copied, moved,
renamed, erased, printed and viewed by highlighting the files on the
display and picking commands from a menu. Files to be printed can be
spooled using the DOS 3.X print spooler from within FM. Written in
Trubo Pascal 4.0.

* ASSOCIATED FILES
FM.PAS
FM.DOC
FM.EXE
FM.TPU
FMFILE.PAS
FMINPUT.PAS
FMSCREEN.PAS
FMUTEST.EXE
FMUTEST.PAS
FMVIEW.PAS

==========================================================================
}
{$B-}    { Boolean short-circuit evaluation on }         { Program: FM.PAS    }
{$S-}    { Stack checking off }                          { Author:  Jim Zwick }
{$I-}    { I/O checking off }                            { Version: 1.0       }
{$V+}    { Strict String parameter checking on }         { Date:    03-04-88  }
{$R-}    { Range checking off }
                               { To remove dOs option from FM comment out the }
{$DEFINE MemLimited}           { MemLimited definition.  To compile as a Unit }
(* {$DEFINE FMasUNIT} *)       { Remove commenting from FMasUNIT definition.  }
                               { When compiling as a Unit, be careful to      }
                               { comment out MemLimited if you have not set   }
                               { a low maximum heap in your main program.     }
{$IFDEF FMasUNIT}
UNIT FM;
INTERFACE
{$ELSE}
{$IFDEF MemLimited}                            { Heap can be increased for    }
{$M 8192,0,65536}  { 8K Stack, 64K Heap }      { larger View buffer but this  }
{$ENDIF}                                       { will reduce memory available }
PROGRAM FM;                                    { when you exit to DOS from    }
{$ENDIF}                                       { within FM.                   }

Uses
  Crt,
  Dos,
  FMScreen,
  FMInput,
  FMFile,
  FMView;

{$IFDEF FMasUNIT}
  PROCEDURE FileManager;

IMPLEMENTATION
{$ENDIF}

  CONST
    Reading  : STRING[21] = 'Reading Directory ...';
    HotPrint = #153;
  VAR
    DisplayStart : INTEGER;
    DisplayEnd   : INTEGER;
    i, Marker    : INTEGER;
    ListCount    : WORD;
    X, Y, Col    : BYTE;
    Reply        : CHAR;
    SpOk         : BOOLEAN;

  { ------------------------------------------------------------------------- }

  PROCEDURE Help;
  VAR
    Reply : CHAR;
  BEGIN
    WOpen(4);
    ClrScr;
    CursorOn(FALSE);
    WRITELN(' mArk   - Mark files to Copy, Move or Erase');
    WRITELN(' Copy   - Copy marked files');
    WRITELN(' Move   - Move marked files');
    WRITELN(' Erase  - Erase marked files');
    WRITELN(' Rename - Rename current file');
    WRITELN(' View   - View current file');
    WRITELN(' Print  - Use DOS 3.xx print spooler (PRINT');
    WRITELN('    must be installed before starting FM)');
    WRITELN(' Alt-P  - Send current file to print spool');
    WRITELN(' Spec   - Change File Spec');
    WRITELN(' Dir    - Change Directories');
{$IFDEF MemLimited}
    WRITELN(' dOs    - Exit temporarily to DOS');
{$ENDIF}
      WRITE(' <Esc>  - EXIT');
    Reply := GetKey(#27, FALSE);
    WClose;
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE DisplayFileNames(Start : INTEGER);
  VAR
    X, Y, Col    : BYTE;
    DisplayCount : BYTE;
    TempFRec     : FilePtr;
    ScrAttr      : WORD;
  BEGIN
    ClrScr;
    GotoXY(2, 1);
    WRITE(DiskFree(0), ' Bytes Free');
    GotoXY(2, 2);    WRITE('Directory: ', CurrDir);
    GotoXY(2, 3);    WRITE('File Spec: ', Mask);
{$IFDEF MemLimited}
    GotoXY(6, 22);
    WRITE(
      'mArk   Copy   Move   Erase   Rename   View   Print   Spec   Dir   dOs');
{$ELSE}
    GotoXY(9, 22);
    WRITE('mArk   Copy   Move   Erase   Rename   View   Print   Spec   Dir');
{$ENDIF}
    IF (ListCount = 0) THEN
      BEGIN
        GotoXY(4, 5);
        WRITE('No Matching Files');
      END
    ELSE
      BEGIN
        Y := 5;
        DisplayCount := 0;
        Col := 0;
        TempFRec := FirstFile;
        WHILE (TempFRec^.FNum < Start) DO TempFRec := TempFRec^.Next;
        REPEAT
          Inc(DisplayCount);
          Inc(Col);
          CASE Col OF
            1 : X := 4;
            2 : X := 19;
            3 : X := 34;
            4 : X := 49;
            5 : X := 64;
          END;
          IF (TempFRec^.Mark) THEN ScrAttr := ReverseVid
          ELSE ScrAttr := NormalVid;
          DisplayLine(SUCC(X), SUCC(Y), LENGTH(TempFRec^.Key),
            ScrAttr, TempFRec^.Key);
          DisplayEnd := TempFRec^.FNum;
          TempFRec := TempFRec^.Next;
          IF (Col = 5) THEN
            BEGIN
              Col := 0;
              Inc(Y);
            END;
        UNTIL (DisplayCount = 80) OR (TempFRec = NIL);
        CurrFile := FirstFile;
        WHILE (CurrFile^.FNum < Marker) DO CurrFile := CurrFile^.Next;
      END;
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE GetMask;
  VAR
    St : Str80;
  BEGIN
    St := Mask;
    ReadStr(13, 3, 12, St);
    Mask := St;
    GotoXY(13, 3);  WRITE(Mask);
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE GetNewList;
  BEGIN
    GotoXY(2, 4);   WRITE(Reading);
    GetFilesList(Mask, FirstFile, LastFile, ListCount);
    DisplayStart := 1;
    Marker := 1;
    Col := 1;
    Y := 5;
    DisplayFileNames(1);
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE OpenFileManager;
  BEGIN
    StartX := WhereX;
    StartY := WhereY;
    WOpen(2);
    ClrScr;
    GetCurrDir;
    GetNewList;
  END;
  { ------------------------------------------------------------------------- }

{$IFDEF FMasUNIT}
PROCEDURE FileManager;
{$ENDIF}

BEGIN
  Mask := '*.*';
  OpenFileManager;
  REPEAT
    GotoXY(69, 1);       WRITE(ListCount:3, ' Files');
    HIGHVIDEO;
{$IFDEF MemLimited}
    GotoXY(7, 22);       WRITE('A');
    GotoXY(13, 22);      WRITE('C');
    GotoXY(20, 22);      WRITE('M');
    GotoXY(27, 22);      WRITE('E');
    GotoXY(35, 22);      WRITE('R');
    GotoXY(44, 22);      WRITE('V');
    GotoXY(51, 22);      IF SpoolOK THEN WRITE('P');
    GotoXY(59, 22);      WRITE('S');
    GotoXY(66, 22);      WRITE('D');
    GotoXY(73, 22);      WRITE('O');
{$ELSE}
    GotoXY(10, 22);       WRITE('A');
    GotoXY(16, 22);      WRITE('C');
    GotoXY(23, 22);      WRITE('M');
    GotoXY(30, 22);      WRITE('E');
    GotoXY(38, 22);      WRITE('R');
    GotoXY(47, 22);      WRITE('V');
    GotoXY(54, 22);      IF SpoolOK THEN WRITE('P');
    GotoXY(62, 22);      WRITE('S');
    GotoXY(69, 22);      WRITE('D');
{$ENDIF}
    LOWVIDEO;
    CASE Col OF
      1 : X := 4;
      2 : X := 19;
      3 : X := 34;
      4 : X := 49;
      5 : X := 64;
    END;
    IF (ListCount > 0) THEN
      BEGIN
        Marker := CurrFile^.FNum;
        DisplayLine(SUCC(X), SUCC(Y), LENGTH(CurrFile^.Key),
          ReverseVid, CurrFile^.Key);
      END
    ELSE Marker := 1;
    GotoXY(X, Y);
    CursorOn(TRUE);
{$IFDEF MemLimited}
    Reply := GetKey(#0+#27+'ACMERVPSDO', TRUE);
{$ELSE}
    Reply := GetKey(#0+#27+'ACMERVPSD', TRUE);
{$ENDIF}
    IF (NOT CurrFile^.Mark) AND (ListCount > 0) AND (Reply <> F1) THEN
      BEGIN
        GotoXY(X, Y);
        WRITE(CurrFile^.Key);        { Remove highlighting from unmarked file }
        GotoXY(X, Y);
      END;
    IF (ListCount > 0) THEN                { Avoid dereferencing NIL pointers }
      CASE Reply OF
        Up : IF (Y > 5) THEN
               BEGIN
                 Dec(Y);
                 i := 0;
                 WHILE (i < 5) DO
                   BEGIN
                     CurrFile := CurrFile^.Last;
                     Inc(i);
                   END;
               END;
         Down : IF ((CurrFile^.FNum + 5) <= DisplayEnd) THEN
                  BEGIN
                    Inc(Y);
                    i := 0;
                    WHILE (i < 5) DO
                      BEGIN
                        CurrFile := CurrFile^.Next;
                        Inc(i);
                      END;
                  END;
         Left : IF (CurrFile^.FNum > DisplayStart) THEN
                  BEGIN
                    CurrFile := CurrFile^.Last;
                    IF (Col > 1) THEN Dec(Col)
                    ELSE
                      BEGIN
                        Col := 5;
                        Dec(Y);
                      END;
                  END;
         Right : IF (CurrFile^.FNum < DisplayEnd) THEN
                   BEGIN
                     CurrFile := CurrFile^.Next;
                     IF (Col < 5) THEN Inc(Col)
                     ELSE
                       BEGIN
                         Col := 1;
                         Inc(Y);
                       END;
                   END;
          PgUp : IF (DisplayStart > FirstFile^.FNum) THEN
                   BEGIN
                     DisplayStart := DisplayStart - 80;
                     Marker := DisplayStart;
                     Col := 1;
                     Y := 5;
                     DisplayFileNames(DisplayStart);
                   END;
          PgDn : IF (DisplayEnd < LastFile^.FNum) THEN
                   BEGIN
                     DisplayStart := DisplayStart + 80;
                     Marker := DisplayStart;
                     Col := 1;
                     Y := 5;
                     DisplayFileNames(DisplayStart);
                   END;
          'E' : BEGIN
                  EraseFile;
                  GetNewList;
                END;
          'A' : CurrFile^.Mark := NOT CurrFile^.Mark;
     HotPrint : IF SpoolOK THEN
                  BEGIN
                    SpoolFile(CurrDir + CurrFile^.Key, SpOK);
                    IF NOT SpOk THEN
                      WritePrompt(2, 4, 'ERROR Submitting File to Spool');
                  END;
          'M' : BEGIN
                  MoveFile;
                  GetNewList;
                END;
          'C' : BEGIN
                  CopyFile;
                  GetNewList;
                END;
          'R' : BEGIN
                  DisplayLine(SUCC(X), SUCC(Y), LENGTH(CurrFile^.Key),
                    ReverseVid, CurrFile^.Key);
                  RenameFile;
                  GetNewList;
                END;
          'V' : View(CurrFile^.Key);
      END;
    CASE Reply OF
      'S' : BEGIN
              GetMask;
              GetNewList;
            END;
      'D' : BEGIN
              GetNewDirectory;
              GetNewList;
            END;
      'P' : IF SpoolOK THEN ControlSpool;
{$IFDEF MemLimited}
      'O' : BEGIN
              WClose;
              WHILE (FirstFile <> NIL) DO
                DeleteFile(FirstFile, LastFile, FirstFile^.Key);
              WRITELN;
              WRITE('Type EXIT to return to File Manager...');
              EXEC(EnvSearch('COMSPEC'), '');
              OpenFileManager;       { Use of EnvSearch allows loading of 2nd }
            END;                     { copy of COMMAND.COM from any drive.    }
{$ENDIF}
       F1 : Help;
    END;
  UNTIL (Reply = #27);
  WClose;

{$IFDEF FMasUNIT}
END;
{$ENDIF}

END.

