{ FILESTUF.PAS }

UNIT FileStuf;

{
Description:  Advanced functions to test for the existence of a specified
              file or directory. Detects the presence of the file or dir-
              ectory, even if it is marked as read-only or it is a hidden
              or system entity.

Author:       Don Taylor
Date:         12/17/87
Last revised: 04/18/88  8:40 (Corrected errors per "TUG's Bugs" Issue 24)
Application:  IBM PC or compatible with Turbo Pascal 4.0
}

{<<<<<---------->>>>>}

INTERFACE

 USES Dos, TypeStuf;

 FUNCTION FileExists(FName : Str80) : BOOLEAN;
 FUNCTION DirExists(DName : Str80)  : BOOLEAN;

{<<<<<---------->>>>>}

IMPLEMENTATION

FUNCTION FileExists(FName : Str80) : BOOLEAN;

VAR
 f     : FILE;
 fAttr : WORD;

BEGIN
 ASSIGN(f, FName);
 GetFAttr(f, fAttr);
 FileExists := (DosError = 0)
            AND ((fAttr AND Directory) = 0)
            AND ((fAttr AND VolumeID)  = 0)
END;  { FileExists }

{--------------------}

FUNCTION DirExists(DName : Str80) : BOOLEAN;

VAR
 f     : FILE;
 fAttr : WORD;

BEGIN
 ASSIGN(f, DName);
 GetFAttr(f, fAttr);
 DirExists := ((fAttr AND Directory) <> 0) AND (DosError = 0)
END;  { DirExists }

{--------------------}

FUNCTION IsReadOnly(FName : Str80) : BOOLEAN;

VAR
 f     : FILE;
 fAttr : WORD;

BEGIN
 ASSIGN(f, FName);
 GetFAttr(f, fAttr);
 IsReadOnly := (fAttr AND ReadOnly) <> 0
END;  { IsReadOnly }

{--------------------}

FUNCTION IsHidden(FName : Str80) : BOOLEAN;

VAR
 f     : FILE;
 fAttr : WORD;

BEGIN
 ASSIGN(f, FName);
 GetFAttr(f, fAttr);
 IsHidden := (fAttr AND Hidden) <> 0
END;  { IsHidden }

{--------------------}

FUNCTION IsSysFile(FName : Str80) : BOOLEAN;

VAR
 f     : FILE;
 fAttr : WORD;

BEGIN
 ASSIGN(f, FName);
 GetFAttr(f, fAttr);
 IsSysFile := (fAttr AND SysFile) <> 0
END;  { IsSysFile }

{--------------------}

FUNCTION IsVolumeID(FName : Str80) : BOOLEAN;

VAR
 f     : FILE;
 fAttr : WORD;

BEGIN
 ASSIGN(f, FName);
 GetFAttr(f, fAttr);
 IsVolumeID := (fAttr AND VolumeID) <> 0
END;  { IsVolumeID }

{--------------------}

FUNCTION IsDirectory(FName : Str80) : BOOLEAN;

VAR
 f     : FILE;
 fAttr : WORD;

BEGIN
 ASSIGN(f, FName);
 GetFAttr(f, fAttr);
 IsDirectory := (fAttr AND Directory) <> 0
END;  { IsDirectory }

{--------------------}

FUNCTION IsArchived(FName : Str80) : BOOLEAN;

VAR
 f     : FILE;
 fAttr : WORD;

BEGIN
 ASSIGN(f, FName);
 GetFAttr(f, fAttr);
 IsArchived := (fAttr AND Archive) = 0
END;  { IsArchived }

END. { UNIT FileStuf }
