{ EXISTS40.INC }
{
Description:  Advanced functions to test for the existence of a specified
              file or directory. Detects the presence of the file or dir-
              ectory, even if it is marked as read-only or it is a hidden
              or system entity.

Author:       Don Taylor
Date:         12/17/87
Last revised: 04/18/88 8:45 (Made corrections per "TUG's Bugs", Issue 24)
Application:  IBM PC or compatible with Turbo Pascal 4.0
}


FUNCTION FileExists(FName : Str80) : BOOLEAN;

VAR
 f     : FILE;
 fAttr : WORD;

BEGIN
 ASSIGN(f, FName);
 GetFAttr(f, fAttr);
 FileExists := (DosError = 0)
                AND ((fAttr AND Directory) = 0)
                AND ((fAttr AND VolumeID)  = 0)
END;  { FileExists }

{--------------------}

FUNCTION DirExists(DName : Str80) : BOOLEAN;

VAR
 f     : FILE;
 fAttr : WORD;

BEGIN
 ASSIGN(f, DName);
 GetFAttr(f, fAttr);
 DirExists := ((fAttr AND Directory) <> 0) AND (DosError = 0)
END;  { DirExists }
