{CTYPE.PAS}
{
Description:  Unit to emulate the character handling functions provided
              in the ctype.h header file in the C language.

Author:       Eric Kammerer
Date:         11/23/87
Application:  IBM PC with Turbo Pascal 4.0
}

UNIT CType;

INTERFACE

    FUNCTION IsAlnum (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a letter:
                ('A'..'Z','a'..'z')
            Returns FALSE otherwise.
        }

    FUNCTION IsAlpha (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a letter or a digit:
                ('A'..'Z','a'..'z','0'..'9')
            Returns FALSE otherwise.
        }

    FUNCTION IsAscii (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a standared ASCII character:
                (#0..#127)
            Returns FALSE otherwise.
        }

    FUNCTION IsCntrl (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a delete character or an ordinary 
            control character:
                (#0..#31,#127)
            Returns FALSE otherwise.
        }

    FUNCTION IsDigit (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a digit:
                ('0'..'9')
            Returns FALSE otherwise.
        }

    FUNCTION IsGraph (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a printing character, like IsPrint, 
            except that a space character is excluded:
                (#33..#126)
            Returns FALSE otherwise.
        }

    FUNCTION IsLower (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a lowercase letter:
                ('a'..'z')
            Returns FALSE otherwise.
        }

    FUNCTION IsPrint (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a printing character:
                (#32..#126)
            Returns FALSE otherwise.
        }

    FUNCTION IsPunct (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a punctuation character:
                (IsCntrl or IsSpace)
            Returns FALSE otherwise.
        }

    FUNCTION IsSpace (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a space, tab, carriage return, 
            newline, vertical tab, or form-feed:
                (#9..#13,#32)
            Returns FALSE otherwise.
        }

    FUNCTION IsUpper (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is an uppercase letter:
                ('A'..'Z')
            Returns FALSE otherwise.
        }

    FUNCTION IsXDigit (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a hexadecimal digit:
                ('0'..'9','A'..'F','a'..'f')
            Returns FALSE otherwise.
        }


IMPLEMENTATION

    FUNCTION IsAlnum (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a letter:
                ('A'..'Z','a'..'z')
            Returns FALSE otherwise.
        }
    BEGIN

        IsAlnum :=  ch IN ['A'..'Z','a'..'z'];

    END;

    FUNCTION IsAlpha (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a letter or a digit:
                ('A'..'Z','a'..'z','0'..'9')
            Returns FALSE otherwise.
        }
    BEGIN

        IsAlpha := ch IN ['A'..'Z','a'..'z','0'..'9'];

    END;

    FUNCTION IsAscii (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a standared ASCII character:
                (#0..#127)
            Returns FALSE otherwise.
        }
    BEGIN

        IsAscii := ch IN [#0..#127];

    END;

    FUNCTION IsCntrl (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a delete character or an ordinary 
            control character:
                (#0..#31,#127)
            Returns FALSE otherwise.
        }
    BEGIN

        IsCntrl := ch IN [#0..#31,#127];

    END;

    FUNCTION IsDigit (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a digit:
                ('0'..'9')
            Returns FALSE otherwise.
        }
    BEGIN

        IsDigit := ch IN ['0'..'9'];

    END;

    FUNCTION IsGraph (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a printing character, like IsPrint, 
            except that a space character is excluded:
                (#33..#126)
            Returns FALSE otherwise.
        }
    BEGIN

        IsGraph := ch IN [#33..#126];

    END;

    FUNCTION IsLower (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a lowercase letter:
                ('a'..'z')
            Returns FALSE otherwise.
        }
    BEGIN

        IsLower := ch IN ['a'..'z'];

    END;

    FUNCTION IsPrint (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a printing character:
                (#32..#126)
            Returns FALSE otherwise.
        }
    BEGIN

        IsPrint := ch IN [#32..#126];

    END;

    FUNCTION IsPunct (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a punctuation character:
                (IsCntrl or IsSpace)
            Returns FALSE otherwise.
        }
    BEGIN

        IsPunct := ch IN [#0..#32,#127];

    END;

    FUNCTION IsSpace (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a space, tab, carriage return, 
            newline, vertical tab, or form-feed:
                (#9..#13,#32)
            Returns FALSE otherwise.
        }
    BEGIN

        IsSpace := ch IN [#9..#13,#32];

    END;

    FUNCTION IsUpper (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is an uppercase letter:
                ('A'..'Z')
            Returns FALSE otherwise.
        }
    BEGIN

        IsUpper := ch IN ['A'..'Z'];

    END;

    FUNCTION IsXDigit (ch : CHAR) : BOOLEAN;
        {
            Returns TRUE if ch is a hexadecimal digit:
                ('0'..'9','A'..'F','a'..'f')
            Returns FALSE otherwise.
        }
    BEGIN

        IsXDigit := ch IN ['0'..'9','A'..'F','a'..'f'];

    END;


END.