{======================================================================}
UNIT LOADFILE;

INTERFACE
USES IOSTUFF,CRT;
PROCEDURE Load_ASCII(AFile : AnyStr);
PROCEDURE Load_MEM(MFile : AnyStr);
PROCEDURE Load_PAK(PFile:AnyStr);

IMPLEMENTATION
VAR
   TempStr : AnyStr;

{======================================================================}
PROCEDURE Load_ASCII(AFile : AnyStr);
{                                                     }
{ This routine loads an ASCII format file as created  }
{ by BOX onto the screen.                             }
{                                                     }

VAR
    FilevarA   : Text;
    II         : Integer;

BEGIN
      Assign(FilevarA,AFile);
      {$I-} Reset(FilevarA); {$I+}
      If IOresult = 0 then                        {found good file name}
       Begin
        ClrScr;
        For II := 1 to 25 do
        Begin
         Readln(FilevarA,TempStr);
         GoToXY(1,II);
         Write(TempStr);
        End;
        Close(FilevarA);
       End

      Else                                        {couldn't find file  }
        Begin
          GoToXY(1,24);
          Write('ERROR - Could not find file');
        End;

END; {Load_ASCII}

{======================================================================}
PROCEDURE Load_MEM(MFile : AnyStr);
{                                                     }
{ This routine loads a memory format file as created  }
{ by BOX directly into the video buffer.  Since a     }
{ memory format file is the same shape as the video   }
{ buffer, all that needs to be done is to move the    }
{ screen into the buffer with MoveToScreen in IOSTUFF.}
{                                                     }

VAR
    FilevarM   : File;
    LoadScr    : Screen;

BEGIN
      Assign(FilevarM,MFile);
      {$I-} Reset(FilevarM,4000); {$I+}
      If IOresult = 0 then                        {found good file name}
        Begin
          BlockRead(FilevarM,LoadScr,1);
          MoveToScreen(LoadScr,Video^,4000);
          Close(FilevarM);
        End
      Else                                        {couldn't find file  }
        Begin
          GoToXY(1,24);
          Write('ERROR - Could not find file ',MFile);
        End;
END; {Load_MEM}

{======================================================================}
PROCEDURE Load_PAK(PFile:AnyStr);
{                                                     }
{ This procedure loads a Packed Format screen created }
{ by BOX.  The Packed format utilizes a run-length    }
{ encoding scheme that must be unpacked.  Each record }
{ in a Packed Format file is three bytes long. Byte 1 }
{ is the run length, i.e. the number of characters to }
{ repeat.  Byte 2 is the character to repeat and      }
{ byte 3 is the attribute of the character.           }
{                                                     }
TYPE
   Pack        = Record
                  PackNm : Byte;  {run length}
                  PackCh : Char;  {repeated character}
                  PackAt : Byte;  {repeated attribute}
                 End;

VAR
    FilevarM   : File;
    LoadScr    : Screen;
    Packbuf    : Array[1..2000] of Pack;
    II,JJ,Sloc,SX,SY,NumRec  : Integer;

BEGIN
   Sloc := 1;              {SLoc is location on screen}
   Assign(FilevarM,PFile);
   {$I-} Reset(FilevarM); {$I+}
   If IOresult = 0 then          {found good file name}
     Begin
        BlockRead(FilevarM,PackBuf,48,NumRec);  
        JJ := 0;
        While Sloc < 2001 do 
        Begin
          JJ := JJ + 1;
          For II := 1 to Packbuf[JJ].PackNm do  
           Begin
            SY := (SLoc-1) div 80 + 1;       {row}
            SX := (SLoc-1) mod 80 + 1;       {column}
            LoadScr[SY,SX].ScrCh := Packbuf[JJ].PackCh; 
            LoadScr[SY,SX].ScrAt := Packbuf[JJ].PackAt;
            SLoc := SLoc + 1;   
           End;
        End;
        MoveToScreen(LoadScr,Video^,4000);
        Close(FilevarM);
   End
   Else                            {couldn't find file}
     Begin
       GoToXY(1,24);
       Write('ERROR - Could not find file');
     End;
END;

END.
