{                      F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with FIELD.PAS.

* ASSOCIATED FILES
FIELD.PAS
FLDDEMO.PAS
FLDTEST.PAS
OLDDEMO.PAS
FIELD.TXT

}
Program fielddemo;

{N+}

Uses Crt,Dos,field;

Type linestring = String[80];
     namestring = String[16];
     direction  = (up,down,left,right);
     component  = 1..28;

Const nextfldnum: Array[component,direction] Of Byte
                  = ((10,2,21,11),
                     (1,3,22,12),
                     (2,4,23,13),
                     (3,5,24,14),
                     (4,6,25,15),
                     (5,7,26,16),
                     (6,8,27,17),
                     (7,9,28,18),
                     (8,10,19,19),
                     (9,1,20,20),
                     (20,12,1,21),
                     (11,13,2,22),
                     (12,14,3,23),
                     (13,15,4,24),
                     (14,16,5,25),
                     (15,17,6,26),
                     (16,18,7,27),
                     (17,19,8,28),
                     (18,20,9,9),
                     (19,11,10,10),
                     (28,22,11,1),
                     (21,23,12,2),
                     (22,24,13,3),
                     (23,25,14,4),
                     (24,26,15,5),
                     (25,27,16,6),
                     (26,28,17,7),
                     (27,21,18,8));

      compname: Array[component] Of namestring
                = ( 'Hydrogen',
                    'Nitrogen',
                    'Oxygen',
                    'Water',
                    'Carbon Monoxide',
                    'Carbon Dioxide',
                    'Hydrogen Sulfide',
                    'Sulfur Dioxide',
                    'Benzene',
                    'Toluene',
                    'Methane',
                    'Ethane',
                    'Propane',
                    'i-Butane',
                    'n-Butane',
                    'Neopentane',
                    'i-Pentane',
                    'n-Pentane',
                    'n-Hexane',
                    'n-Heptane',
                    'Ethylene',
                    'Propylene',
                    'i-Butane',
                    '1-Butene',
                    't-2-Butene',
                    'c-2-Butene',
                    '1-Pentene',
                    '1,3-Butadiene' );

      compmolewt: Array[component] Of Real
                 = (  2.016,
                     28.013,
                     31.999,
                     18.015,
                     18.010,
                     44.010,
                     34.076,
                     64.059,
                     78.114,
                     92.141,
                     16.043,
                     30.070,
                     44.097,
                     58.124,
                     58.124,
                     72.151,
                     72.151,
                     72.151,
                     86.178,
                    100.205,
                     28.054,
                     42.081,
                     56.108,
                     56.108,
                     56.108,
                     56.108,
                     70.135,
                     54.092 );

      maxcompnum = 28;

Var fldnum: Byte;
    maxfldnum: Byte;
    fldlength: Byte;
    decpla: Byte;
    returnkey: Byte;
    startrow: Byte;
    rowcount: Byte;
    compcount: Byte;
    count: Byte;
    compnumber: Byte;
    maxrow: Byte;

    col: Array[1..3] Of Byte;
    colindex: Byte;

    totalmassflow: Real;
    totalmoleflow: Real;
    moleweight: Real;

    text: linestring;
    value: linestring;

    success: Boolean;

    compmassflow: Array[component] Of Real;
    compmoleflow: Array[component] Of Real;


Procedure beep;

Begin
  Write(chr(7))
End;

Begin
  reversevideo:=False;
  zerovoid:=True;
  hitxtcolor:=Yellow;
  lotxtcolor:=LightGray;
  txtbkgnd:=Black;
  cursor(hidden);
  TextMode(CO80);
  TextColor(lotxtcolor);
  TextBackground(txtbkgnd);

  Repeat

    ClrScr;
    For count:=1 To maxcompnum Do compmassflow[count]:=0;

    text:='Refinery Gas Molecular Weight';
    GotoXY(39-(length(text) Div 2),2);
    Write(text);

    startrow:=6;
    col[1]:=1;
    col[2]:=31;
    col[3]:=55;
    colindex:=1;
    rowcount:=0;
    compcount:=0;
    maxrow:=10;

    Repeat
      Repeat
        GotoXY(col[colindex],startrow+rowcount);
        inc(compcount);
        If compcount <= maxcompnum Then Write(compname[compcount]);
        Inc(rowcount);
      Until rowcount = maxrow;
      Inc(colindex);
      rowcount:=0
    Until compcount >= maxcompnum;

    maxfldnum:=maxcompnum;
    fldlength:=7;
    decpla:=0;
    col[1]:=19;
    col[2]:=43;
    col[3]:=70;
    fldnum:=1;
    firstpass:=True;

    Repeat

      Repeat
        rowcount:=0;
        compnumber:=1;
        colindex:=1;
        success:=False;

        Repeat
          Repeat
            If compnumber = fldnum Then
              Begin
                returnkey:=editfield(col[colindex],
                                     startrow+rowcount,
                                     fldlength,
                                     decpla,
                                     usndec,
                                     optional,
                                     compmassflow[fldnum]);
                compmoleflow[fldnum]:=compmassflow[fldnum]/compmolewt[fldnum];
                success:=True
              End;
            Inc(compnumber);
            Inc(rowcount);
          Until rowcount = maxrow;
          Inc(colindex);
          rowcount:=0;
        Until success;

        Case returnkey Of
          enterkey:
              If fldnum < maxfldnum
              Then inc(fldnum)
              Else fldnum:=0;
          uparrowkey:
              fldnum:=nextfldnum[fldnum,up];
          dnarrowkey:
              fldnum:=nextfldnum[fldnum,down];
          tabkey:
              fldnum:=nextfldnum[fldnum,right];
          shiftabkey:
              fldnum:=nextfldnum[fldnum,left];
          esckey:
              If firstpass
              Then beep
              Else fldnum:=0
          Else
        End;

      Until fldnum = 0;

      totalmassflow:=0;
      totalmoleflow:=0;
      For compnumber:= 1 To maxcompnum Do
        Begin
          totalmassflow:=totalmassflow+compmassflow[compnumber];
          totalmoleflow:=totalmoleflow+compmoleflow[compnumber]
        End;
      If totalmoleflow <> 0 Then
        moleweight:=totalmassflow/totalmoleflow
      Else moleweight:=0;

      note('END to Accept, ENTER to Edit, ESC to exit');
      Repeat
        returnkey:=getspecialkey;
        If (returnkey <> endkey) And
           (returnkey <> enterkey) And
           (returnkey <> esckey)
        Then
          errmsg('Must be END (Accept), ENTER (Edit), Or ESC (Exit)')
      Until
           (returnkey = endkey) Or
           (returnkey = enterkey) Or
           (returnkey = esckey);
      If returnkey = enterkey Then
        Begin
          firstpass:=False;
          fldnum:=1
        End;


    Until
         (returnkey = endkey) Or
         (returnkey = esckey);
    If returnkey = endkey Then
      Begin
        GotoXY(1,startrow+13);
        Write('Total Stream Flow Rate lb/hr =      ',totalmassflow:10:0);
        GotoXY(1,startrow+14);
        Write('Total Stream Flow Rate, lb-moles/hr = ',totalmoleflow:8:1);
        GotoXY(1,startrow+15);
        Write('Total Stream Molecular Weight =        ',moleweight:7:3);
        note('ENTER to Run Another Case, or ESC to Exit');
        While ((returnkey <> enterkey) And (returnkey <> esckey)) Do
          Begin
            returnkey:=getspecialkey;
            If ((returnkey <> enterkey) And (returnkey <> esckey)) Then
              errmsg('Must be ENTER (New Case), or ESC (Exit)')
          End
      End
    Else;

  Until returnkey = esckey;
  cursor(underline);
  NormVideo;
End.

