{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with EZ.PAS.

* ASSOCIATED FILES
EZ.PAS
BINED.TPU
EZ.DOC
EZ.EXE
EZ.OBJ
EZS.EXE
EZS.OVR
EZ0.PAS
EZ1.PAS
EZ2.PAS
EZ3.PAS
EZINVOKE.TPU
GETFILES.PAS
GETSUB.PAS
GLOBALS.PAS
INVOKE.TPU
MENU.PAS
POPSCRN.TPU
PRINTDOC.BAT
PTROP.TPU
SCRNHEAP.PAS

* CHECKED BY
DRM - 03/14/88

* KEYWORDS
CONTEST TUG-O-WARDS PROGRAM PASCAL V4.0

==========================================================================
}
UNIT SCRNHEAP;

INTERFACE
  USES CRT,
       DOS;

  type
    HeapBuf     = ^AnyBuf;
    AnyBuf      =  Record
                     ScreenImage : array[0..4000] of byte;
                   end;
    AnyString   = String[255];

  const
    RamScreen  =10;

  var
    Screen                : array[0..RamScreen] of HeapBuf;
    startseg,
    startoff              : Array[1..RamScreen] of Word;
    ColorScreen           : Array[0..4096] of char absolute $0b800:$00;
    MonoScreen            : Array[0..4096] of char absolute $0b000:$00;
    DisplayMode           : Integer;


  Procedure VideoMode;
  Procedure CursorOff;
  Procedure CursorOn;
  Procedure PutStr(s: AnyString; x1,y1,att: Integer);
  Procedure RemBlkR(x1,y1,x2,y2,att: Integer; Shadow: Boolean);
  Procedure Box(x1,y1,x2,y2,att,style: Integer);
  Procedure ClearBox(x1,y1,x2,y2,att,style: Integer; Shadow: Boolean);
  Procedure GetStr(var s: AnyString; x1,y1,num: Integer);
  Procedure SetAtt(x1,y1,x2,y2,att: Integer);
  Procedure bf(background, foreground: Integer);

  Procedure IHP;
  Procedure FillHeap(Page, x1,y1,x2,y2: Integer; ch: Char; att: Byte);
  Procedure SaveScreen(Page: Integer);
  Procedure RestoreScreen(Page: Integer);
  Procedure P_2_P(Source,Dest: integer);
  Procedure Heap2Scr(Page,x1,y1,x2,y2,x3,y3: Integer);
  Procedure Scr2Heap(Page,x1,y1,x2,y2,x3,y3: Integer);
  Procedure PutHeap (Page: Integer; s: AnyString; x1,y1,att: Integer);
  Procedure BoxHeap(Page,x1,y1,x2,y2,att,style: Integer);
  Procedure ClearBoxHeap(Page,x1,y1,x2,y2,att,style: Integer);
  Procedure HeapAt(Page, x1,y1,x2,y2,att: Integer);

IMPLEMENTATION

{//////////////////////////////////////////////////////////////////////////
 ////                  S C R E E N   S E C T I O N                     ////
 ////                                                                  ////
 /////////////////////////////////////////////////////////////////////////}

{--------------------------------------------------------------------------}
Procedure VideoMode;
  var
    regs       : Registers;
  begin
    With regs do begin
      AH := 15;
      Intr($10,regs);
      DisplayMode := AL;
    end;
  end; {VideoMode}

{---------------------------------------------------------------------------}
Procedure CursorOff;
  var
    regs         : Registers;
  begin
    with regs do begin
      cx := $2000;
      ax := $0100;
      intr($10,regs);
   end;
end { CursorOff };

{----------------------------------------------------------------------------}
Procedure CursorOn;
  var
    regs         : Registers;
  begin
   with regs do begin
     if DisplayMode = 7 then
       cx := $0C0D  { Monochrome }
     else
       cx := $0607; { Color }
       ax := $0100;
       intr($10,regs);
   end;
end { CursorOn };

{----------------------------------------------------------------------------}
Procedure PutStr(* s: AnyString; x1,y1,att: Integer *);

  const
      mono_seg:         word = $B000;
      color_seg:        word = $B800;

  var
    screen_seg,
    start_offset,
    current_offset,
    i:                integer;

  begin
    If DisplayMode = 7 then
      screen_seg := mono_seg
    else
      screen_seg := color_seg;
    start_offset := (((y1 - 1) * 80) + (x1 - 1)) * 2;

    for i := 1 to Length(s) do begin
      current_offset := start_offset + ((i - 1) * 2);
      Mem[screen_seg:current_offset] := Byte(s[i]);
      Mem[screen_seg:current_offset + 1] := att;
    end;
  end; {PutStr}

{------------------------------------------------------------------------}
Procedure RemBlkR(* x1,y1,x2,y2,att: Integer; Shadow: Boolean *);
  const
    SHADE = #176;

  var
    regs        : Registers;
    foreground,
    background,
    y,
    x            : Integer;

  begin
    background:=att div 16;
    foreground:=att mod 16;
    With regs do begin
      AH := 7;              { Select the scroll window option.         }
      AL := 0;              { Set to 0 to clear the whole window.      }
      CL := x1 - 1;
      CH := y1 - 1;
      DL := x2 - 1;
      DH := y2 - 1;
      BH := (background shl 4) + foreground;  { Set attribute byte }
      Intr($10, regs);
    end;
    if Shadow then begin
      for y:=y1+1 to y2+1 do begin
        for x:=x1-2 to x1-1 do PutStr(SHADE,x,y,background);
      end;
      for x:=x1-2 to x2-2 do PutStr(SHADE,x,y2+1,background);
    end;
  end;  {Clear Block

{----------------------------------------------------------------------------}
Procedure Box(* x1,y1,x2,y2,att,style: Integer *);

 { Box - Draws a Box  using one of five styles. They are:
           1:  Single
           2:  Double
           3:  Combination. Double top & bottom, single sides
           4:  Combination. Single top & bottom, double sides
           5:  Wide block type box
                                                                     }
  var
    horiz_char, vert_char:      Char;
    ul_corner:                  Char;
    ur_corner:                  Char;
    ll_corner:                  Char;
    lr_corner:                  Char;
    i:                          Integer;

  begin
    Case style of
      1: begin                             { Use continuous single line. }
           horiz_char := char(196);
           vert_char  := char(179);
           ul_corner  := char(218);
           ur_corner  := char(191);
           ll_corner  := char(192);
           lr_corner  := char(217);
         end;
      2: begin                             { Use continuous double line. }
            horiz_char := char(205);
            vert_char  := char(186);
            ul_corner  := char(201);
            ur_corner  := char(187);
            ll_corner  := char(200);
            lr_corner  := char(188);
          end;
      3: begin                             { Use combined double & single.}
           horiz_char := char(205);
            vert_char  := char(179);
            ul_corner  := char(213);
            ur_corner  := char(184);
            ll_corner  := char(212);
            lr_corner  := char(190);
          end;
       4: begin                             { Use continuous single line. }
           horiz_char := char(196);
           vert_char  := char(186);
           ul_corner  := char(214);
           ur_corner  := char(183);
           ll_corner  := char(211);
           lr_corner  := char(189);
         end;
       5: begin                             { Use continuous heavy line. }
            horiz_char := char(219);
            vert_char  := char(219);
            ul_corner  := char(219);
            ur_corner  := char(219);
            ll_corner  := char(219);
            lr_corner  := char(219);
         end;
    end;  { Case h_char }

    PutStr(ul_corner,x1,y1,att);      { Draw upper left corner. }

    for i := x1 + 1 to x2 - 1 do
      PutStr(horiz_char,i,y1,att);    { Draw upper horizontal line. }

    PutStr(ur_corner,x2,y1,att);      { Draw upper right corner. }

    for i := y1+1 to y2- 1 do begin        { Draw vertical lines. }
      PutStr(vert_char,x1,i,att);
      PutStr(vert_char,x2,i,att);
    end;

    PutStr(ll_corner,x1,y2,att);      { Draw lower left corner. }

    for i := x1 + 1 to x2 - 1 do
      PutStr(horiz_char,i,y2,att);     { Draw bottom horizontal line. }
      PutStr(lr_corner,x2,y2,att);      { Draw lower right corner. }
end;  {Box}

{----------------------------------------------------------------------------}
Procedure ClearBox(* x1,y1,x2,y2,att,style: Integer: Shadow: Boolean *);
  begin
    RemBlkR(x1,y1,x2,y2,att,Shadow);
    Box(x1,y1,x2,y2,att,style);
  end;

{----------------------------------------------------------------------------}
Procedure GetStr(* var s: AnyString; x1,y1,num: Integer *);

  const
      mono_seg:         word = $B000;   { Starting address of mono memory }
      color_seg:        word = $B800;   { Starting address of color memory}

  var
    screen_seg,
    start_offset,
    current_offset,
    i:                integer;

  begin
    if DisplayMode = 7 then
      screen_seg := mono_seg
    else
      screen_seg := color_seg;
    start_offset := (((y1 - 1) * 80) + (x1 - 1)) * 2;
    s:= '';

    for i := 1 to num do begin
      current_offset := start_offset + ((i - 1) * 2);
      s:= s + Chr(Mem[screen_seg:current_offset]);
    end;
  end; {ReadStr}

{------------------------------------------------------------------------}
 Procedure SetAtt(* x1,y1,x2,y2,att: Integer *);
   const
      mono_seg:         word = $B000;   { Starting address of mono memory }
      color_seg:        word = $B800;   { Starting address of color memory}

   var
     screen_seg,
     current_offset,
     i,j               : Integer;
     s                 : Char;

   begin
     if DisplayMode = 7 then
       screen_seg := mono_seg
     else
       screen_seg := color_seg;

     for j:=y1 to y2 do begin
       for i := x1 to x2 do begin
        current_offset := (((j - 1) * 80) + (i - 1)) * 2;
        Mem[screen_seg:current_offset + 1] := att;
       end; {i}
     end; {j}
   end; {Set Attribute}

{------------------------------------------------------------------------}
Procedure bf(* background, foreground: Integer *);
  begin
    TextBackGround(background);
    TextColor(foreground);
  end;

{-------------------------------------------------------------------------}

{//////////////////////////////////////////////////////////////////////////
 ////                     H E A P    S E C T I O N                     ////
 ////                                                                  ////
 /////////////////////////////////////////////////////////////////////////}

{--------------------------------------------------------------------------}
Procedure IHP;

 { IHP - Initialize Ram Screen. This procedure reserves memory in heap
         for RAMSCREENS of screens.  As it reserves each screen
         screen, the procedure finds the beginning segment and offset
         of each screen and clears the screen by copying a blank screen.

         As part of the initializtion process this routine determines
         if the screen is Color or Mono
                                                                       }
  var
    i                 : Integer;
    regs              : Registers;

  begin
    for i:=0 to RamScreen do begin
      new(screen[i]);
      startseg[i]:=seg(screen[i]^);   {Get Segment of start of Ram Screen}
      startoff[i]:=ofs(screen[i]^);   {Get Offset of start of Ram Screen}
      fillchar(screen[i]^.screenimage,4096,0);
    end;

    With regs do begin                  { Use interrupt hex 15 to determine  }
      AH:=15;                           { the display mode.  Modes 0 - 6     }
      Intr($10,regs);                   { indicate the color monitor is in   }
      DisplayMode:=AL;                  { use.  Mode 7 indicates monochrome. }
    end;
  end; {Initialize Heap Pages}

{---------------------------------------------------------------------}
Procedure FillHeap(* Page,x1,y1,x2,y2: Integer; ch: Char; att: Byte *);
  var
    i,
    y,
    x,
    offset               : Integer;
    s                    : Array[1..160] of Byte;

  begin
    fillchar(s,SizeOf(s),ord(ch));
    i:=(x2-x1)+1;
    x:=2;
    repeat
      s[x]:=att;
      dec(i);
      inc(x);
      inc(x);
    until i=0;
    i:=(x2-x1)+1;
    i:=i*2;
    for y:=y1 to y2 do begin
      offset := (((y - 1) * 80) + (x1 - 1)) * 2;
      move(s,screen[page]^.screenimage[offset],i);
    end;{for y=y1 to y2}
  end; {Fill Heap}

{--------------------------------------------------------------------------}
Procedure SaveScreen(* Page: Integer *);
 { SaveScreen - Saves current screen to desiginated heap Page}
  begin
    if DisplayMode = 7 then
      move(MonoScreen,screen[Page]^.screenimage,4096)
    else
      move(ColorScreen,screen[Page]^.screenimage,4096);
  end; {End procedure Save Ram Screen}

{--------------------------------------------------------------------------}
Procedure RestoreScreen(* Page: Integer *);
{RestoreScreen - Moves the contents of Heap Page to Screen }
  begin
    if DisplayMode = 7 then
      move(screen[Page]^.screenimage,MonoScreen,4096)
    else
      move(screen[Page]^.screenimage,ColorScreen,4096);
  end; {Restore Screen}

{--------------------------------------------------------------------------}
Procedure P_2_P(* Source,Dest: integer *);
 { Page to Page - Copies contents of one Heap Page to another}
  begin
    move(screen[Source]^.screenimage,screen[Dest]^.screenimage,4096);
  end; {P_2_P);

{-------------------------------------------------------------------------}
Procedure Heap2Scr(* Page,x1,y1,x2,y2,x3,y3: Integer *);
  var
   i,
   y,
   offset,
   offset1        : Integer;
  begin
    i:=(x2-x1);
    inc(i);
    i:=i*2;
    for y:=y1 to y2 do begin
      offset := (((y - 1) * 80) + (x1 - 1)) * 2;
      offset1 := (((y3 - 1) * 80) + (x3 - 1)) * 2;
      if DisplayMode=7 then
        move(screen[Page]^.screenimage[offset],MonoScreen[offset1],i)
      else
        move(screen[Page]^.screenimage[offset],ColorScreen[offset1],i);
      inc(y3);
    end;  {for y=y1 to y2}
  end; {Heap to Screen}

{-----------------------------------------------------------------------}
Procedure Scr2Heap(* Page,x1,y1,x2,y2,x3,y3: Integer *);
  var
   i,
   y,
   offset,
   offset1        : Integer;
  begin
    i:=(x2-x1);
    inc(i);
    i:=i*2;
    for y:=y1 to y2 do begin
      offset := (((y - 1) * 80) + (x1 - 1)) * 2;
      offset1 := (((y3 - 1) * 80) + (x3 - 1)) * 2;
      if DisplayMode=7 then
        move(MonoScreen[offset],screen[Page]^.screenimage[offset1],i)
      else
        move(ColorScreen[offset],screen[Page]^.screenimage[offset1],i);
      inc(y3);
    end; {for y=y1 to y2}
  end; {Screen to Heap}

{------------------------------------------------------------------------}
Procedure PutHeap (* Page: Integer; s: AnyString; x1,y1,att: Integer *);
 {PutHeap - Writes string (s) to desiginated heap Page}

  var
    i,
    x,
    offset          : Integer;

  begin
    offset := (((y1 - 1) * 80) + (x1 - 1)) * 2;
    for i:=1 to length(s) do begin
      screen[Page]^.screenimage[offset]:=Byte(s[i]);
      inc(offset);
      screen[Page]^.screenimage[offset]:=att;
      inc(offset)
    end;
  end; {PutHeap}

{--------------------------------------------------------------------------}
Procedure BoxHeap(* Page,x1,y1,x2,y2,att,style: Integer *);

 { BoxHeap - Draws a Box to desiginated heap Page using one
             of five styles. They are:
               1:  Single
               2:  Double
               3:  Combination. Double top & bottom, single sides
               4:  Combination. Single top & bottom, double sides
               5:  Wide block type box
                                                                     }
  var
    horiz_char, vert_char:      Char;
    ul_corner:                  Char;
    ur_corner:                  Char;
    ll_corner:                  Char;
    lr_corner:                  Char;
    i:                          Integer;

  begin
    Case style of
      1: begin                             { Use continuous single line. }
           horiz_char := char(196);
           vert_char  := char(179);
           ul_corner  := char(218);
           ur_corner  := char(191);
           ll_corner  := char(192);
           lr_corner  := char(217);
         end;
      2: begin                             { Use continuous double line. }
            horiz_char := char(205);
            vert_char  := char(186);
            ul_corner  := char(201);
            ur_corner  := char(187);
            ll_corner  := char(200);
            lr_corner  := char(188);
          end;
      3: begin                             { Use combined double & single.}
           horiz_char := char(205);
            vert_char  := char(179);
            ul_corner  := char(213);
            ur_corner  := char(184);
            ll_corner  := char(212);
            lr_corner  := char(190);
          end;
       4: begin                             { Use continuous single line. }
           horiz_char := char(196);
           vert_char  := char(186);
           ul_corner  := char(214);
           ur_corner  := char(183);
           ll_corner  := char(211);
           lr_corner  := char(189);
         end;
       5: begin                             { Use continuous heavy line. }
            horiz_char := char(219);
            vert_char  := char(219);
            ul_corner  := char(219);
            ur_corner  := char(219);
            ll_corner  := char(219);
            lr_corner  := char(219);
         end;
    end;  { Case h_char }

    PutHeap(Page,ul_corner,x1,y1,att);      { Draw upper left corner. }

    for i := x1 + 1 to x2 - 1 do
      PutHeap(Page,horiz_char,i,y1,att);    { Draw upper horizontal line. }

    PutHeap(Page,ur_corner,x2,y1,att);      { Draw upper right corner. }

    for i := y1+1 to y2- 1 do begin        { Draw vertical lines. }
      PutHeap(Page,vert_char,x1,i,att);
      PutHeap(Page,vert_char,x2,i,att);
    end;

    PutHeap(Page,ll_corner,x1,y2,att);      { Draw lower left corner. }

    for i := x1 + 1 to x2 - 1 do
      PutHeap(Page,horiz_char,i,y2,att);     { Draw bottom horizontal line. }
      PutHeap(Page,lr_corner,x2,y2,att);      { Draw lower right corner. }
end;  {Heap Box}

{--------------------------------------------------------------------------}
Procedure ClearBoxHeap(* Page,x1,y1,x2,y2,att,style: Integer *);
 {ClearBoxHeap - Clears area in heap and draws box around border}
  begin
    FillHeap(Page,x1,y1,x2,y2,#32,att);
    BoxHeap(Page,x1,y1,x2,y2,att,style);
  end; {Clear HeapBox}

{--------------------------------------------------------------------------}
Procedure HeapAt(* Page, x1,y1,x2,y2,att: Integer *);
 { HeapAt - Sets attribute on desiginated page to that of att}
  var
    x,
    y,
    offset          : Integer;

  begin
    for y:=y1 to y2 do begin
      for x:=x1 to x2 do begin
        offset := (((y - 1) * 80) + (x - 1)) * 2;
        inc(offset);
        screen[Page]^.screenimage[offset]:=att;
        inc(offset)
      end;
    end; {for y=y1 to y2}
  end; {PutHeap}

{--------------------------------------------------------------------------}


BEGIN
END.

