{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with EZ.PAS.

* ASSOCIATED FILES
EZ.PAS
BINED.TPU
EZ.DOC
EZ.EXE
EZ.OBJ
EZS.EXE
EZS.OVR
EZ0.PAS
EZ1.PAS
EZ2.PAS
EZ3.PAS
EZINVOKE.TPU
GETFILES.PAS
GETSUB.PAS
GLOBALS.PAS
INVOKE.TPU
MENU.PAS
POPSCRN.TPU
PRINTDOC.BAT
PTROP.TPU
SCRNHEAP.PAS

==========================================================================
}
UNIT GetSub;

INTERFACE

  USES DOS,
       CRT,
       SCRNHEAP,
       MENU,
       GLOBALS;


  Procedure ChooseDrive(var Drive: Char);
  Procedure ChooseSubdirectory(drive: Char;  var sub: AnyString; x1,y1,
                               Main, High, HelpAtt: ShortInt);
  Procedure FindSubdirectory(Drive: Char);


IMPLEMENTATION

{---------------------------------------------------------------------------}
Procedure ChooseDrive(* var Drive: Char *);
  var
    DirMain,
    DirShade,
    Highlight       : Byte;
    HelpStyle,
    NumberOfDrives,
    x2              : ShortInt;

  begin
    EscDepressed:=False;
    if monitor=1 then begin
      DirMain  :=31;
      DirShade :=1;
      Highlight:=79;
    end
    else begin
      DirMain :=15;
      DirShade:=7;
      Highlight :=112;
    end;
  {---------------------- Determine Number of Drives ----------------}
    with regs do begin
      AH:=25;
      MsDos(regs);
      DL:=AL;
      AH:=14;
      MsDos(regs);
      NumberOfDrives:=AL;
    end;

    x2:=9+NumberOfDrives;

    Case NumberOfDrives of
       1..13: begin
                ClearBox(12,5,27,x2,DirMain,2,True);
                PutStr('Drive',17,6,DirMain);
                HelpStyle:=2;
              end; {1-13}
      14..26: begin
                ClearBox(12,5,32,x2,DirMain,2,True);
                PutStr('Drive',19,6,DirMain);
                HelpStyle:=3;
              end; {14-26}
    end; {Case Number of Drives of}

    ChooseMenu(1,NumberOfDrives,HelpStyle,DirMain,Highlight,True,False,0,0,0);
    if not EscDepressed then Drive:=chr(64+value);
  end; {Choose Drive}



{-------------------------------------------------------------------------}
Procedure ChooseSubdirectory(* drive: Char;  var sub: AnyString; x1,y1,
                             Main, High, HelpAtt: ShortInt *);
  type
    Tree_Ptr  = ^Tree_List;
    Tree_List = Record
                  prev_limb       :Tree_Ptr;
                  branch          :String[50];
                  QK              :String[1];
                  next_limb       :Tree_Ptr;
                End;

    Tree_Level= Record
                  one             :String[14];
                  two             :String[28];
                  three           :String[42];
                  four            :String[66];
                End;

    Dtarec    = Record
                   reserved: array[1..21] of char;
                   attr    : byte;
                   other   : array[1..4] of integer;
                   name    : array[1..13] of char;
                 End;

  const
     NUL      =#0;    {Null Character}
     BELL     =#7;    {Causes a beep when output to terminal}
     CR       =#13;   {Carraige Return}
     ESC      =#27;   {Escape character}
     SPC      =#32;   {Space Bar}
     UPARROW  =#72;
     DNARROW  =#80;
     LTARROW  =#75;
     RTARROW  =#77;
     END_KEY  =#79;
     HME      =#71;
     PGUP     =#73;
     PGDN     =#81;
     TAG      =#251;
     SHADE    =#177;
     SHADE1   =#176;
     F1       =#59;
     F2       =#60;

  var
    dta                             : Array[1..32] of dtarec;
    first_branch,
    new_branch,
    last_branch                     : Tree_Ptr;
    Tree_Depth                      : Tree_Level;

    TreeFile                        : Text;
    s                               : String[6];
    DriveNum                        : Byte;

    namestr,
    string1                         : String[80];
    string2                         : String[80];
    i,
    depth,
    total                           : Integer;
    ch,
    ch1                             : Char;

    regs                            : Registers;
    QuickKeyFound,
    Done,HardDrive                  : Boolean;


  {---------------------------------------------------------------------------}
   Procedure SetDta (level:integer);
      var
        regs         : Registers;
      begin
        with regs do begin
          AX:=$1A00;
          DX:=ofs(dta[level]);
          DS:=seg(dta[level]);
          intr($21,regs);
        end;
      end;{Setdta}

  {------------------------------------------------------------------------}
    Function FindFirst (search: AnyString; level:integer): Integer;
      var
         regs             : Registers;
      begin
        setdta (level);
        with regs do begin
          AX:=$4E00;
          CX:=$0010;
          DX:=ofs(search)+1;
          DS:=seg(search);
          intr($21,regs);
          if ((Flags and 1)=0) then
            findfirst:=0
          else
            findfirst:=AX;
        end;
      end; {Findfirst}

  {------------------------------------------------------------------------}
    Function FindNext (level:integer):integer;
      var
         regs         : Registers;
      begin
        setdta (level);
        with regs do begin
          AX:=$4F00;
          intr($21,regs);
          if ((Flags and 1)=0) then
            findnext:=0
          else
            findnext:=AX;
        end;
      end; {Find Next}

  {------------------------------------------------------------------------}
    Procedure Put_Branch_In_Heap;
      begin
        new(new_branch);                {Create record in Heap}
        new_branch^.QK:=namestr[2];
        Case depth of
          1: begin
               tree_depth.one:=namestr;
               new_branch^.branch:=namestr;
             end;
          2: begin
               tree_depth.two:=tree_depth.one+namestr;
               new_branch^.branch:=tree_depth.two;
             end;
          3: begin
               tree_depth.three:=tree_depth.two+namestr;
               new_branch^.branch:=tree_depth.three;
             end;
          4: begin
               tree_depth.four:=tree_depth.three+namestr;
               new_branch^.branch:=tree_depth.four;
             end;
        end; {Case depth of}

        if first_branch=nil then begin
          first_branch:=new_branch;
          new_branch^.prev_limb:=nil;
          new_branch^.QK:=' ';
        end
        else begin
          last_branch^.next_limb:=new_branch;
          new_branch^.prev_limb:=last_branch;
        end;

        last_branch:=new_branch;
        last_branch^.next_limb:=nil;

        writeln(TreeFile,new_branch^.QK,' ',new_branch^.branch);
      end; {Put Branch in Heap}
  {------------------------------------------------------------------------}
    Function Listdir(search:AnyString; level:integer): integer;

       Var
         i, retcode:  integer;

       begin
         retcode:=findfirst(concat(search,'\*.*'#0), level);
         if retcode=18 then
           listdir:=0
         else
           if retcode<>0 then listdir:=1
         else begin
            repeat with dta[level] do begin
              if (attr=$10) and (name[1]<>'.') then begin
                namestr[0]:=#13;
                for i:=1 to 13 do namestr[i]:=name[i];
                  namestr[0]:=chr(pos(#0,namestr)-1);
                  namestr:=concat('\',namestr);
                  depth:=level;
                  Put_Branch_In_Heap;
                  total:=total+1;
                  retcode:=listdir(concat(search,namestr),level+1);
                end;
              end;
            until (findnext (level)=18);
            listdir:=0;
         end;
       end; {List dir}

  {-------------------------------------------------------------------------}
  Procedure GetSubdirectories(drive: Char);
      begin
        total:=1;
        first_branch:=nil;

        namestr:='\';             {Store Root Directory in Heap}
        depth:=1;
        Put_Branch_In_Heap;

        tree_depth.one   :=#0;
        tree_depth.two   :=#0;
        tree_depth.three :=#0;
        tree_depth.four  :=#0;

        string1:=drive+':';
        if listdir(string1,1)=1 then writeln('Incorrect paratmeter');
      end; {Get Subdirectories}

  {------------------------------------------------------------------------}

   begin
     CursorOff;
     ClearBox(x1,y1,x1+43,y1+7,Main,3,True);

     PutStr('Drive & Subdirectory',x1+12,y1+2,Main);
     PutStr('Searching Subdirectories',x1+10,y1+4,Main+128);

    {------------------ Determine if it is a Hard Disk -----------------}
     Drive:=UpCase(Drive);
     DriveNum:=ord(Drive)-64;
     with regs do begin
       AH:=$1C;            {Function code for get FAT information}
       DL:=DriveNum;      {disk drive number, 0=Default 1=a}
       MsDos(Regs);

       if Mem[DS:BX]=248 then
         HardDrive:=True
       else
         HardDrive:=False;
     end; {with regs}
    {-------------------------------------------------------------------}
     s:=Drive+'.ezd';
     Assign(TreeFile,s);
     {$I-}
       Reset(TreeFile);
     {$I+}
     if (IOResult=0) and (HardDrive) then begin
       Close(TreeFile);
       total:=0;
       first_branch:=nil;
       Assign(TreeFile,s);
       Reset(TreeFile);
         while not eof(TreeFile) do begin
           new(new_branch);
           readln(TreeFile,string2);
           total:=total+1;

           new_branch^.QK:=string2[1];
           delete(string2,1,2);
           new_branch^.branch:=string2;
           if first_branch=nil then begin
             first_branch:=new_branch;
             new_branch^.prev_limb:=nil;
           end  {if first branch=nil}
           else begin
             last_branch^.next_limb:=new_branch;
             new_branch^.prev_limb:=last_branch;
           end; {if first branch<>nil}

           last_branch:=new_branch;
           last_branch^.next_limb:=nil;
         end;  {while not EOF}
       Close(TreeFile);
     end
     else begin
       Assign(TreeFile,s);
       Rewrite(TreeFile);
         total:=0;
         GetSubdirectories(drive);
       Close(TreeFile);
     end; {if File Does Not Exist}
     y1:=y1+4;
     RemBlkR(x1+10,y1,x1+41,y1,Main,False);

     if total=1 then begin
       PutStr('Detect only Root Directory',x1+9,y1,Main+128);
       delay(500);
       sub:=drive+':';
       exit;
     end;
     new_branch:=first_branch;
     if FromAltF10 then begin
       if SourceSubDown=0 then
         new_branch:=first_branch
       else begin
         for i:=1 to SourceSubDown do begin
           with new_branch^ do begin
             new_branch:=next_limb;
           end; {with new_branch do}
         end; {for i=1 to SourceSubDown}
       end; {if SourceSubDown<>0}
     end {if AltF10 was depressed}
     else
       SourceSubDown:=0;

     with new_branch^ do  begin
       string1:=drive+':'+branch;
       PutStr(string1,x1+3,y1,High);
     end;

   Done:=False;
     while (not Done) do begin

       ch:=ReadKey;
       ch:=UpCase(ch);
         Case ch of
           NUL: begin
                   ch:=ReadKey;
                Case ch of
                   HME   : begin  {HOME key}
                              new_branch:=first_branch;
                              SourceSubDown:=0;
                              with new_branch^ do begin
                                RemBlkR(x1+3,y1,x1+42,y1,Main,False);
                                string1:=drive+':'+branch;
                                PutStr(string1,x1+3,y1,High);
                              end;
                            end;
                   END_KEY: begin   {END key}
                              new_branch:=first_branch;
                              SourceSubDown:=0;
                              repeat
                                with new_branch^ do begin
                                  inc(SourceSubDown);
                                  new_branch:=next_limb;
                                end;
                              until new_branch=last_branch;
                              with new_branch^ do begin
                                RemBlkR(x1+3,y1,x1+42,y1,Main,False);
                                string1:=drive+':'+branch;
                                PutStr(string1,x1+3,y1,High);
                              end;
                            end;
                   DNARROW,         {Down Arrow Key}
                   RTARROW: begin   {Right Arrow Key}
                              if new_branch^.next_limb=nil then begin
                                 new_branch:=first_branch;
                                 SourceSubDown:=0;
                               end
                               else begin
                                 new_branch:=new_branch^.next_limb;
                                 inc(SourceSubDown);
                              end;
                              with new_branch^ do begin
                                RemBlkR(x1+3,y1,x1+42,y1,Main,False);
                                string1:=drive+':'+branch;
                                PutStr(string1,x1+3,y1,High);
                              end;
                            end; {Right & Down Arrow}
                   UPARROW,
                   LTARROW: begin
                              if new_branch^.prev_limb=nil then begin
                                new_branch:=first_branch;
                                SourceSubDown:=0;
                                repeat
                                  with new_branch^ do begin
                                    inc(SourceSubDown);
                                    new_branch:=next_limb;
                                  end;
                                until new_branch=last_branch;
                              end
                              else begin
                                new_branch:=new_branch^.prev_limb;
                                dec(SourceSubDown);
                              end;
                              with new_branch^ do begin
                                RemBlkR(x1+3,y1,x1+42,y1,Main,False);
                                string1:=drive+':'+branch;
                                PutStr(string1,x1+3,y1,High);
                              end;
                            end; {Up Arrow & Left Key}
                        F1: begin
                              SaveScreen(2);
                              ClearBox(23,5,58,18,HelpAtt,2,False);
                              PutStr('-- Help Screen --',32,6,HelpAtt);
                              PutStr('F1 - This Help Screen',32,8,HelpAtt);
                              PutStr('F9 - To DOS',32,9,HelpAtt);
                              PutStr(chr(25),27,10,HelpAtt);
                              PutStr(chr(26),31,10,HelpAtt);
                              PutStr('- Next Subdirectory',35,10,HelpAtt);
                              PutStr(chr(24),27,11,HelpAtt);
                              PutStr(chr(27),31,11,HelpAtt);
                              PutStr('- Prev. Subdirectory',35,11,HelpAtt);
                              PutStr('HOME - Root Directory',30,12,HelpAtt);
                              PutStr('END  - Last Subdirectory',30,13,HelpAtt);

                              PutStr('<RETURN> - Select Subdirectory',26,14,HelpAtt);
                              PutStr(' (Depress Any Key to Continue) ',26,16,15);
                              ch1:=ReadKey;
                              RestoreScreen(2);
                            end;
                   else
                     write(BELL);
                end; {Case scan of}
              end; {case c=0}
         ESC : begin                {Esc}
                 EscDepressed:=True;
                 FromAltF10:=False;
                 exit;
               end;
         SPC : begin
                 if new_branch^.next_limb=nil then begin
                   new_branch:=first_branch;
                   SourceSubDown:=0;
                 end
                 else begin
                   new_branch:=new_branch^.next_limb;
                   inc(SourceSubDown);
                 end;
                 with new_branch^ do begin
                   RemBlkR(x1+3,y1,x1+42,y1,Main,False);
                   string1:=drive+':'+branch;
                   PutStr(string1,x1+3,y1,High);
                 end;
               end; {Space Bar}
           CR: begin   {Carraige Return}
                 sub:=string1;
                 FromAltF10:=False;
                 Done:=True;
               end;
           '-','_',
           '!','#'..')','@',
           'A'..'Z',
           '0'..'9': begin
                       QuickKeyFound:=False;
                       i:=SourceSubDown+1;
                       new_branch:=new_branch^.next_limb;
                       if new_branch<>nil then begin
                         repeat
                           if new_branch^.QK=ch then begin
                             QuickKeyFound:=True;
                             SourceSubDown:=i;
                           end
                           else begin
                             inc(i);
                             new_branch:=new_branch^.next_limb;
                           end;
                         until (QuickKeyFound) or (new_branch=nil);
                       end; {if not end of tree}
                      {If QuickKey not found search from top of Tree}
                       if not QuickKeyFound then begin
                         i:=0;
                         new_branch:=first_branch;
                         repeat
                           if new_branch^.QK=ch then begin
                             QuickKeyFound:=True;
                             SourceSubDown:=i;
                           end
                           else begin
                             inc(i);
                             new_branch:=new_branch^.next_limb;
                           end;
                         until (i=SourceSubDown) or (QuickKeyFound);
                       end; {Have not found QuickKey - go top of tree}
                      {------ Display Subdirectory if Found ------}
                       if QuickKeyFound then begin
                         with new_branch^ do begin
                           RemBlkR(x1+3,y1,x1+42,y1,Main,False);
                           string1:=drive+':'+branch;
                           PutStr(string1,x1+3,y1,High);
                         end;
                       end {Found Quick Key so Display it}
                       else
                         write(BELL);
                     end; {Possible QuickKey}
           else
             write(BELL);
         end; {Case c of}
     end; {while not Done}

    {----------------- Reclaim Heap from Subdirectories ------------------}
     new_branch:=first_branch;
     while new_branch<>nil do begin
       with new_branch^ do last_branch:=next_limb;
       dispose(new_branch);
       new_branch:=last_branch;
     end;

   end; {Choose Drive & Subdirectory}

{--------------------------------------------------------------------------}
Procedure FindSubdirectory(* drive: Char *);

  type

    Tree_Level= Record
                  one             :String[14];
                  two             :String[28];
                  three           :String[42];
                  four            :String[66];
                End;

    Dtarec    = Record
                   reserved: array[1..21] of char;
                   attr    : byte;
                   other   : array[1..4] of integer;
                   name    : array[1..13] of char;
                 End;


  var
    dta                             : Array[1..32] of dtarec;

    Tree_Depth                      : Tree_Level;

    TreeFile                        : Text;
    s                               : String[6];
    DriveNum                        : Byte;

    namestr,
    string1                         : String[13];
    string2                         : String[80];
    depth,
    total                           : Integer;
    ch,
    ch1                             : Char;

    regs                            : Registers;
    Done,HardDrive                  : Boolean;


  {---------------------------------------------------------------------------}
   Procedure SetDta (level:integer);
      var
        regs         : Registers;
      begin
        with regs do begin
          AX:=$1A00;
          DX:=ofs(dta[level]);
          DS:=seg(dta[level]);
          intr($21,regs);
        end;
      end;{Setdta}

  {------------------------------------------------------------------------}
    Function FindFirst (search: AnyString; level:integer): Integer;
      var
         regs             : Registers;
      begin
        setdta (level);
        with regs do begin
          AX:=$4E00;
          CX:=$0010;
          DX:=ofs(search)+1;
          DS:=seg(search);
          intr($21,regs);
          if ((Flags and 1)=0) then
            findfirst:=0
          else
            findfirst:=AX;
        end;
      end; {Findfirst}

  {------------------------------------------------------------------------}
    Function FindNext (level:integer):integer;
      var
         regs         : Registers;
      begin
        setdta (level);
        with regs do begin
          AX:=$4F00;
          intr($21,regs);
          if ((Flags and 1)=0) then
            findnext:=0
          else
            findnext:=AX;
        end;
      end; {Find Next}

  {------------------------------------------------------------------------}
    Function Listdir(search:AnyString; level:integer): integer;

       Var
         i, retcode:  integer;

       begin
         retcode:=findfirst(concat(search,'\*.*'#0), level);
         if retcode=18 then
           listdir:=0
         else
           if retcode<>0 then listdir:=1
         else begin
            repeat with dta[level] do begin
              if (attr=$10) and (name[1]<>'.') then begin
                namestr[0]:=#13;
                for i:=1 to 13 do namestr[i]:=name[i];
                  namestr[0]:=chr(pos(#0,namestr)-1);
                  namestr:=concat('\',namestr);
                  string2:=namestr[2];

                  depth:=level;
                  Case depth of
                     1: begin
                          tree_depth.one:=namestr;
                          writeln(TreeFile,string2,' ',tree_depth.one);
                        end;
                     2: begin
                          tree_depth.two:=tree_depth.one+namestr;
                          writeln(TreeFile,string2,' ',tree_depth.two);
                        end;
                     3: begin
                          tree_depth.three:=tree_depth.two+namestr;
                          writeln(TreeFile,string2,' ',tree_depth.three);
                        end;
                     4: begin
                          tree_depth.four:=tree_depth.three+namestr;
                          writeln(TreeFile,string2,' ',tree_depth.four);
                        end;
                  end; {Case depth of}

                  total:=total+1;
                  retcode:=listdir(concat(search,namestr),level+1);
                end;
              end;
            until (findnext (level)=18);
            listdir:=0;
         end;
       end; {List dir}

  {-------------------------------------------------------------------------}
  Procedure GetSubdirectories(drive: Char);
      begin
        total:=1;

        namestr:='\';             {Store Root Directory in Heap}
        depth:=1;
        writeln(TreeFile,'  \');

        tree_depth.one   :=#0;
        tree_depth.two   :=#0;
        tree_depth.three :=#0;
        tree_depth.four  :=#0;

        string1:=drive+':';
        if listdir(string1,1)=1 then writeln('Incorrect paratmeter');
      end; {Get Subdirectories}

  {------------------------------------------------------------------------}

   begin
     CursorOff;

     s:=Drive+'.ezd';
     Assign(TreeFile,s);
     {$I-}
       Reset(TreeFile);
     {$I+}
     if IOResult=0 then begin
       Close(TreeFile);
     end
     else begin
       Assign(TreeFile,s);
       Rewrite(TreeFile);
         total:=0;
         GetSubdirectories(drive);
       Close(TreeFile);
     end; {if File Does Not Exist}
   end; {FindSubdirectory}
{--------------------------------------------------------------------------}

BEGIN

END.


